/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.config;

import java.util.HashMap;
import javax.sql.DataSource;
import org.egov.adtax.service.scheduler.jobs.GenerateDemandForAdvertisementTaxJob;
import org.egov.infra.config.scheduling.QuartzSchedulerConfiguration;
import org.egov.infra.config.scheduling.SchedulerConfigCondition;
import org.quartz.Trigger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@Conditional(value={SchedulerConfigCondition.class})
public class AdTaxSchedulerConfiguration
extends QuartzSchedulerConfiguration {
    @Bean(destroyMethod="destroy")
    public SchedulerFactoryBean adTaxScheduler(DataSource dataSource) {
        SchedulerFactoryBean adTaxScheduler = this.createScheduler(dataSource);
        adTaxScheduler.setSchedulerName("adtax-scheduler");
        adTaxScheduler.setAutoStartup(true);
        adTaxScheduler.setOverwriteExistingJobs(true);
        adTaxScheduler.setTriggers(new Trigger[]{this.adtaxDemandGenerationCronTrigger().getObject()});
        return adTaxScheduler;
    }

    @Bean(value={"generateDemandForAdvertisementTaxJob"})
    public GenerateDemandForAdvertisementTaxJob generateDemandForAdvertisementTaxJob() {
        return new GenerateDemandForAdvertisementTaxJob();
    }

    @Bean
    public JobDetailFactoryBean adtaxDemandGenerationJobDetail() {
        JobDetailFactoryBean adtaxDemandGenerationJobDetail = new JobDetailFactoryBean();
        adtaxDemandGenerationJobDetail.setGroup("ADTAX_JOB_GROUP");
        adtaxDemandGenerationJobDetail.setName("ADTAX_DEMAND_GENERATION_JOB");
        adtaxDemandGenerationJobDetail.setDurability(true);
        adtaxDemandGenerationJobDetail.setJobClass(GenerateDemandForAdvertisementTaxJob.class);
        adtaxDemandGenerationJobDetail.setRequestsRecovery(true);
        HashMap<String, String> jobDetailMap = new HashMap<String, String>();
        jobDetailMap.put("jobBeanName", "generateDemandForAdvertisementTaxJob");
        jobDetailMap.put("userName", "egovernments");
        jobDetailMap.put("cityDataRequired", "true");
        jobDetailMap.put("moduleName", "adtax");
        adtaxDemandGenerationJobDetail.setJobDataAsMap(jobDetailMap);
        return adtaxDemandGenerationJobDetail;
    }

    @Bean
    public CronTriggerFactoryBean adtaxDemandGenerationCronTrigger() {
        CronTriggerFactoryBean demandGenerationCron = new CronTriggerFactoryBean();
        demandGenerationCron.setJobDetail(this.adtaxDemandGenerationJobDetail().getObject());
        demandGenerationCron.setGroup("ADTAX_TRIGGER_GROUP");
        demandGenerationCron.setName("ADTAX_DEMAND_GENERATION_TRIGGER");
        demandGenerationCron.setCronExpression("0 */30 * * * ?");
        demandGenerationCron.setMisfireInstruction(2);
        return demandGenerationCron;
    }
}

