/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.adtax.entity.AgencyWiseCollection;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.AbstractBillable;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Scope(value="prototype")
@Transactional(readOnly=true)
public class AgencyWiseBillable
extends AbstractBillable
implements Billable {
    private static final Logger LOGGER = Logger.getLogger(AgencyWiseBillable.class);
    public static final String FEECOLLECTIONMESSAGE = "Fee Collection : Agency Name-";
    private static final String CITY_BOUNDARY_TYPE = "City";
    private String referenceNumber;
    private String transanctionReferenceNumber;
    @Autowired
    private ModuleService moduleService;
    private AgencyWiseCollection agencyWiseCollection;
    @Autowired
    private HierarchyTypeService hierarchyTypeService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private EgBillDao egBillDAO;

    public String getBillPayee() {
        if (this.agencyWiseCollection != null && this.agencyWiseCollection.getAgency() != null) {
            return this.agencyWiseCollection.getAgency().getName();
        }
        return null;
    }

    public String getBillAddress() {
        if (this.agencyWiseCollection != null && this.agencyWiseCollection.getAgency() != null && this.agencyWiseCollection.getAgency().getAddress() != null) {
            return this.agencyWiseCollection.getAgency().getAddress();
        }
        return "";
    }

    public EgDemand getCurrentDemand() {
        if (this.agencyWiseCollection != null && this.agencyWiseCollection.getAgencyWiseDemand() != null) {
            return this.agencyWiseCollection.getAgencyWiseDemand();
        }
        return null;
    }

    public String getEmailId() {
        return "";
    }

    public List<EgDemand> getAllDemands() {
        ArrayList<EgDemand> demands = new ArrayList<EgDemand>();
        if (this.getCurrentDemand() != null) {
            demands.add(this.getCurrentDemand());
        }
        return demands;
    }

    public EgBillType getBillType() {
        return this.egBillDAO.getBillTypeByCode("AUTO");
    }

    public Date getBillLastDueDate() {
        return DateUtils.today();
    }

    public Long getBoundaryNum() {
        Boundary boundary = this.getBoundaryAsCity();
        if (boundary != null) {
            return boundary.getBoundaryNum();
        }
        return null;
    }

    private Boundary getBoundaryAsCity() {
        HierarchyType hType = null;
        hType = this.hierarchyTypeService.getHierarchyTypeByName("ADMINISTRATION");
        List locationList = null;
        if (hType != null) {
            BoundaryType bType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyType(CITY_BOUNDARY_TYPE, hType);
            if (bType != null) {
                locationList = this.boundaryService.getActiveBoundariesByBoundaryTypeId(bType.getId());
            }
            if (locationList != null && locationList.size() > 0) {
                return (Boundary)locationList.get(0);
            }
        }
        return null;
    }

    public String getBoundaryType() {
        Boundary boundary = this.getBoundaryAsCity();
        if (boundary != null) {
            return boundary.getBoundaryType().getName();
        }
        return null;
    }

    public String getDepartmentCode() {
        return "REV";
    }

    public BigDecimal getFunctionaryCode() {
        return new BigDecimal("1");
    }

    public String getFundCode() {
        return "01";
    }

    public String getFundSourceCode() {
        return "01";
    }

    public Date getIssueDate() {
        return new Date();
    }

    public Date getLastDate() {
        return new Date();
    }

    public Module getModule() {
        return this.moduleService.getModuleByName("Advertisement Tax");
    }

    public Boolean getOverrideAccountHeadsAllowed() {
        return Boolean.FALSE;
    }

    public Boolean getPartPaymentAllowed() {
        return Boolean.FALSE;
    }

    public String getServiceCode() {
        return "ADTAX";
    }

    public BigDecimal getTotalAmount() {
        BigDecimal balance = BigDecimal.ZERO;
        if (this.agencyWiseCollection != null && this.agencyWiseCollection.getTotalAmount() != null) {
            balance = this.agencyWiseCollection.getTotalAmount();
        }
        return balance;
    }

    public Long getUserId() {
        return ApplicationThreadLocals.getUserId() == null ? null : Long.valueOf(ApplicationThreadLocals.getUserId());
    }

    public String getDescription() {
        StringBuffer description = new StringBuffer();
        if (this.agencyWiseCollection != null && this.agencyWiseCollection.getAgency() != null) {
            description.append(FEECOLLECTIONMESSAGE);
            description.append(this.agencyWiseCollection.getAgency() != null ? this.agencyWiseCollection.getAgency().getName() : "");
        }
        return description.toString();
    }

    public String getDisplayMessage() {
        return "Fee Collection";
    }

    public String getCollModesNotAllowed() {
        return null;
    }

    public String getConsumerId() {
        if (this.agencyWiseCollection != null) {
            return "AGENCY-".concat(this.agencyWiseCollection.getId().toString());
        }
        return null;
    }

    public String getConsumerType() {
        return "";
    }

    public Boolean isCallbackForApportion() {
        return Boolean.FALSE;
    }

    public void setCallbackForApportion(Boolean b) {
        throw new IllegalArgumentException("Apportioning is always TRUE and shouldn't be changed");
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public AgencyWiseCollection getAgencyWiseCollection() {
        return this.agencyWiseCollection;
    }

    public void setAgencyWiseCollection(AgencyWiseCollection agencyWiseCollection) {
        this.agencyWiseCollection = agencyWiseCollection;
    }

    public String getTransanctionReferenceNumber() {
        return this.transanctionReferenceNumber;
    }

    public void setTransanctionReferenceNumber(String transanctionReferenceNumber) {
        this.transanctionReferenceNumber = transanctionReferenceNumber;
    }
}

