/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.AbstractBillable;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Scope(value="prototype")
@Transactional(readOnly=true)
public class AdvertisementBillable
extends AbstractBillable
implements Billable {
    private static final Logger LOGGER = Logger.getLogger(AdvertisementBillable.class);
    private String referenceNumber;
    private String transanctionReferenceNumber;
    @Autowired
    private ModuleService moduleService;
    private Advertisement advertisement;
    private String collectionType;
    @Autowired
    private EgBillDao egBillDAO;

    public String getBillPayee() {
        AdvertisementPermitDetail advPermit = this.advertisement.getActiveAdvertisementPermit();
        if (this.advertisement != null) {
            if (this.collectionType != null && advPermit != null && "Advertisement".equalsIgnoreCase(this.collectionType)) {
                return advPermit.getAgency() != null && advPermit.getAgency().getName() != null ? advPermit.getAgency().getName() : (advPermit.getOwnerDetail() != null ? advPermit.getOwnerDetail() : " ");
            }
            return advPermit != null && advPermit.getAgency() != null && advPermit.getAgency().getName() != null ? advPermit.getAgency().getName() : " ";
        }
        return null;
    }

    public String getBillAddress() {
        AdvertisementPermitDetail advPermit = this.advertisement.getActiveAdvertisementPermit();
        if (this.advertisement != null) {
            if (this.collectionType != null && "Advertisement".equalsIgnoreCase(this.collectionType)) {
                return advPermit != null && advPermit.getAgency() != null && advPermit.getAgency().getAddress() != null ? advPermit.getAgency().getAddress() : (advPermit != null && advPermit.getOwnerDetail() != null ? advPermit.getOwnerDetail() : " ");
            }
            return advPermit != null && advPermit.getAgency() != null && advPermit.getAgency().getAddress() != null ? advPermit.getAgency().getAddress() : " ";
        }
        return null;
    }

    public EgDemand getCurrentDemand() {
        return this.advertisement != null ? this.advertisement.getDemandId() : null;
    }

    public String getEmailId() {
        return "";
    }

    public List<EgDemand> getAllDemands() {
        ArrayList<EgDemand> demands = new ArrayList<EgDemand>();
        if (this.getCurrentDemand() != null) {
            demands.add(this.getCurrentDemand());
        }
        return demands;
    }

    public EgBillType getBillType() {
        return this.egBillDAO.getBillTypeByCode("AUTO");
    }

    public Date getBillLastDueDate() {
        return DateUtils.today();
    }

    public Long getBoundaryNum() {
        if (this.advertisement != null && this.advertisement.getWard() != null) {
            return this.advertisement.getWard().getBoundaryNum();
        }
        return null;
    }

    public String getBoundaryType() {
        if (this.advertisement != null && this.advertisement.getWard() != null && this.advertisement.getWard().getBoundaryType() != null) {
            return this.advertisement.getWard().getBoundaryType().getName();
        }
        return null;
    }

    public String getDepartmentCode() {
        return "REV";
    }

    public BigDecimal getFunctionaryCode() {
        return new BigDecimal("1");
    }

    public String getFundCode() {
        return "01";
    }

    public String getFundSourceCode() {
        return "1";
    }

    public Date getIssueDate() {
        return new Date();
    }

    public Date getLastDate() {
        return this.advertisement != null && this.advertisement.getPenaltyCalculationDate() != null ? this.advertisement.getPenaltyCalculationDate() : null;
    }

    public Module getModule() {
        return this.moduleService.getModuleByName("Advertisement Tax");
    }

    public Boolean getOverrideAccountHeadsAllowed() {
        return Boolean.FALSE;
    }

    public Boolean getPartPaymentAllowed() {
        return Boolean.FALSE;
    }

    public String getServiceCode() {
        return "ADTAX";
    }

    public BigDecimal getTotalAmount() {
        BigDecimal balance = BigDecimal.ZERO;
        if (this.advertisement != null && this.advertisement.getDemandId() != null) {
            for (EgDemandDetails det : this.advertisement.getDemandId().getEgDemandDetails()) {
                BigDecimal dmdAmt = det.getAmount();
                BigDecimal collAmt = det.getAmtCollected();
                balance = balance.add(dmdAmt.subtract(collAmt));
            }
        }
        return balance;
    }

    public Long getUserId() {
        return ApplicationThreadLocals.getUserId() == null ? null : Long.valueOf(ApplicationThreadLocals.getUserId());
    }

    public String getDescription() {
        StringBuffer description = new StringBuffer();
        if (this.advertisement != null) {
            description.append("Fee Collection : Advertisement Number -");
            description.append(this.advertisement.getAdvertisementNumber() != null ? this.advertisement.getAdvertisementNumber() : "");
        }
        return description.toString();
    }

    public String getDisplayMessage() {
        return "Fee Collection";
    }

    public String getCollModesNotAllowed() {
        return null;
    }

    public String getConsumerId() {
        if (this.advertisement != null) {
            return this.advertisement.getId().toString();
        }
        return null;
    }

    public Boolean isCallbackForApportion() {
        return Boolean.FALSE;
    }

    public void setCallbackForApportion(Boolean b) {
        throw new IllegalArgumentException("Apportioning is always TRUE and shouldn't be changed");
    }

    public Advertisement getAdvertisement() {
        return this.advertisement;
    }

    public void setAdvertisement(Advertisement advertisement) {
        this.advertisement = advertisement;
    }

    public String getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(String collectionType) {
        this.collectionType = collectionType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getConsumerType() {
        return "";
    }

    public String getTransanctionReferenceNumber() {
        return this.transanctionReferenceNumber;
    }

    public void setTransanctionReferenceNumber(String transanctionReferenceNumber) {
        this.transanctionReferenceNumber = transanctionReferenceNumber;
    }
}

