/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.entity;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.enums.AgencyStatus;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGADTAX_AGENCY")
@SequenceGenerator(name="SEQ_EGADTAX_AGENCY", sequenceName="SEQ_EGADTAX_AGENCY", allocationSize=1)
@Unique(id="id", tableName="EGADTAX_AGENCY", columnName={"code", "name"}, fields={"code", "name"}, enableDfltMsg=true, message="Already Exist.Value should be unique.")
public class Agency
extends AbstractAuditable {
    private static final long serialVersionUID = 4958014584254475596L;
    public static final String SEQ_AGENCY = "SEQ_EGADTAX_AGENCY";
    @Id
    @GeneratedValue(generator="SEQ_EGADTAX_AGENCY", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @Column(name="code", unique=true, updatable=false)
    @SafeHtml
    private String code;
    @NotNull
    @Column(name="name", unique=true)
    @SafeHtml
    private String name;
    @SafeHtml
    private String ssId;
    @Email(regexp="^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$")
    @Length(max=128)
    @SafeHtml
    private String emailId;
    @NotNull
    @Pattern(regexp="^((\\+)?(\\d{2}[-]))?(\\d{10}){1}?$")
    @Length(max=15)
    @SafeHtml
    private String mobileNumber;
    @SafeHtml
    private String address;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private AgencyStatus status;
    @NotNull
    private Double depositAmount;
    @OrderBy(value="ID DESC")
    @OneToMany(mappedBy="agency", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Set<AdvertisementPermitDetail> advertisementPermits = new HashSet<AdvertisementPermitDetail>(0);

    public Set<AdvertisementPermitDetail> getAdvertisementPermits() {
        return this.advertisementPermits;
    }

    public void setAdvertisementPermits(Set<AdvertisementPermitDetail> advertisementPermits) {
        this.advertisementPermits = advertisementPermits;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSsId() {
        return this.ssId;
    }

    public void setSsId(String ssId) {
        this.ssId = ssId;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public AgencyStatus getStatus() {
        return this.status;
    }

    public void setStatus(AgencyStatus status) {
        this.status = status;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Double getDepositAmount() {
        return this.depositAmount;
    }

    public void setDepositAmount(Double depositAmount) {
        this.depositAmount = depositAmount;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Agency other = (Agency)((Object)obj);
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

