/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.penalty;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.adtax.entity.AdvertisementAdditionalTaxRate;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.service.AdvertisementAdditinalTaxRateService;
import org.egov.adtax.service.penalty.AdvertisementAdditionalTaxCalculator;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementAdditionalTaxCalculatorImpl
implements AdvertisementAdditionalTaxCalculator {
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private AdvertisementAdditinalTaxRateService advertisementAdditinalTaxRateService;

    private Boolean serviceTaxAndCessCalculationRequired() {
        AppConfigValues isServiceTaxAndCessCollectionRequired = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "Service Tax And Cess Collection required").get(0);
        if (isServiceTaxAndCessCollectionRequired != null && "YES".equalsIgnoreCase(isServiceTaxAndCessCollectionRequired.getValue())) {
            return true;
        }
        return false;
    }

    @Override
    public Map<String, BigDecimal> getAdditionalTaxes(AdvertisementPermitDetail advPermitDetail) {
        HashMap<String, BigDecimal> additionalTaxes = new HashMap<String, BigDecimal>();
        BigDecimal curntInsServiceTax = BigDecimal.ZERO;
        BigDecimal curntInsSwachBharatCess = BigDecimal.ZERO;
        BigDecimal curntInsKrishiKalyanCess = BigDecimal.ZERO;
        BigDecimal curntInsTotalTaxableAmt = BigDecimal.ZERO;
        BigDecimal arrInsServiceTax = BigDecimal.ZERO;
        BigDecimal arrInsSwachBharatCess = BigDecimal.ZERO;
        BigDecimal arrInsKrishiKalyanCess = BigDecimal.ZERO;
        BigDecimal arrInsTotalTaxableAmt = BigDecimal.ZERO;
        Installment currentInstallemnt = advPermitDetail.getAdvertisement().getDemandId().getEgInstallmentMaster();
        List<AdvertisementAdditionalTaxRate> additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
        if (this.serviceTaxAndCessCalculationRequired().booleanValue()) {
            for (AdvertisementAdditionalTaxRate advertisementAdditionalTaxRate : additionalTaxRates) {
                additionalTaxes.put(advertisementAdditionalTaxRate.getReasonCode(), advertisementAdditionalTaxRate.getPercentage());
            }
            for (EgDemandDetails egDemandDetails : advPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                if (egDemandDetails.getBalance().compareTo(BigDecimal.ZERO) <= 0) continue;
                if (currentInstallemnt != null && currentInstallemnt.getDescription().equals(egDemandDetails.getEgDemandReason().getEgInstallmentMaster().getDescription())) {
                    if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Arrear_Adv_Tax")) {
                        arrInsTotalTaxableAmt = arrInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                        continue;
                    }
                    curntInsTotalTaxableAmt = curntInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                    continue;
                }
                arrInsTotalTaxableAmt = arrInsTotalTaxableAmt.add(egDemandDetails.getBalance());
            }
            for (Map.Entry entry : additionalTaxes.entrySet()) {
                if ("Service_Tax".equalsIgnoreCase((String)entry.getKey())) {
                    curntInsServiceTax = this.calculateAdditionalTaxes(curntInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                    arrInsServiceTax = this.calculateAdditionalTaxes(arrInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                    continue;
                }
                if ("ADTAX_SB_CESS".equalsIgnoreCase((String)entry.getKey())) {
                    curntInsSwachBharatCess = this.calculateAdditionalTaxes(curntInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                    arrInsSwachBharatCess = this.calculateAdditionalTaxes(arrInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                    continue;
                }
                if (!"ADTAX_KRISHI_CES".equalsIgnoreCase((String)entry.getKey())) continue;
                curntInsKrishiKalyanCess = this.calculateAdditionalTaxes(curntInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                arrInsKrishiKalyanCess = this.calculateAdditionalTaxes(arrInsTotalTaxableAmt, (BigDecimal)entry.getValue());
            }
            additionalTaxes.put("Service_Tax", curntInsServiceTax.add(arrInsServiceTax));
            additionalTaxes.put("ADTAX_SB_CESS", curntInsSwachBharatCess.add(arrInsSwachBharatCess));
            additionalTaxes.put("ADTAX_KRISHI_CES", curntInsKrishiKalyanCess.add(arrInsKrishiKalyanCess));
        }
        return additionalTaxes;
    }

    private BigDecimal calculateAdditionalTaxes(BigDecimal curntInsTotalTaxableAmt, BigDecimal entry) {
        return entry.multiply(curntInsTotalTaxableAmt).divide(BigDecimal.valueOf(100L)).setScale(0, 4);
    }

    private Map<String, BigDecimal> getAdditionalTaxRates() {
        HashMap<String, BigDecimal> additionalTaxes = new HashMap<String, BigDecimal>();
        List<AdvertisementAdditionalTaxRate> additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
        for (AdvertisementAdditionalTaxRate taxRates : additionalTaxRates) {
            additionalTaxes.put(taxRates.getReasonCode(), taxRates.getPercentage());
        }
        return additionalTaxes;
    }

    private Map<Installment, BigDecimal> getTotalTaxAmountByInstallmentForAdditionalTaxCalculation(AdvertisementPermitDetail advPermitDetail, Map<String, BigDecimal> additionalTaxes) {
        HashMap<Installment, BigDecimal> totalTaxableAmount = new HashMap<Installment, BigDecimal>();
        if (advPermitDetail != null && advPermitDetail.getAdvertisement() != null && advPermitDetail.getAdvertisement().getDemandId() != null) {
            for (EgDemandDetails demandDtl : advPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                if (demandDtl.getBalance().compareTo(BigDecimal.ZERO) <= 0 || "Penalty".equalsIgnoreCase(demandDtl.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()) && additionalTaxes.containsKey(demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
                if (totalTaxableAmount.get(demandDtl.getEgDemandReason().getEgInstallmentMaster()) == null) {
                    totalTaxableAmount.put(demandDtl.getEgDemandReason().getEgInstallmentMaster(), demandDtl.getBalance());
                    continue;
                }
                totalTaxableAmount.put(demandDtl.getEgDemandReason().getEgInstallmentMaster(), ((BigDecimal)totalTaxableAmount.get(demandDtl.getEgDemandReason().getEgInstallmentMaster())).add(demandDtl.getBalance()));
            }
        }
        return totalTaxableAmount;
    }

    @Override
    public BigDecimal getAdditionalTaxAmountByPassingDemandDetailAndAdditionalTaxes(EgDemandDetails demandDtl, List<AdvertisementAdditionalTaxRate> additionalTaxRates) {
        BigDecimal totalTaxableAmount = BigDecimal.ZERO;
        HashMap<String, BigDecimal> additionalTaxes = new HashMap<String, BigDecimal>();
        if (this.serviceTaxAndCessCalculationRequired().booleanValue()) {
            for (AdvertisementAdditionalTaxRate taxRates : additionalTaxRates) {
                additionalTaxes.put(taxRates.getReasonCode(), taxRates.getPercentage());
            }
            for (AdvertisementAdditionalTaxRate taxRates : additionalTaxRates) {
                if (demandDtl.getBalance().compareTo(BigDecimal.ZERO) <= 0 || "Penalty".equalsIgnoreCase(demandDtl.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()) && additionalTaxes.containsKey(demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
                totalTaxableAmount = totalTaxableAmount.add(demandDtl.getBalance().multiply(taxRates.getPercentage()).divide(BigDecimal.valueOf(100L))).setScale(4, 4);
            }
        }
        return totalTaxableAmount;
    }

    @Override
    public BigDecimal getTotalAdditionalTaxesByPassingAdvertisementPermit(AdvertisementPermitDetail advPermitDetail) {
        BigDecimal totalAdditionalTax = BigDecimal.ZERO;
        BigDecimal curntInsAdditionalTax = BigDecimal.ZERO;
        BigDecimal curntInsTotalTaxableAmt = BigDecimal.ZERO;
        BigDecimal arrInsAdditionalTax = BigDecimal.ZERO;
        BigDecimal arrInsTotalTaxableAmt = BigDecimal.ZERO;
        Map<Object, Object> additionalTaxesMasterList = new HashMap();
        if (this.serviceTaxAndCessCalculationRequired().booleanValue()) {
            additionalTaxesMasterList = this.getAdditionalTaxRates();
            Installment currentInstallemnt = advPermitDetail.getAdvertisement().getDemandId().getEgInstallmentMaster();
            for (EgDemandDetails egDemandDetails : advPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                if (currentInstallemnt == null || egDemandDetails.getBalance().compareTo(BigDecimal.ZERO) <= 0) continue;
                if (currentInstallemnt.getDescription().equals(egDemandDetails.getEgDemandReason().getEgInstallmentMaster().getDescription())) {
                    if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Arrear_Adv_Tax")) {
                        arrInsTotalTaxableAmt = arrInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                        continue;
                    }
                    curntInsTotalTaxableAmt = curntInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                    continue;
                }
                arrInsTotalTaxableAmt = arrInsTotalTaxableAmt.add(egDemandDetails.getBalance());
            }
            for (Map.Entry entry : additionalTaxesMasterList.entrySet()) {
                curntInsAdditionalTax = this.calculateAdditionalTaxes(curntInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                totalAdditionalTax = totalAdditionalTax.add(curntInsAdditionalTax);
                arrInsAdditionalTax = this.calculateAdditionalTaxes(arrInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                totalAdditionalTax = totalAdditionalTax.add(arrInsAdditionalTax);
            }
        }
        return totalAdditionalTax;
    }

    @Override
    public Map<Installment, BigDecimal> getAdditionalTaxesByInstallment(AdvertisementPermitDetail activeAdvertisementPermit) {
        HashMap<String, BigDecimal> additionalTaxesMasterList = new HashMap();
        HashMap<Installment, BigDecimal> additionalTaxes = new HashMap<Installment, BigDecimal>();
        Map<Object, Object> installmentWiseTaxableAmtMap = new HashMap();
        if (this.serviceTaxAndCessCalculationRequired().booleanValue() && (installmentWiseTaxableAmtMap = this.getTotalTaxAmountByInstallmentForAdditionalTaxCalculation(activeAdvertisementPermit, additionalTaxesMasterList = this.getAdditionalTaxRates())) != null) {
            for (Map.Entry<Object, Object> entry : installmentWiseTaxableAmtMap.entrySet()) {
                BigDecimal tax = BigDecimal.ZERO;
                for (Map.Entry entry2 : additionalTaxesMasterList.entrySet()) {
                    tax = tax.add(((BigDecimal)entry2.getValue()).multiply((BigDecimal)entry.getValue()).divide(BigDecimal.valueOf(100L)).setScale(0, 4));
                }
                additionalTaxes.put((Installment)entry.getKey(), tax);
            }
            if (additionalTaxes != null && additionalTaxes.size() > 0) {
                for (Map.Entry<Object, Object> entry : additionalTaxes.entrySet()) {
                    entry.setValue(((BigDecimal)entry.getValue()).setScale(0, 4));
                }
            }
        }
        return additionalTaxes;
    }
}

