/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.es;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.service.es.AdvertisementIndexService;
import org.egov.commons.entity.Source;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.entity.enums.ApprovalStatus;
import org.egov.infra.elasticsearch.entity.enums.ClosureStatus;
import org.egov.infra.elasticsearch.service.ApplicationIndexService;
import org.egov.infra.security.utils.SecurityUtils;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertisementPermitDetailUpdateIndexService {
    private static final Logger LOGGER = Logger.getLogger(AdvertisementPermitDetailUpdateIndexService.class);
    private static final String ADTAX_APPLICATION_VIEW = "/adtax/hoarding/view/%s";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private AdvertisementIndexService advertisementIndexService;
    @Autowired
    protected AppConfigValueService appConfigValuesService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public void updateAdvertisementPermitDetailIndexes(AdvertisementPermitDetail advertisementPermitDetail) {
        Assignment assignment = null;
        User user = null;
        List asignList = Collections.emptyList();
        if (advertisementPermitDetail.getState() != null && advertisementPermitDetail.getState().getOwnerPosition() != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(advertisementPermitDetail.getState().getOwnerPosition().getId(), new Date());
            if (assignment != null) {
                asignList = new ArrayList();
                asignList.add(assignment);
            } else if (assignment == null) {
                asignList = this.assignmentService.getAssignmentsForPosition(advertisementPermitDetail.getState().getOwnerPosition().getId(), new Date());
            }
            if (!asignList.isEmpty()) {
                user = this.userService.getUserById(((Assignment)asignList.get(0)).getEmployee().getId());
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"Get user from asignList ....");
                    LOGGER.info(user != null ? user : "user is null");
                }
            } else {
                user = this.securityUtils.getCurrentUser();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"Get curent  user....");
                    LOGGER.info(user != null ? user : "user is null");
                }
            }
        }
        if (advertisementPermitDetail.getAdvertisement().getLegacy().booleanValue() && (null == advertisementPermitDetail.getId() || null != advertisementPermitDetail.getId() && advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("ADTAXPERMITGENERATED"))) {
            this.advertisementIndexService.createAdvertisementIndex(advertisementPermitDetail);
            return;
        }
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(advertisementPermitDetail.getApplicationNumber());
        if (applicationIndex != null && null != advertisementPermitDetail.getId() && advertisementPermitDetail.getStatus() != null && !advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("CREATED")) {
            if (advertisementPermitDetail.getStatus() != null && (advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("APPROVED") || advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("ADTAXAMTPAYMENTPAID") || advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("ADTAXPERMITGENERATED") || advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("CANCELLED"))) {
                applicationIndex.setStatus(advertisementPermitDetail.getStatus().getDescription());
                applicationIndex.setOwnerName(user != null ? user.getUsername() + "::" + user.getName() : "");
                if (advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("APPROVED")) {
                    String applicantName = advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getName() : advertisementPermitDetail.getOwnerDetail();
                    String address = advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getAddress() : advertisementPermitDetail.getOwnerDetail();
                    applicationIndex.setApplicantName(applicantName);
                    applicationIndex.setApplicantAddress(address);
                    applicationIndex.setMobileNumber(advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getMobileNumber() : "");
                }
                if (advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("ADTAXPERMITGENERATED")) {
                    applicationIndex.setApproved(ApprovalStatus.APPROVED);
                    applicationIndex.setClosed(ClosureStatus.YES);
                }
                if (advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("CANCELLED") || advertisementPermitDetail.getAdvertisement().getStatus().name().equalsIgnoreCase("INACTIVE")) {
                    applicationIndex.setApproved(ApprovalStatus.REJECTED);
                    applicationIndex.setClosed(ClosureStatus.YES);
                }
                if (advertisementPermitDetail.getPermissionNumber() != null) {
                    applicationIndex.setConsumerCode(advertisementPermitDetail.getPermissionNumber());
                }
                this.applicationIndexService.updateApplicationIndex(applicationIndex);
            }
            this.advertisementIndexService.createAdvertisementIndex(advertisementPermitDetail);
        } else {
            AppConfigValues slaForAdvertisement = null;
            if (advertisementPermitDetail != null && advertisementPermitDetail.getApplicationtype() != null && "RENEW".equals(advertisementPermitDetail.getApplicationtype().toString())) {
                slaForAdvertisement = this.getSlaAppConfigValuesForAdvertisement("Advertisement Tax", "SLAFORRENEWADVERTISEMENT");
            } else if (advertisementPermitDetail != null && advertisementPermitDetail.getApplicationtype() != null && "NEW".equals(advertisementPermitDetail.getApplicationtype().toString())) {
                slaForAdvertisement = this.getSlaAppConfigValuesForAdvertisement("Advertisement Tax", "SLAFORNEWADVERTISEMENT");
            }
            if (advertisementPermitDetail.getApplicationDate() == null) {
                advertisementPermitDetail.setApplicationDate(new Date());
            }
            if (advertisementPermitDetail.getApplicationNumber() == null) {
                advertisementPermitDetail.setApplicationNumber(advertisementPermitDetail.getApplicationNumber());
            }
            if (applicationIndex == null) {
                String applicantName = advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getName() : advertisementPermitDetail.getOwnerDetail();
                String address = advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getAddress() : advertisementPermitDetail.getOwnerDetail();
                applicationIndex = ApplicationIndex.builder().withModuleName("Advertisement Tax").withApplicationNumber(advertisementPermitDetail.getApplicationNumber()).withApplicationDate(advertisementPermitDetail.getApplicationDate()).withApplicationType(advertisementPermitDetail.getState().getNatureOfTask()).withApplicantName(applicantName).withStatus(advertisementPermitDetail.getStatus().getDescription()).withUrl(String.format(ADTAX_APPLICATION_VIEW, advertisementPermitDetail.getId())).withApplicantAddress(address).withOwnername(user != null ? user.getUsername() + "::" + user.getName() : "").withChannel(advertisementPermitDetail.getSource() == null ? Source.SYSTEM.toString() : advertisementPermitDetail.getSource()).withMobileNumber(advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getMobileNumber() : "").withClosed(ClosureStatus.NO).withSla(Integer.valueOf(slaForAdvertisement != null && slaForAdvertisement.getValue() != null ? Integer.valueOf(slaForAdvertisement.getValue()) : 0)).withApproved(ApprovalStatus.INPROGRESS).build();
                this.applicationIndexService.createApplicationIndex(applicationIndex);
            }
        }
    }

    public AppConfigValues getSlaAppConfigValuesForAdvertisement(String moduleName, String keyName) {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, keyName);
        return !appConfigValues.isEmpty() ? (AppConfigValues)appConfigValues.get(0) : null;
    }
}

