/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.adtax.entity.AdvertisementAdditionalTaxRate;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.AgencyWiseCollection;
import org.egov.adtax.entity.AgencyWiseCollectionDetail;
import org.egov.adtax.repository.AdvertisementPermitDetailRepository;
import org.egov.adtax.service.AdvertisementAdditinalTaxRateService;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.AdvertisementService;
import org.egov.adtax.service.AgencyWiseCollectionService;
import org.egov.adtax.service.es.AdvertisementPermitDetailUpdateIndexService;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.models.ReceiptAmountInfo;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.integration.TaxCollection;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementTaxCollection
extends TaxCollection {
    private static final Logger LOGGER = Logger.getLogger(AdvertisementTaxCollection.class);
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    AgencyWiseCollectionService agencyWiseCollectionService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AdvertisementService advertisementService;
    @Autowired
    private AdvertisementPermitDetailRepository advertisementPermitDetailRepository;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;
    @Autowired
    private AdvertisementPermitDetailUpdateIndexService advertisementPermitDetailUpdateIndexService;
    @Autowired
    private AdvertisementAdditinalTaxRateService advertisementAdditinalTaxRateService;
    private final Map<String, String> additionalTaxes = new HashMap<String, String>();

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<ReceiptDetail> reconstructReceiptDetail(String billReferenceNumber, BigDecimal actualAmountPaid, List<ReceiptDetail> receiptDetailList) {
        return null;
    }

    @Transactional
    public void updateDemandDetails(BillReceiptInfo billRcptInfo) {
        BigDecimal totalAmount = billRcptInfo.getTotalAmount();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"updateDemandDetails : Demand updation for advertisement started. ");
        }
        List<AdvertisementAdditionalTaxRate> additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
        for (AdvertisementAdditionalTaxRate taxRates : additionalTaxRates) {
            this.additionalTaxes.put(taxRates.getTaxType(), taxRates.getReasonCode());
        }
        EgDemand demand = this.getDemandByBillReferenceNumber(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        AgencyWiseCollection agencyWiseCollection = this.agencyWiseCollectionService.getAgencyWiseCollectionByDemand(demand);
        if (agencyWiseCollection != null) {
            agencyWiseCollection.setAmountCollected(Boolean.TRUE);
            agencyWiseCollection.setDemandUpdated(Boolean.TRUE);
            if (billRcptInfo.getEvent().equals("RECEIPT_CREATED")) {
                this.updateAgencyWiseCollectionOnCreate(billRcptInfo, agencyWiseCollection, totalAmount);
            } else if (billRcptInfo.getEvent().equals("RECEIPT_CANCELLED")) {
                this.updateAgencyWiseCollectionOnCancel(demand, billRcptInfo, agencyWiseCollection, totalAmount);
            }
        } else {
            demand = this.generalDemandUpdationForAdvertisement(billRcptInfo, totalAmount);
            this.updateWorkflowState(demand);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"updateDemandDetails : Demand updation processed. ");
        }
    }

    @Transactional
    private void updateAgencyWiseCollectionOnCreate(BillReceiptInfo billRcptInfo, AgencyWiseCollection agencyWiseCollection, BigDecimal totalAmount) {
        for (AgencyWiseCollectionDetail agencyDtl : agencyWiseCollection.getAgencyWiseCollectionDetails()) {
            if (!(agencyDtl.getDemandDetail() == null || "Penalty".equalsIgnoreCase(agencyDtl.getDemandreason().getEgDemandReasonMaster().getReasonMaster()) || this.additionalTaxes.isEmpty() || this.additionalTaxes.containsValue(agencyDtl.getDemandreason().getEgDemandReasonMaster().getCode()))) {
                agencyDtl.getDemandDetail().setAmtCollected(agencyDtl.getDemandDetail().getAmtCollected().add(agencyDtl.getAmount()));
                this.persistCollectedReceipts(agencyDtl.getDemandDetail(), billRcptInfo.getReceiptNum(), totalAmount, billRcptInfo.getReceiptDate(), agencyDtl.getAmount());
                agencyDtl.getDemand().addCollected(agencyDtl.getAmount());
            } else {
                List<EgDemandDetails> penaltyDmtDtails = this.advertisementDemandService.getDemandDetailByPassingDemandDemandReason(agencyDtl.getDemand(), agencyDtl.getDemandreason());
                if (penaltyDmtDtails != null && penaltyDmtDtails.size() > 0) {
                    penaltyDmtDtails.get(0).setAmount(penaltyDmtDtails.get(0).getAmount().add(agencyDtl.getAmount()));
                    penaltyDmtDtails.get(0).setAmtCollected(penaltyDmtDtails.get(0).getAmtCollected().add(agencyDtl.getAmount()));
                    this.persistCollectedReceipts(penaltyDmtDtails.get(0), billRcptInfo.getReceiptNum(), totalAmount, billRcptInfo.getReceiptDate(), agencyDtl.getAmount());
                } else {
                    EgDemandDetails demandDetail = this.advertisementDemandService.createDemandDetails(agencyDtl.getAmount(), agencyDtl.getDemandreason(), agencyDtl.getAmount());
                    agencyDtl.getDemand().addEgDemandDetails(demandDetail);
                    agencyDtl.getDemand().addBaseDemand(agencyDtl.getAmount());
                    agencyDtl.getDemand().addCollected(agencyDtl.getAmount());
                    this.getCurrentSession().flush();
                    this.persistCollectedReceipts(demandDetail, billRcptInfo.getReceiptNum(), totalAmount, billRcptInfo.getReceiptDate(), agencyDtl.getAmount());
                }
            }
            if (agencyDtl.getDemand() == null) continue;
            this.updateWorkflowState(agencyDtl.getDemand());
        }
    }

    @Transactional
    private EgDemand generalDemandUpdationForAdvertisement(BillReceiptInfo billRcptInfo, BigDecimal totalAmount) {
        EgDemand demand = this.getDemandByBillReferenceNumber(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        String indexNo = ((BillReceiptInfoImpl)billRcptInfo).getReceiptMisc().getReceiptHeader().getConsumerCode();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("updateDemandDetails : Demand before proceeding : " + demand));
            LOGGER.debug((Object)("updateDemandDetails : collection back update started for property : " + indexNo + " and receipt event is " + billRcptInfo.getEvent() + ". Total Receipt amount is." + totalAmount + " with receipt no." + billRcptInfo.getReceiptNum()));
        }
        if (billRcptInfo.getEvent().equals("INSTRUMENT_BOUNCED")) {
            this.updateReceiptStatusWhenCancelled(billRcptInfo.getReceiptNum());
        } else if (billRcptInfo.getEvent().equals("RECEIPT_CREATED")) {
            this.updateDemandWithcollectdTaxDetails(demand, billRcptInfo, "RECEIPT_CREATED", totalAmount);
        } else if (billRcptInfo.getEvent().equals("RECEIPT_CANCELLED")) {
            this.updateDemandWithcollectdTaxDetails(demand, billRcptInfo, "RECEIPT_CANCELLED", totalAmount);
        }
        return demand;
    }

    @Transactional
    private BigDecimal updateDemandWithcollectdTaxDetails(EgDemand demand, BillReceiptInfo billReceiptInfo, String eventType, BigDecimal totalAmount) {
        BigDecimal totalAmountCollected = BigDecimal.ZERO;
        List<String> taxTypeDescList = this.buildAdditionalTaxDetails();
        for (ReceiptAccountInfo recAccInfo : billReceiptInfo.getAccountDetails()) {
            String demandMasterReasonDesc = null;
            String financialYearDesc = null;
            if (recAccInfo.getDescription() == null) continue;
            demandMasterReasonDesc = recAccInfo.getDescription().substring(0, recAccInfo.getDescription().indexOf("Collection")).trim();
            financialYearDesc = !taxTypeDescList.isEmpty() && taxTypeDescList.contains(demandMasterReasonDesc) ? this.advertisementDemandService.getCurrentInstallment().getDescription() : recAccInfo.getDescription().substring(recAccInfo.getDescription().indexOf("Collection") + "Collection".length()).trim();
            if (!eventType.equals("RECEIPT_CREATED")) continue;
            totalAmountCollected = totalAmountCollected.add(this.createOrUpdateDemandDetails(demandMasterReasonDesc, financialYearDesc, demand, billReceiptInfo, recAccInfo, totalAmount));
        }
        LOGGER.info((Object)("Demand before updateDemandDetails() processing: " + demand.getAmtCollected() + demand));
        if (eventType.equals("RECEIPT_CANCELLED")) {
            this.cancelBill(Long.valueOf(billReceiptInfo.getBillReferenceNum()));
            demand.setAmtCollected(demand.getAmtCollected().subtract(totalAmount));
            this.updateDmdDetForRcptCancel(demand, billReceiptInfo);
        }
        demand.setModifiedDate(new Date());
        return totalAmountCollected;
    }

    private List<String> buildAdditionalTaxDetails() {
        ArrayList<String> taxTypeDescList = new ArrayList<String>();
        List<AdvertisementAdditionalTaxRate> additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
        for (AdvertisementAdditionalTaxRate advertisementAdditionalTaxRate : additionalTaxRates) {
            if (advertisementAdditionalTaxRate == null) continue;
            taxTypeDescList.add(advertisementAdditionalTaxRate.getTaxType());
        }
        return taxTypeDescList;
    }

    @Transactional
    private void updateAgencyWiseCollectionOnCancel(EgDemand demand, BillReceiptInfo billRcptInfo, AgencyWiseCollection agencyWiseCollection, BigDecimal totalAmount) {
        for (AgencyWiseCollectionDetail agencyDtl : agencyWiseCollection.getAgencyWiseCollectionDetails()) {
            if (agencyDtl.getDemandDetail() != null) {
                this.updateCancelledDemandDetailAmount(agencyDtl.getDemandDetail(), agencyDtl.getDemand(), agencyDtl.getAmount());
                continue;
            }
            List<EgDemandDetails> demandDetail = this.advertisementDemandService.getDemandDetailByPassingDemandDemandReason(agencyDtl.getDemand(), agencyDtl.getDemandreason());
            if (demandDetail == null || demandDetail.size() <= 0) continue;
            this.updateCancelledDemandDetailAmount(demandDetail.get(0), demandDetail.get(0).getEgDemand(), agencyDtl.getAmount());
        }
        this.cancelBill(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        demand.setAmtCollected(demand.getAmtCollected().subtract(totalAmount));
        this.updateReceiptStatusWhenCancelled(billRcptInfo.getReceiptNum());
    }

    @Transactional
    private void updateCancelledDemandDetailAmount(EgDemandDetails demandDtl, EgDemand demand, BigDecimal amount) {
        if (demandDtl != null && ("Penalty".equalsIgnoreCase(demandDtl.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()) || !this.additionalTaxes.isEmpty() && this.additionalTaxes.containsValue(demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode()))) {
            demand.setBaseDemand(demand.getBaseDemand().subtract(amount));
            demandDtl.setAmount(demandDtl.getAmount().subtract(amount));
        }
        if (demandDtl != null && demandDtl.getAmtCollected().compareTo(amount) < 0) {
            throw new ApplicationRuntimeException("updateDmdDetForRcptCancel : Exception while updating cancel receipt, to be deducted amount " + amount + " is greater than the collected amount " + demandDtl.getAmtCollected());
        }
        demandDtl.setAmtCollected(demandDtl.getAmtCollected().subtract(amount));
        demand.setAmtCollected(demand.getAmtCollected().subtract(amount));
    }

    @Transactional
    private void updateDmdDetForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)"Entering method updateDmdDetForRcptCancel");
        String demandMasterReasonDesc = null;
        String financialYearDesc = null;
        List<String> taxTypeDescList = this.buildAdditionalTaxDetails();
        for (ReceiptAccountInfo rcptAccInfo : billRcptInfo.getAccountDetails()) {
            if (rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1 || rcptAccInfo.getIsRevenueAccount() || rcptAccInfo.getDescription() == null) continue;
            demandMasterReasonDesc = rcptAccInfo.getDescription().substring(0, rcptAccInfo.getDescription().indexOf("Collection")).trim();
            financialYearDesc = !taxTypeDescList.isEmpty() && taxTypeDescList.contains(demandMasterReasonDesc) ? this.advertisementDemandService.getCurrentInstallment().getDescription() : rcptAccInfo.getDescription().substring(rcptAccInfo.getDescription().indexOf("Collection") + "Collection".length()).trim();
            for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
                if (!demandMasterReasonDesc.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()) || financialYearDesc == null || !demandDetail.getEgDemandReason().getEgInstallmentMaster().getFinYearRange().equalsIgnoreCase(financialYearDesc)) continue;
                if (demandDetail.getAmtCollected().compareTo(rcptAccInfo.getCrAmount()) < 0) {
                    throw new ApplicationRuntimeException("updateDmdDetForRcptCancel : Exception while updating cancel receipt, to be deducted amount " + rcptAccInfo.getCrAmount() + " is greater than the collected amount " + demandDetail.getAmtCollected() + " for demandDetail " + demandDetail);
                }
                if ("Penalty".equalsIgnoreCase(demandMasterReasonDesc) || !this.additionalTaxes.isEmpty() && this.additionalTaxes.containsValue(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode())) {
                    demandDetail.setAmount(demandDetail.getAmount().subtract(rcptAccInfo.getCrAmount()));
                }
                demandDetail.setAmtCollected(demandDetail.getAmtCollected().subtract(rcptAccInfo.getCrAmount()));
            }
        }
        this.updateReceiptStatusWhenCancelled(billRcptInfo.getReceiptNum());
        LOGGER.debug((Object)"Exiting method updateDmdDetForRcptCancel");
    }

    @Transactional
    private void cancelBill(Long billId) {
        if (billId != null) {
            EgBill egBill = this.egBillDAO.findById(billId, false);
            egBill.setIs_Cancelled("Y");
        }
    }

    @Transactional
    private BigDecimal createOrUpdateDemandDetails(String demandMasterReasonDesc, String financialYearDesc, EgDemand demand, BillReceiptInfo billReceiptInfo, ReceiptAccountInfo recAccInfo, BigDecimal totalAmount) {
        BigDecimal totalAmountCollected = BigDecimal.ZERO;
        Boolean demandReasonPartOfDemand = false;
        if (recAccInfo.getCrAmount() != null && recAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) > 0) {
            for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
                if (demandDetail.getEgDemandReason() == null || demandDetail.getEgDemandReason().getEgDemandReasonMaster() == null || !demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().trim().equalsIgnoreCase(demandMasterReasonDesc) || financialYearDesc == null || !financialYearDesc.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgInstallmentMaster().getFinYearRange())) continue;
                if ("Penalty".equalsIgnoreCase(demandMasterReasonDesc) || !this.additionalTaxes.isEmpty() && this.additionalTaxes.containsValue(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode())) {
                    demandDetail.setAmount(demandDetail.getAmount().add(recAccInfo.getCrAmount()));
                }
                demandDetail.addCollected(recAccInfo.getCrAmount());
                this.persistCollectedReceipts(demandDetail, billReceiptInfo.getReceiptNum(), totalAmount, billReceiptInfo.getReceiptDate(), recAccInfo.getCrAmount());
                demand.setAmtCollected(demand.getAmtCollected().add(recAccInfo.getCrAmount()));
                totalAmountCollected = totalAmountCollected.add(recAccInfo.getCrAmount());
                demandDetail.setModifiedDate(new Date());
                demandReasonPartOfDemand = true;
            }
            if (!demandReasonPartOfDemand.booleanValue()) {
                EgDemandDetails demandDetail = this.additionalTaxes.containsKey(demandMasterReasonDesc) ? this.advertisementDemandService.createDemandDetails(recAccInfo.getCrAmount(), this.advertisementDemandService.getDemandReasonByCodeAndInstallment(this.additionalTaxes.get(demandMasterReasonDesc), this.advertisementDemandService.getInstallmentByDescription(financialYearDesc)), recAccInfo.getCrAmount()) : this.advertisementDemandService.createDemandDetails(recAccInfo.getCrAmount(), this.advertisementDemandService.getDemandReasonByCodeAndInstallment(demandMasterReasonDesc, this.advertisementDemandService.getInstallmentByDescription(financialYearDesc)), recAccInfo.getCrAmount());
                demand.addEgDemandDetails(demandDetail);
                this.getCurrentSession().flush();
                this.persistCollectedReceipts(demandDetail, billReceiptInfo.getReceiptNum(), totalAmount, billReceiptInfo.getReceiptDate(), recAccInfo.getCrAmount());
            }
            demand.setModifiedDate(new Date());
        }
        return totalAmountCollected;
    }

    private EgDemand getDemandByBillReferenceNumber(Long billId) {
        EgBill egBill;
        EgDemand egDemand = null;
        if (billId != null && (egBill = this.egBillDAO.findById(billId, false)) != null) {
            egDemand = egBill.getEgDemand();
        }
        return egDemand;
    }

    protected Module module() {
        return null;
    }

    public String constructAdditionalInfoForReceipt(BillReceiptInfo billReceiptInfo) {
        return null;
    }

    @Transactional
    private void updateWorkflowState(EgDemand demand) {
        if (demand != null) {
            AdvertisementPermitDetail advertisementPermitDetail = this.advertisementService.getAdvertisementByDemand(demand).getActiveAdvertisementPermit();
            if (advertisementPermitDetail != null && advertisementPermitDetail.getState() != null && advertisementPermitDetail.getStatus() != null && advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("APPROVED")) {
                this.advertisementPermitDetailService.updateStateTransition(advertisementPermitDetail, 0L, "Collection done", advertisementPermitDetail.getPreviousapplicationid() != null ? "RENEWADVERTISEMENT" : "CREATEADVERTISEMENT", "GENERATE DEMAND NOTICE");
                this.advertisementPermitDetailRepository.saveAndFlush((Object)advertisementPermitDetail);
            } else {
                this.advertisementPermitDetailUpdateIndexService.updateAdvertisementPermitDetailIndexes(advertisementPermitDetail);
            }
        }
    }

    public ReceiptAmountInfo receiptAmountBifurcation(BillReceiptInfo billReceiptInfo) {
        return new ReceiptAmountInfo();
    }
}

