/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.entity.SubCategorySearch;
import org.egov.adtax.repository.SubCategoryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SubCategoryService {
    private final SubCategoryRepository subCategoryRepository;

    @Autowired
    public SubCategoryService(SubCategoryRepository subCategoryRepository) {
        this.subCategoryRepository = subCategoryRepository;
    }

    public List<SubCategory> getAllActiveSubCategoryByCategoryId(Long categoryId) {
        return this.subCategoryRepository.getAllActiveSubCategoryByCategoryId(categoryId);
    }

    public List<SubCategory> getAllSubCategory() {
        return this.subCategoryRepository.getAllSubCategory();
    }

    @Transactional
    public SubCategory createSubCategory(SubCategory subCategory) {
        return (SubCategory)((Object)this.subCategoryRepository.save((Object)subCategory));
    }

    @Transactional
    public SubCategory updateSubCategory(SubCategory subCategory) {
        return (SubCategory)((Object)this.subCategoryRepository.save((Object)subCategory));
    }

    public SubCategory getSubCategoryById(Long id) {
        return (SubCategory)((Object)this.subCategoryRepository.findOne(id));
    }

    public List<SubCategorySearch> getSubcategory(Long category, Long subcategory) {
        List<SubCategory> subcategoryList = category != null && subcategory != null ? this.subCategoryRepository.searchSubcategoryByCategoryIdAndSubCategoryId(category, subcategory) : this.subCategoryRepository.getAllSubCategoryByCategoryId(category);
        ArrayList<SubCategorySearch> subCategorySearchList = new ArrayList<SubCategorySearch>();
        subcategoryList.forEach(result -> {
            SubCategorySearch subCategorySearch = new SubCategorySearch();
            subCategorySearch.setCategory(result.getCategory().getName());
            subCategorySearch.setDescription(result.getDescription());
            subCategorySearch.setCode(result.getCode());
            subCategorySearch.setId(result.getId());
            subCategorySearchList.add(subCategorySearch);
        });
        return subCategorySearchList;
    }
}

