/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.util.List;
import org.egov.adtax.entity.RatesClass;
import org.egov.adtax.repository.RatesClassRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RatesClassService {
    private final RatesClassRepository ratesClassRepository;

    @Autowired
    public RatesClassService(RatesClassRepository ratesClassRepository) {
        this.ratesClassRepository = ratesClassRepository;
    }

    public List<RatesClass> getAllRatesClass() {
        return this.ratesClassRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"description"}));
    }

    public List<RatesClass> getAllActiveRatesClass() {
        return this.ratesClassRepository.getAllActiveRatesClass();
    }

    public RatesClass getRateClassById(Long id) {
        return (RatesClass)((Object)this.ratesClassRepository.findOne(id));
    }

    public RatesClass getRatesClassByDescription(String description) {
        return this.ratesClassRepository.findByDescription(description);
    }

    @Transactional
    public RatesClass createRatesClass(RatesClass ratesClass) {
        return (RatesClass)((Object)this.ratesClassRepository.save((Object)ratesClass));
    }

    public List<RatesClass> findAll() {
        return this.ratesClassRepository.findAll();
    }

    @Transactional
    public RatesClass updateRateClass(RatesClass rateClass) {
        return (RatesClass)((Object)this.ratesClassRepository.save((Object)rateClass));
    }
}

