/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.adtax.entity.AdvertisementRate;
import org.egov.adtax.entity.AdvertisementRatesDetails;
import org.egov.adtax.entity.HoardingCategory;
import org.egov.adtax.entity.RatesClass;
import org.egov.adtax.entity.ScheduleOfRateSearch;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.entity.UnitOfMeasure;
import org.egov.adtax.repository.AdvertisementRateDetailRepository;
import org.egov.adtax.repository.AdvertisementRateRepository;
import org.egov.commons.CFinancialYear;
import org.egov.commons.repository.CFinancialYearRepository;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementRateService {
    private final AdvertisementRateRepository ratesRepository;
    private final AdvertisementRateDetailRepository rateDetailRepository;
    private final CFinancialYearRepository cFinancialYearRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public AdvertisementRateService(AdvertisementRateRepository ratesRepository, AdvertisementRateDetailRepository rateDetailRepository, CFinancialYearRepository cFinancialYearRepository) {
        this.ratesRepository = ratesRepository;
        this.rateDetailRepository = rateDetailRepository;
        this.cFinancialYearRepository = cFinancialYearRepository;
    }

    public AdvertisementRate getScheduleOfRateById(Long id) {
        return (AdvertisementRate)((Object)this.ratesRepository.findOne(id));
    }

    @ReadOnly
    public List<AdvertisementRatesDetails> findScheduleOfRateDetailsByCategorySubcategoryUomAndClass(HoardingCategory category, SubCategory subCategory, UnitOfMeasure unitOfMeasure, RatesClass ratesClass, CFinancialYear financialYear) {
        return this.rateDetailRepository.findScheduleOfRateDetailsByCategorySubcategoryUomAndClass(category, subCategory, unitOfMeasure, ratesClass, financialYear);
    }

    @Transactional
    public AdvertisementRate createScheduleOfRate(AdvertisementRate rate) {
        return (AdvertisementRate)((Object)this.ratesRepository.save((Object)rate));
    }

    public AdvertisementRate findScheduleOfRateByCategorySubcategoryUomAndClass(HoardingCategory category, SubCategory subCategory, UnitOfMeasure unitofmeasure, RatesClass classtype, CFinancialYear financialYear) {
        return this.ratesRepository.findScheduleOfRateByCategorySubcategoryUomAndClass(category, subCategory, unitofmeasure, classtype, financialYear);
    }

    public void deleteAllInBatch(List<AdvertisementRatesDetails> existingRateDetails) {
        this.rateDetailRepository.deleteInBatch(existingRateDetails);
    }

    public Double getAmountByCategorySubcategoryUomAndClass(HoardingCategory category, SubCategory subCategory, UnitOfMeasure unitofmeasure, RatesClass classtype, Double units, CFinancialYear financialYear) {
        Double rate = 0.0;
        if (units != null && category != null && subCategory != null && unitofmeasure != null && classtype != null) {
            rate = this.rateDetailRepository.getAmountByCategorySubcategoryUomAndClass(category, subCategory, unitofmeasure, classtype, units, financialYear);
        }
        return rate;
    }

    public Double getAmountBySubcategoryUomClassAndMeasurement(Long subCategoryId, Long unitOfMeasureId, Long rateClassId, Double measurement) {
        Double rate = 0.0;
        if (measurement != null && subCategoryId != null && unitOfMeasureId != null && rateClassId != null) {
            rate = this.rateDetailRepository.getAmountBySubcategoryUomClassAndMeasurement(measurement, subCategoryId, unitOfMeasureId, rateClassId);
        }
        if (rate == null) {
            return 0.0;
        }
        return rate;
    }

    public AdvertisementRatesDetails getRatesBySubcategoryUomClassFinancialYearAndMeasurement(Long subCategoryId, Long unitOfMeasureId, Long rateClassId, Double units, CFinancialYear cfinancialYear) {
        List<AdvertisementRatesDetails> rate = null;
        if (units != null && subCategoryId != null && unitOfMeasureId != null && rateClassId != null) {
            rate = this.rateDetailRepository.getRatesBySubcategoryUomClassFinancialYearAndMeasurement(units, subCategoryId, unitOfMeasureId, rateClassId, cfinancialYear.getId());
        }
        if (rate != null && rate.size() > 0) {
            return (AdvertisementRatesDetails)((Object)rate.get(0));
        }
        return null;
    }

    public AdvertisementRatesDetails getRatesBySubcategoryUomClassAndMeasurementByFinancialYearInDecendingOrder(Long subCategoryId, Long unitOfMeasureId, Long rateClassId, Double units) {
        List<AdvertisementRatesDetails> rate = null;
        if (units != null && subCategoryId != null && unitOfMeasureId != null && rateClassId != null) {
            rate = this.rateDetailRepository.getRatesBySubcategoryUomClassMeasurementLessthanCurrentFinancialYearAndFinancialYearInDecendingOrder(units, subCategoryId, unitOfMeasureId, rateClassId);
        }
        if (rate != null && rate.size() > 0) {
            return (AdvertisementRatesDetails)((Object)rate.get(0));
        }
        return null;
    }

    public List<ScheduleOfRateSearch> getScheduleOfRateSearchResult(String category, String subCategory, String unitofmeasure, String classtype, String finyear) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("Select A From AdvertisementRatesDetails A where ");
        Boolean var = Boolean.FALSE;
        if (!StringUtils.isEmpty((String)category)) {
            queryString.append(" A.advertisementRate.category.id=:category ");
            var = Boolean.TRUE;
        }
        if (!StringUtils.isEmpty((String)subCategory)) {
            if (var.booleanValue()) {
                queryString.append(" and ");
            }
            queryString.append(" A.advertisementRate.subCategory.id=:subCategory ");
            var = Boolean.TRUE;
        }
        if (!StringUtils.isEmpty((String)unitofmeasure)) {
            if (var.booleanValue()) {
                queryString.append(" and ");
            }
            queryString.append(" A.advertisementRate.unitofmeasure.id=:unitofmeasure ");
            var = Boolean.TRUE;
        }
        if (!StringUtils.isEmpty((String)classtype)) {
            if (var.booleanValue()) {
                queryString.append(" and ");
            }
            queryString.append(" A.advertisementRate.classtype.id=:classtype ");
            var = Boolean.TRUE;
        }
        if (!StringUtils.isEmpty((String)finyear)) {
            if (var.booleanValue()) {
                queryString.append(" and ");
            }
            queryString.append(" A.advertisementRate.financialyear.id=:finyear ");
        }
        Query query = ((Session)this.entityManager.unwrap(Session.class)).createQuery(queryString.toString());
        if (!StringUtils.isEmpty((String)category)) {
            query.setParameter("category", (Object)Long.parseLong(category));
        }
        if (!StringUtils.isEmpty((String)subCategory)) {
            query.setParameter("subCategory", (Object)Long.parseLong(subCategory));
        }
        if (!StringUtils.isEmpty((String)unitofmeasure)) {
            query.setParameter("unitofmeasure", (Object)Long.parseLong(unitofmeasure));
        }
        if (!StringUtils.isEmpty((String)classtype)) {
            query.setParameter("classtype", (Object)Long.parseLong(classtype));
        }
        if (!StringUtils.isEmpty((String)finyear)) {
            query.setParameter("finyear", (Object)Long.parseLong(finyear));
        }
        List rateList = query.list();
        ArrayList<ScheduleOfRateSearch> scheduleOfRateList = new ArrayList<ScheduleOfRateSearch>();
        rateList.forEach(result -> {
            ScheduleOfRateSearch scheduleOfRateSearch = new ScheduleOfRateSearch();
            scheduleOfRateSearch.setCategory(result.getAdvertisementRate().getCategory().getCode());
            scheduleOfRateSearch.setSubCategory(result.getAdvertisementRate().getSubCategory().getCode());
            scheduleOfRateSearch.setUnitofmeasure(result.getAdvertisementRate().getUnitofmeasure().getCode());
            scheduleOfRateSearch.setClasstype(result.getAdvertisementRate().getClasstype().getDescription());
            scheduleOfRateSearch.setFinancialyear(result.getAdvertisementRate().getFinancialyear().getFinYearRange());
            scheduleOfRateSearch.setUnitfrom(result.getUnitFrom());
            scheduleOfRateSearch.setUnitto(result.getUnitTo());
            scheduleOfRateSearch.setAmount(result.getAmount());
            scheduleOfRateSearch.setUnitfactor(result.getAdvertisementRate().getUnitrate());
            scheduleOfRateList.add(scheduleOfRateSearch);
        });
        return scheduleOfRateList;
    }

    public List<CFinancialYear> getAllFinancialYears() {
        return this.cFinancialYearRepository.getAllFinancialYears();
    }
}

