/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.util.List;
import org.egov.adtax.entity.AdvertisementPenaltyRates;
import org.egov.adtax.repository.AdvertisementPenaltyRatesRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementPenaltyRatesService {
    @Autowired
    private AdvertisementPenaltyRatesRepository penaltyRatesRepository;

    public AdvertisementPenaltyRates getPenaltyRatesById(Long id) {
        return (AdvertisementPenaltyRates)((Object)this.penaltyRatesRepository.findOne(id));
    }

    public Double findPenaltyRatesByNumberOfDays(Long numberOfDays) {
        AdvertisementPenaltyRates penaltyRate;
        if (numberOfDays != null && (penaltyRate = this.penaltyRatesRepository.findPenaltyRatesByNumberOfDays((double)numberOfDays)) != null) {
            return penaltyRate.getPercentage();
        }
        return 0.0;
    }

    public List<AdvertisementPenaltyRates> findPenaltyRatesInAscendingOrder() {
        return this.penaltyRatesRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"id"}));
    }

    @Transactional
    public AdvertisementPenaltyRates createPenaltyRates(AdvertisementPenaltyRates advertisementPenaltyRates) {
        return (AdvertisementPenaltyRates)((Object)this.penaltyRatesRepository.save((Object)advertisementPenaltyRates));
    }

    @Transactional
    public void delete(AdvertisementPenaltyRates rate) {
        this.penaltyRatesRepository.delete((Object)rate);
    }
}

