/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementDemandGenerationLog;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.enums.ProcessStatus;
import org.egov.adtax.repository.AdTaxDemandGenerationLogRepository;
import org.egov.adtax.service.AdTaxDemandGenerationLogService;
import org.egov.adtax.service.AdvertisementService;
import org.egov.adtax.service.penalty.AdvertisementAdditionalTaxCalculator;
import org.egov.adtax.service.penalty.AdvertisementPenaltyCalculator;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.model.BillReceipt;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
@Transactional(readOnly=true)
public class AdvertisementDemandService {
    private static final Logger LOGGER = Logger.getLogger(AdvertisementDemandService.class);
    private static final String SUCCESSFUL = "Successful";
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private DemandGenericDao demandGenericDao;
    @Autowired
    private ModuleService moduleService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AdvertisementPenaltyCalculator advertisementPenaltyCalculator;
    @Autowired
    private AdTaxDemandGenerationLogService adTaxDemandGenerationLogService;
    @Autowired
    private AdvertisementAdditionalTaxCalculator advertisementAdditionalTaxCalculator;
    @Autowired
    private AdvertisementService advertisementService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private AdTaxDemandGenerationLogRepository adTaxDemandGenerationLogRepository;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public EgDemand createDemand(Advertisement advertisement) {
        EgDemand demand = null;
        HashSet<EgDemandDetails> demandDetailSet = new HashSet<EgDemandDetails>();
        Installment installment = this.getCurrentInstallment();
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        if (advertisement != null && advertisement.getDemandId() == null) {
            demand = this.createDemand(demandDetailSet, installment, totalDemandAmount);
        }
        return demand;
    }

    public EgDemandReason getDemandReasonByCodeAndInstallment(String demandReason, Installment installment) {
        Query demandQuery = this.getCurrentSession().getNamedQuery("DEMANDREASONBY_CODE_AND_INSTALLMENTID");
        demandQuery.setParameter(0, (Object)demandReason);
        demandQuery.setParameter(1, (Object)installment.getId());
        return (EgDemandReason)demandQuery.uniqueResult();
    }

    private EgDemand createDemand(Set<EgDemandDetails> demandDetailSet, Installment installment, BigDecimal totalDemandAmount) {
        EgDemand egDemand = new EgDemand();
        egDemand.setEgInstallmentMaster(installment);
        egDemand.getEgDemandDetails().addAll(demandDetailSet);
        egDemand.setIsHistory("N");
        egDemand.setCreateDate(new Date());
        egDemand.setBaseDemand(totalDemandAmount.setScale(0, 4));
        egDemand.setModifiedDate(new Date());
        return egDemand;
    }

    public Installment getCurrentInstallment() {
        return this.installmentDao.getInsatllmentByModuleForGivenDateAndInstallmentType(this.moduleService.getModuleByName("Advertisement Tax"), new Date(), "Yearly");
    }

    public Installment getInstallmentByDescription(String description) {
        return this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleService.getModuleByName("Advertisement Tax"), description);
    }

    @Transactional
    public Installment getInsatllmentByModuleForGivenDate(Date installmentDate) {
        return this.installmentDao.getInsatllmentByModuleForGivenDate(this.moduleService.getModuleByName("Advertisement Tax"), installmentDate);
    }

    @Transactional
    public List<Installment> getPreviousInstallment(Date curentInstalmentEndate) {
        return this.installmentDao.fetchPreviousInstallmentsInDescendingOrderByModuleAndDate(this.moduleService.getModuleByName("Advertisement Tax"), curentInstalmentEndate, 1);
    }

    public EgDemandDetails createDemandDetails(BigDecimal dmdAmount, EgDemandReason egDemandReason, BigDecimal amtCollected) {
        return EgDemandDetails.fromReasonAndAmounts((BigDecimal)dmdAmount.setScale(0, 4), (EgDemandReason)egDemandReason, (BigDecimal)amtCollected);
    }

    public Boolean checkAnyTaxIsPendingToCollect(Advertisement advertisement) {
        Boolean pendingTaxCollection = false;
        if (advertisement != null && advertisement.getDemandId() != null) {
            for (EgDemandDetails demandDtl : advertisement.getDemandId().getEgDemandDetails()) {
                if (demandDtl.getAmount().subtract(demandDtl.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0) continue;
                pendingTaxCollection = true;
                break;
            }
        }
        return pendingTaxCollection;
    }

    public Boolean checkAnyTaxPendingForSelectedFinancialYear(Advertisement advertisement, Installment installment) {
        Boolean pendingTaxCollection = false;
        if (advertisement != null && advertisement.getDemandId() != null) {
            for (EgDemandDetails demandDtl : advertisement.getDemandId().getEgDemandDetails()) {
                if (!demandDtl.getEgDemandReason().getEgInstallmentMaster().getId().equals(installment.getId()) || demandDtl.getAmount().subtract(demandDtl.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0) continue;
                pendingTaxCollection = true;
                break;
            }
        }
        return pendingTaxCollection;
    }

    public Map<String, BigDecimal> checkPedingAmountByDemand(AdvertisementPermitDetail advPermitDetail) {
        LinkedHashMap<String, BigDecimal> demandFeeType = new LinkedHashMap<String, BigDecimal>();
        BigDecimal penaltyAmt = BigDecimal.ZERO;
        BigDecimal pendingAmount = BigDecimal.ZERO;
        BigDecimal additionalTaxAmount = BigDecimal.ZERO;
        if (advPermitDetail != null && advPermitDetail.getAdvertisement() != null && advPermitDetail.getAdvertisement().getDemandId() != null) {
            for (EgDemandDetails demandDtl : advPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                if (demandDtl.getAmount().subtract(demandDtl.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0) continue;
                pendingAmount = pendingAmount.add(demandDtl.getAmount().subtract(demandDtl.getAmtCollected()));
            }
            penaltyAmt = this.advertisementPenaltyCalculator.calculatePenalty(advPermitDetail);
            additionalTaxAmount = this.advertisementAdditionalTaxCalculator.getTotalAdditionalTaxesByPassingAdvertisementPermit(advPermitDetail);
        }
        demandFeeType.put("PENALTYAMOUNT", penaltyAmt.setScale(0, 4));
        demandFeeType.put("ADDITIONALTAXAMOUNT", additionalTaxAmount.setScale(0, 4));
        demandFeeType.put("PENDINGDEMANDAMOUNT", pendingAmount.setScale(0, 4));
        return demandFeeType;
    }

    public boolean anyDemandPendingForCollection(Advertisement advertisementPermitDetail) {
        return this.checkAnyTaxIsPendingToCollect(advertisementPermitDetail);
    }

    public boolean anyDemandPendingForCollection(AdvertisementPermitDetail advertisementPermitDetail) {
        return this.checkAnyTaxIsPendingToCollect(advertisementPermitDetail);
    }

    private boolean checkAnyTaxIsPendingToCollect(AdvertisementPermitDetail advertisementPermitDetail) {
        Installment currentInstallment;
        Boolean amountCollectionPendingInCurrentYear = false;
        if (advertisementPermitDetail != null && advertisementPermitDetail.getAdvertisement().getDemandId() != null && (currentInstallment = advertisementPermitDetail.getAdvertisement().getDemandId().getEgInstallmentMaster()) != null) {
            for (EgDemandDetails demandDtl : advertisementPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                if (demandDtl.getAmount().subtract(demandDtl.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0 || currentInstallment.getId() != demandDtl.getEgDemandReason().getEgInstallmentMaster().getId()) continue;
                amountCollectionPendingInCurrentYear = true;
                break;
            }
        }
        return amountCollectionPendingInCurrentYear;
    }

    public boolean collectionDoneForThisYear(Advertisement advertisement) {
        Installment currentInstallment;
        Boolean amountCollectedInCurrentYear = false;
        if (advertisement != null && advertisement.getDemandId() != null && (currentInstallment = this.getCurrentInstallment()) != null) {
            for (EgDemandDetails demandDtl : advertisement.getDemandId().getEgDemandDetails()) {
                if (demandDtl.getAmtCollected().compareTo(BigDecimal.ZERO) <= 0 || currentInstallment.getId() != demandDtl.getEgDemandReason().getEgInstallmentMaster().getId()) continue;
                amountCollectedInCurrentYear = true;
                break;
            }
        }
        return amountCollectedInCurrentYear;
    }

    public List<EgDemandDetails> getDemandDetailByPassingDemandDemandReason(EgDemand demand, EgDemandReason demandReason) {
        return this.demandGenericDao.getDemandDetailsForDemandAndReasons(demand, Arrays.asList(demandReason));
    }

    public List<BillReceipt> getBilReceiptsByDemand(EgDemand demand) {
        ArrayList<BillReceipt> billReceiptList = new ArrayList();
        billReceiptList = this.demandGenericDao.getBillReceipts(demand);
        return billReceiptList;
    }

    public EgDemand createDemand(AdvertisementPermitDetail advertisementPermitDetail) {
        EgDemand demand = null;
        HashSet<EgDemandDetails> demandDetailSet = new HashSet<EgDemandDetails>();
        Installment installment = this.getCurrentInstallment();
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        Boolean taxFullyPaidForCurrentYear = false;
        if (advertisementPermitDetail != null && advertisementPermitDetail.getAdvertisement().getDemandId() == null) {
            if (advertisementPermitDetail.getAdvertisement() != null && advertisementPermitDetail.getAdvertisement().getLegacy().booleanValue() && advertisementPermitDetail.getAdvertisement().getTaxPaidForCurrentYear().booleanValue()) {
                taxFullyPaidForCurrentYear = true;
            }
            if (advertisementPermitDetail.getTaxAmount() != null || advertisementPermitDetail.getAdvertisement().getPendingTax() != null) {
                if (advertisementPermitDetail.getAdvertisement().getPendingTax() != null) {
                    demandDetailSet.add(this.createDemandDetails(advertisementPermitDetail.getAdvertisement().getPendingTax(), this.getDemandReasonByCodeAndInstallment("Arrear_Adv_Tax", installment), BigDecimal.ZERO));
                    totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getAdvertisement().getPendingTax());
                }
                if (advertisementPermitDetail.getTaxAmount() != null) {
                    demandDetailSet.add(this.createDemandDetails(advertisementPermitDetail.getTaxAmount(), this.getDemandReasonByCodeAndInstallment("Advertisemnt_Tax", installment), taxFullyPaidForCurrentYear != false ? advertisementPermitDetail.getTaxAmount() : BigDecimal.ZERO));
                    totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getTaxAmount());
                }
            }
            if (advertisementPermitDetail.getEncroachmentFee() != null) {
                demandDetailSet.add(this.createDemandDetails(advertisementPermitDetail.getEncroachmentFee(), this.getDemandReasonByCodeAndInstallment("Enchroachmnt_Fee", installment), taxFullyPaidForCurrentYear != false ? advertisementPermitDetail.getEncroachmentFee() : BigDecimal.ZERO));
                totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getEncroachmentFee());
            }
            demand = this.createDemand(demandDetailSet, installment, totalDemandAmount);
        }
        return demand;
    }

    public EgDemand updateDemand(AdvertisementPermitDetail advertisementPermitDetail, EgDemand demand) {
        Installment installment = this.getCurrentInstallment();
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        Boolean enchroachmentFeeAlreadyExistInDemand = false;
        ArrayList<EgDemandDetails> removableDemandDetailList = new ArrayList<EgDemandDetails>();
        if (demand == null) {
            demand = this.createDemand(advertisementPermitDetail);
        } else {
            EgDemandReason pendingTaxReason = this.getDemandReasonByCodeAndInstallment("Arrear_Adv_Tax", installment);
            EgDemandReason encroachmentFeeReason = this.getDemandReasonByCodeAndInstallment("Enchroachmnt_Fee", installment);
            EgDemandReason taxReason = this.getDemandReasonByCodeAndInstallment("Advertisemnt_Tax", installment);
            for (EgDemandDetails dmdDtl : demand.getEgDemandDetails()) {
                if (dmdDtl.getEgDemandReason().getId() == taxReason.getId() && advertisementPermitDetail.getTaxAmount().compareTo(BigDecimal.ZERO) > 0) {
                    totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getTaxAmount().subtract(dmdDtl.getAmount()));
                    dmdDtl.setAmount(advertisementPermitDetail.getTaxAmount().setScale(0, 4));
                }
                if (dmdDtl.getEgDemandReason().getId() == pendingTaxReason.getId() && advertisementPermitDetail.getAdvertisement().getPendingTax() != null && advertisementPermitDetail.getAdvertisement().getPendingTax().compareTo(BigDecimal.ZERO) > 0) {
                    totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getAdvertisement().getPendingTax().subtract(dmdDtl.getAmount()));
                    dmdDtl.setAmount(advertisementPermitDetail.getAdvertisement().getPendingTax().setScale(0, 4));
                }
                if (dmdDtl.getEgDemandReason().getId() != encroachmentFeeReason.getId()) continue;
                enchroachmentFeeAlreadyExistInDemand = true;
                if (advertisementPermitDetail.getEncroachmentFee() != null && advertisementPermitDetail.getEncroachmentFee().compareTo(BigDecimal.ZERO) > 0) {
                    totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getEncroachmentFee().subtract(dmdDtl.getAmount()));
                    dmdDtl.setAmount(advertisementPermitDetail.getEncroachmentFee().setScale(0, 4));
                    continue;
                }
                totalDemandAmount = totalDemandAmount.subtract(dmdDtl.getAmount());
                removableDemandDetailList.add(dmdDtl);
            }
            for (EgDemandDetails removableDmdDtl : removableDemandDetailList) {
                demand.removeEgDemandDetails(removableDmdDtl);
            }
            if (!enchroachmentFeeAlreadyExistInDemand.booleanValue() && advertisementPermitDetail.getEncroachmentFee() != null && advertisementPermitDetail.getEncroachmentFee().compareTo(BigDecimal.ZERO) > 0) {
                demand.addEgDemandDetails(this.createDemandDetails(advertisementPermitDetail.getEncroachmentFee(), this.getDemandReasonByCodeAndInstallment("Enchroachmnt_Fee", installment), BigDecimal.ZERO));
                totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getEncroachmentFee());
            }
            demand.addBaseDemand(totalDemandAmount.setScale(0, 4));
        }
        return demand;
    }

    public EgDemand updateDemandOnRenewal(AdvertisementPermitDetail advertisementPermitDetail, EgDemand demand) {
        if (demand != null) {
            ArrayList<EgDemandDetails> removableDemandDetailList = new ArrayList<EgDemandDetails>();
            Installment installment = demand.getEgInstallmentMaster();
            BigDecimal totalDemandAmount = BigDecimal.ZERO;
            Boolean enchroachmentFeeAlreadyExistInDemand = false;
            EgDemandReason encroachmentFeeReason = this.getDemandReasonByCodeAndInstallment("Enchroachmnt_Fee", installment);
            EgDemandReason taxReason = this.getDemandReasonByCodeAndInstallment("Advertisemnt_Tax", installment);
            for (EgDemandDetails dmdDtl : demand.getEgDemandDetails()) {
                if (dmdDtl.getEgDemandReason().getId() == taxReason.getId() && advertisementPermitDetail.getTaxAmount().compareTo(BigDecimal.ZERO) >= 0) {
                    totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getTaxAmount().subtract(dmdDtl.getAmount()));
                    dmdDtl.setAmount(advertisementPermitDetail.getTaxAmount().setScale(0, 4));
                }
                if (dmdDtl.getEgDemandReason().getId() != encroachmentFeeReason.getId()) continue;
                enchroachmentFeeAlreadyExistInDemand = true;
                if (advertisementPermitDetail.getEncroachmentFee() != null && advertisementPermitDetail.getEncroachmentFee().compareTo(BigDecimal.ZERO) > 0) {
                    totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getEncroachmentFee().subtract(dmdDtl.getAmount()));
                    dmdDtl.setAmount(advertisementPermitDetail.getEncroachmentFee().setScale(0, 4));
                    continue;
                }
                totalDemandAmount = totalDemandAmount.subtract(dmdDtl.getAmount());
                removableDemandDetailList.add(dmdDtl);
            }
            if (!enchroachmentFeeAlreadyExistInDemand.booleanValue() && advertisementPermitDetail.getEncroachmentFee() != null && advertisementPermitDetail.getEncroachmentFee().compareTo(BigDecimal.ZERO) > 0) {
                demand.addEgDemandDetails(this.createDemandDetails(advertisementPermitDetail.getEncroachmentFee(), this.getDemandReasonByCodeAndInstallment("Enchroachmnt_Fee", installment), BigDecimal.ZERO));
                totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getEncroachmentFee());
            }
            for (EgDemandDetails removableDmdDtl : removableDemandDetailList) {
                demand.removeEgDemandDetails(removableDmdDtl);
            }
            demand.addBaseDemand(totalDemandAmount.setScale(0, 4));
        }
        return demand;
    }

    public EgDemand updateDemandForLegacyEntry(AdvertisementPermitDetail advertisementPermitDetail, EgDemand demand) {
        Installment installment = this.getCurrentInstallment();
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        Boolean taxFullyPaidForCurrentYear = false;
        if (advertisementPermitDetail.getAdvertisement() != null && advertisementPermitDetail.getAdvertisement().getLegacy().booleanValue() && advertisementPermitDetail.getAdvertisement().getTaxPaidForCurrentYear().booleanValue()) {
            taxFullyPaidForCurrentYear = true;
        }
        Boolean enchroachmentFeeAlreadyExistInDemand = false;
        Boolean arrearsTaxalreadyExistInDemand = false;
        Boolean taxalreadyExistInDemand = false;
        ArrayList<EgDemandDetails> deleteDmdDtl = new ArrayList<EgDemandDetails>();
        if (demand == null) {
            demand = this.createDemand(advertisementPermitDetail);
        } else {
            EgDemandReason pendingTaxReason = this.getDemandReasonByCodeAndInstallment("Arrear_Adv_Tax", installment);
            EgDemandReason encroachmentFeeReason = this.getDemandReasonByCodeAndInstallment("Enchroachmnt_Fee", installment);
            EgDemandReason taxReason = this.getDemandReasonByCodeAndInstallment("Advertisemnt_Tax", installment);
            for (EgDemandDetails dmdDtl : demand.getEgDemandDetails()) {
                if (dmdDtl.getEgDemandReason().getId() == taxReason.getId()) {
                    taxalreadyExistInDemand = true;
                    if (advertisementPermitDetail.getTaxAmount().compareTo(BigDecimal.ZERO) > 0) {
                        totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getTaxAmount().subtract(dmdDtl.getAmount()));
                        dmdDtl.setAmount(advertisementPermitDetail.getTaxAmount().setScale(0, 4));
                        if (taxFullyPaidForCurrentYear.booleanValue()) {
                            dmdDtl.setAmtCollected(advertisementPermitDetail.getTaxAmount() != null ? advertisementPermitDetail.getTaxAmount() : BigDecimal.ZERO);
                            continue;
                        }
                        dmdDtl.setAmtCollected(BigDecimal.ZERO);
                        continue;
                    }
                    totalDemandAmount = totalDemandAmount.subtract(dmdDtl.getAmount());
                    deleteDmdDtl.add(dmdDtl);
                    continue;
                }
                if (dmdDtl.getEgDemandReason().getId() == pendingTaxReason.getId()) {
                    arrearsTaxalreadyExistInDemand = true;
                    if (advertisementPermitDetail.getAdvertisement().getPendingTax() != null && advertisementPermitDetail.getAdvertisement().getPendingTax().compareTo(BigDecimal.ZERO) > 0) {
                        totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getAdvertisement().getPendingTax().subtract(dmdDtl.getAmount()));
                        dmdDtl.setAmount(advertisementPermitDetail.getAdvertisement().getPendingTax().setScale(0, 4));
                        dmdDtl.setAmtCollected(BigDecimal.ZERO);
                        continue;
                    }
                    totalDemandAmount = totalDemandAmount.subtract(dmdDtl.getAmount());
                    deleteDmdDtl.add(dmdDtl);
                    continue;
                }
                if (dmdDtl.getEgDemandReason().getId() != encroachmentFeeReason.getId()) continue;
                enchroachmentFeeAlreadyExistInDemand = true;
                if (advertisementPermitDetail.getEncroachmentFee() != null && advertisementPermitDetail.getEncroachmentFee().compareTo(BigDecimal.ZERO) > 0) {
                    totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getEncroachmentFee().subtract(dmdDtl.getAmount()));
                    dmdDtl.setAmount(advertisementPermitDetail.getEncroachmentFee().setScale(0, 4));
                    if (taxFullyPaidForCurrentYear.booleanValue()) {
                        dmdDtl.setAmtCollected(advertisementPermitDetail.getEncroachmentFee() != null ? advertisementPermitDetail.getEncroachmentFee() : BigDecimal.ZERO);
                        continue;
                    }
                    dmdDtl.setAmtCollected(BigDecimal.ZERO);
                    continue;
                }
                totalDemandAmount = totalDemandAmount.subtract(dmdDtl.getAmount());
                deleteDmdDtl.add(dmdDtl);
            }
            for (EgDemandDetails dmdDtls : deleteDmdDtl) {
                demand.removeEgDemandDetails(dmdDtls);
            }
            if (!enchroachmentFeeAlreadyExistInDemand.booleanValue() && advertisementPermitDetail.getEncroachmentFee() != null && advertisementPermitDetail.getEncroachmentFee().compareTo(BigDecimal.ZERO) > 0) {
                demand.addEgDemandDetails(this.createDemandDetails(advertisementPermitDetail.getEncroachmentFee(), this.getDemandReasonByCodeAndInstallment("Enchroachmnt_Fee", installment), taxFullyPaidForCurrentYear != false ? advertisementPermitDetail.getEncroachmentFee() : BigDecimal.ZERO));
                totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getEncroachmentFee());
                demand.setEgInstallmentMaster(installment);
            }
            if (!arrearsTaxalreadyExistInDemand.booleanValue() && advertisementPermitDetail.getAdvertisement().getPendingTax() != null && advertisementPermitDetail.getAdvertisement().getPendingTax().compareTo(BigDecimal.ZERO) > 0) {
                demand.addEgDemandDetails(this.createDemandDetails(advertisementPermitDetail.getAdvertisement().getPendingTax(), this.getDemandReasonByCodeAndInstallment("Arrear_Adv_Tax", installment), BigDecimal.ZERO));
                totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getAdvertisement().getPendingTax());
                demand.setEgInstallmentMaster(installment);
            }
            if (!taxalreadyExistInDemand.booleanValue() && advertisementPermitDetail.getTaxAmount() != null && advertisementPermitDetail.getTaxAmount().compareTo(BigDecimal.ZERO) > 0) {
                demand.addEgDemandDetails(this.createDemandDetails(advertisementPermitDetail.getTaxAmount(), this.getDemandReasonByCodeAndInstallment("Advertisemnt_Tax", installment), taxFullyPaidForCurrentYear != false ? advertisementPermitDetail.getTaxAmount() : BigDecimal.ZERO));
                totalDemandAmount = totalDemandAmount.add(advertisementPermitDetail.getTaxAmount());
                demand.setEgInstallmentMaster(installment);
            }
            demand.addBaseDemand(totalDemandAmount.setScale(0, 4));
        }
        return demand;
    }

    public int generateDemandForNextInstallment(List<Advertisement> advertisements, List<Installment> previousInstallment, Installment advDmdGenerationInstallment) {
        int totalRecordsProcessed = 0;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.debug((Object)("****************** total  records in generateDemandForNextInstallment " + advertisements.size()));
        }
        if (!advertisements.isEmpty()) {
            EgDemandReason encroachmentFeeReasonOldInstallment = this.getDemandReasonByCodeAndInstallment("Enchroachmnt_Fee", previousInstallment.get(0));
            EgDemandReason taxReasonOldInstallment = this.getDemandReasonByCodeAndInstallment("Advertisemnt_Tax", previousInstallment.get(0));
            EgDemandReason encroachmentFeeReasonNewInstallment = this.getDemandReasonByCodeAndInstallment("Enchroachmnt_Fee", advDmdGenerationInstallment);
            EgDemandReason taxReasonNewInstallment = this.getDemandReasonByCodeAndInstallment("Advertisemnt_Tax", advDmdGenerationInstallment);
            AdvertisementDemandGenerationLog generationLog = (AdvertisementDemandGenerationLog)((Object)this.transactionTemplate.execute(result -> this.adTaxDemandGenerationLogService.createDemandGenerationLog(advDmdGenerationInstallment.getFinYearRange())));
            for (Advertisement advertisement : advertisements) {
                try {
                    this.transactionTemplate.execute(result -> {
                        if (generationLog != null) {
                            AdvertisementDemandGenerationLog generationLogObject = this.adTaxDemandGenerationLogRepository.findById(generationLog.getId());
                            this.adTaxDemandGenerationLogService.createOrGetDemandGenerationLogDetail(generationLogObject, advertisement, ProcessStatus.COMPLETED, SUCCESSFUL);
                        }
                        EgDemand demand = this.generateNextYearDemandForAdvertisement(advertisement, encroachmentFeeReasonOldInstallment, taxReasonOldInstallment, encroachmentFeeReasonNewInstallment, taxReasonNewInstallment);
                        advertisement.setDemandId(demand);
                        this.advertisementService.updateAdvertisement(advertisement);
                        return Boolean.TRUE;
                    });
                    ++totalRecordsProcessed;
                }
                catch (Exception e) {
                    this.transactionTemplate.execute(result -> {
                        if (generationLog != null) {
                            AdvertisementDemandGenerationLog generationLogObject = this.adTaxDemandGenerationLogRepository.findById(generationLog.getId());
                            generationLogObject.setDemandGenerationStatus(ProcessStatus.INCOMPLETE);
                            this.adTaxDemandGenerationLogService.createOrGetDemandGenerationLogDetail(generationLogObject, advertisement, ProcessStatus.INCOMPLETE, this.getErrorMessage(e));
                            this.getErrorMessage(e);
                        }
                        return Boolean.FALSE;
                    });
                }
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Finished... generateDemandForNextInstallment...........total records ." + totalRecordsProcessed));
        }
        return totalRecordsProcessed;
    }

    private EgDemand generateNextYearDemandForAdvertisement(Advertisement advertisement, EgDemandReason oldencroachmentFeeReasonInstallment, EgDemandReason oldtaxReasonInstallment, EgDemandReason newencroachmentFeeReasonInstallment, EgDemandReason newtaxReasonInstallment) {
        BigDecimal totalDemandAmount = BigDecimal.ZERO;
        EgDemand demand = advertisement.getDemandId();
        Boolean enchroachmentFeeAlreadyExistInDemand = false;
        Boolean taxFeeAlreadyExistInDemand = false;
        EgDemandDetails oldEncroachmentDetail = null;
        EgDemandDetails oldTaxDemandDetail = null;
        Set dmadDtl = demand.getEgDemandDetails();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Demand Detail size" + dmadDtl.size()));
        }
        for (EgDemandDetails dmdDtl : dmadDtl) {
            if (dmdDtl.getEgDemandReason().getId() == oldtaxReasonInstallment.getId()) {
                oldTaxDemandDetail = dmdDtl;
            }
            if (dmdDtl.getEgDemandReason().getId() == oldencroachmentFeeReasonInstallment.getId()) {
                oldEncroachmentDetail = dmdDtl;
            }
            if (dmdDtl.getEgDemandReason().getId() == newtaxReasonInstallment.getId()) {
                taxFeeAlreadyExistInDemand = true;
            }
            if (dmdDtl.getEgDemandReason().getId() != newencroachmentFeeReasonInstallment.getId()) continue;
            enchroachmentFeeAlreadyExistInDemand = true;
        }
        if (!enchroachmentFeeAlreadyExistInDemand.booleanValue() && oldEncroachmentDetail != null) {
            demand.addEgDemandDetails(this.createDemandDetails(oldEncroachmentDetail.getAmount(), newencroachmentFeeReasonInstallment, BigDecimal.ZERO));
            totalDemandAmount = totalDemandAmount.add(oldEncroachmentDetail.getAmount());
        }
        if (!taxFeeAlreadyExistInDemand.booleanValue() && oldTaxDemandDetail != null) {
            demand.addEgDemandDetails(this.createDemandDetails(oldTaxDemandDetail.getAmount(), newtaxReasonInstallment, BigDecimal.ZERO));
            totalDemandAmount = totalDemandAmount.add(oldTaxDemandDetail.getAmount());
        }
        demand.setEgInstallmentMaster(newencroachmentFeeReasonInstallment.getEgInstallmentMaster());
        demand.addBaseDemand(totalDemandAmount.setScale(0, 4));
        return demand;
    }

    public Map<String, BigDecimal> checkPendingAmountByDemand(AdvertisementPermitDetail advPermitDetail) {
        LinkedHashMap<String, BigDecimal> demandFeeType = new LinkedHashMap<String, BigDecimal>();
        BigDecimal totalDemand = BigDecimal.ZERO;
        BigDecimal totalCollection = BigDecimal.ZERO;
        BigDecimal totalPending = BigDecimal.ZERO;
        BigDecimal penaltyAmount = BigDecimal.ZERO;
        BigDecimal additionalTaxAmount = BigDecimal.ZERO;
        if (advPermitDetail != null && advPermitDetail.getAdvertisement() != null && advPermitDetail.getAdvertisement().getDemandId() != null) {
            for (EgDemandDetails demandDtl : advPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                totalDemand = totalDemand.add(demandDtl.getAmount());
                totalCollection = totalCollection.add(demandDtl.getAmtCollected());
                totalPending = totalPending.add(demandDtl.getAmount().subtract(demandDtl.getAmtCollected()));
            }
            penaltyAmount = this.advertisementPenaltyCalculator.calculatePenalty(advPermitDetail);
            additionalTaxAmount = this.advertisementAdditionalTaxCalculator.getTotalAdditionalTaxesByPassingAdvertisementPermit(advPermitDetail);
        }
        totalDemand = totalDemand.setScale(2, 6);
        totalCollection = totalCollection.setScale(2, 6);
        totalPending = totalPending.setScale(2, 6);
        penaltyAmount = penaltyAmount.setScale(2, 6);
        demandFeeType.put("PENDINGDEMANDAMOUNT", totalPending);
        demandFeeType.put("Demand", totalDemand);
        demandFeeType.put(" Total Collection", totalCollection);
        demandFeeType.put("PENALTYAMOUNT", penaltyAmount);
        demandFeeType.put("ADDITIONALTAXAMOUNT", additionalTaxAmount.setScale(0, 4));
        return demandFeeType;
    }

    public BigDecimal getPendingArrearsTax(AdvertisementPermitDetail advertisementPermitDetail) {
        BigDecimal arrearTax = BigDecimal.ZERO;
        if (advertisementPermitDetail.getAdvertisement() != null && advertisementPermitDetail.getAdvertisement().getDemandId() != null) {
            for (EgDemandDetails egDemandDetails : advertisementPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                if (!"Arrear_Adv_Tax".equalsIgnoreCase(egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
                arrearTax = arrearTax.add(egDemandDetails.getAmount().subtract(egDemandDetails.getAmtCollected() != null ? egDemandDetails.getAmtCollected() : BigDecimal.ZERO));
            }
        }
        return arrearTax;
    }

    public Map<String, Map<String, BigDecimal>> getReasonWiseDemandAndCollection(AdvertisementPermitDetail advPermitDetail) {
        HashMap<String, Map<String, BigDecimal>> reasonwiseDmnd_CollDtls = new HashMap<String, Map<String, BigDecimal>>();
        HashMap<String, BigDecimal> demandCollectionSum = null;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalAmountCollected = BigDecimal.ZERO;
        if (advPermitDetail != null && advPermitDetail.getAdvertisement() != null && advPermitDetail.getAdvertisement().getDemandId() != null) {
            for (EgDemandDetails demandDtl : advPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                demandCollectionSum = new HashMap();
                if (reasonwiseDmnd_CollDtls.containsKey(demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode())) {
                    Map temp = (Map)reasonwiseDmnd_CollDtls.get(demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode());
                    demandCollectionSum.put("demandAmount", ((BigDecimal)temp.get("demandAmount")).add(demandDtl.getAmount() != null ? demandDtl.getAmount() : BigDecimal.ZERO));
                    demandCollectionSum.put("collectedAmount", ((BigDecimal)temp.get("collectedAmount")).add(demandDtl.getAmtCollected() != null ? demandDtl.getAmtCollected() : BigDecimal.ZERO));
                    totalAmount = totalAmount.add(demandDtl.getAmount() != null ? demandDtl.getAmount() : BigDecimal.ZERO);
                    totalAmountCollected = totalAmountCollected.add(demandDtl.getAmtCollected() != null ? demandDtl.getAmtCollected() : BigDecimal.ZERO);
                    reasonwiseDmnd_CollDtls.put(demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode(), demandCollectionSum);
                    continue;
                }
                demandCollectionSum.put("demandAmount", demandDtl.getAmount());
                demandCollectionSum.put("collectedAmount", demandDtl.getAmtCollected());
                totalAmount = totalAmount.add(demandDtl.getAmount());
                totalAmountCollected = totalAmountCollected.add(demandDtl.getAmtCollected());
                reasonwiseDmnd_CollDtls.put(demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode(), demandCollectionSum);
            }
            demandCollectionSum = new HashMap<String, BigDecimal>();
            demandCollectionSum.put("totalAmount", totalAmount);
            demandCollectionSum.put("totalAmountCollected", totalAmountCollected);
            reasonwiseDmnd_CollDtls.put("Total", demandCollectionSum);
        }
        return reasonwiseDmnd_CollDtls;
    }

    private String getErrorMessage(Exception exception) {
        String error = exception instanceof ValidationException ? ((ValidationError)((ValidationException)exception).getErrors().get(0)).getMessage() : "Error : " + exception;
        return error;
    }
}

