/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementDemandGenerationLog;
import org.egov.adtax.entity.AdvertisementDemandGenerationLogDetail;
import org.egov.adtax.entity.enums.ProcessStatus;
import org.egov.adtax.repository.AdTaxDemandGenerationLogDetailRepository;
import org.egov.adtax.repository.AdTaxDemandGenerationLogRepository;
import org.egov.adtax.search.contract.AdvertisementDemandStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(readOnly=true)
public class AdTaxDemandGenerationLogService {
    @Autowired
    private AdTaxDemandGenerationLogRepository adTaxDemandGenerationLogRepository;
    @Autowired
    private AdTaxDemandGenerationLogDetailRepository adTaxDemandGenerationLogDetailRepository;

    public List<AdvertisementDemandGenerationLog> getDemandGenerationLogByInstallmentYear(String installmentYear) {
        return this.adTaxDemandGenerationLogRepository.findByInstallmentYearOrderByIdDesc(installmentYear);
    }

    public List<AdvertisementDemandGenerationLogDetail> getDemandGenerationLogDetailByDemandGenerationLog(AdvertisementDemandGenerationLog demandGenerationLog) {
        return this.adTaxDemandGenerationLogDetailRepository.findByDemandGenerationLogIdOrderByIdDesc(demandGenerationLog.getId());
    }

    public AdvertisementDemandGenerationLog createDemandGenerationLog(String installmentYear) {
        return (AdvertisementDemandGenerationLog)((Object)this.adTaxDemandGenerationLogRepository.saveAndFlush((Object)new AdvertisementDemandGenerationLog(installmentYear)));
    }

    public AdvertisementDemandGenerationLog updateDemandGenerationLog(AdvertisementDemandGenerationLog demandGenerationLog) {
        return (AdvertisementDemandGenerationLog)((Object)this.adTaxDemandGenerationLogRepository.saveAndFlush((Object)demandGenerationLog));
    }

    public AdvertisementDemandGenerationLogDetail createOrGetDemandGenerationLogDetail(AdvertisementDemandGenerationLog generationLog, Advertisement advertisement, ProcessStatus status, String detailMessage) {
        AdvertisementDemandGenerationLogDetail logDetail = this.adTaxDemandGenerationLogDetailRepository.findByDemandGenerationLogIdAndAdvertisementId(generationLog.getId(), advertisement.getId());
        if (logDetail == null) {
            logDetail = new AdvertisementDemandGenerationLogDetail();
            logDetail.setDemandGenerationLog(generationLog);
            logDetail.setAdvertisement(advertisement);
            logDetail.setStatus(status);
            logDetail.setDetail(detailMessage);
            generationLog.addDetails(logDetail);
            logDetail = (AdvertisementDemandGenerationLogDetail)((Object)this.adTaxDemandGenerationLogDetailRepository.saveAndFlush((Object)logDetail));
        }
        return logDetail;
    }

    @Transactional
    public AdvertisementDemandGenerationLogDetail updateDemandGenerationLogDetail(AdvertisementDemandGenerationLogDetail logDetail) {
        return (AdvertisementDemandGenerationLogDetail)((Object)this.adTaxDemandGenerationLogDetailRepository.saveAndFlush((Object)logDetail));
    }

    public List<AdvertisementDemandGenerationLog> findAllOrderByIdDesc() {
        return this.adTaxDemandGenerationLogRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"id"}));
    }

    public List<AdvertisementDemandStatus> getLogDetailResultList(List<AdvertisementDemandGenerationLogDetail> logDetail, AdvertisementDemandGenerationLog demandGenerationLog, List<Long> detailList, boolean value) {
        ArrayList<AdvertisementDemandStatus> successRecordsList = new ArrayList<AdvertisementDemandStatus>();
        ArrayList<AdvertisementDemandStatus> failedRecordsList = new ArrayList<AdvertisementDemandStatus>();
        ArrayList<AdvertisementDemandStatus> resultList = new ArrayList<AdvertisementDemandStatus>();
        for (AdvertisementDemandGenerationLogDetail detail : logDetail) {
            if (detailList.contains(detail.getAdvertisement().getId())) continue;
            AdvertisementDemandStatus statusObject = new AdvertisementDemandStatus();
            statusObject.setFinancialYear(demandGenerationLog.getInstallmentYear());
            Advertisement advertisement = detail.getAdvertisement();
            statusObject.setAdvertisementNumber(advertisement.getAdvertisementNumber());
            statusObject.setStatus(detail.getStatus().toString());
            statusObject.setDetails(detail.getDetail());
            if (ProcessStatus.COMPLETED.equals((Object)detail.getStatus())) {
                successRecordsList.add(statusObject);
            } else if (ProcessStatus.INCOMPLETE.equals((Object)detail.getStatus())) {
                failedRecordsList.add(statusObject);
            }
            detailList.add(detail.getAdvertisement().getId());
        }
        if (value) {
            resultList.addAll(successRecordsList);
        } else {
            resultList.addAll(failedRecordsList);
        }
        return resultList;
    }

    public AdvertisementDemandStatus getDemandStatusResult(List<AdvertisementDemandGenerationLog> logList) {
        AdvertisementDemandStatus demandStatus = new AdvertisementDemandStatus();
        Long noOfSuccess = 0L;
        Long noOfFailure = 0L;
        ArrayList<String> advertisementNoList = new ArrayList<String>();
        for (AdvertisementDemandGenerationLog log : logList) {
            List<AdvertisementDemandGenerationLogDetail> logDetailList = this.getDemandGenerationLogDetailByDemandGenerationLog(log);
            for (AdvertisementDemandGenerationLogDetail logDetail : logDetailList) {
                if (StringUtils.isEmpty(advertisementNoList)) {
                    advertisementNoList.add(logDetail.getAdvertisement().getAdvertisementNumber());
                } else if (!advertisementNoList.contains(logDetail.getAdvertisement().getAdvertisementNumber())) {
                    Long l;
                    Long l2;
                    if (ProcessStatus.COMPLETED.equals((Object)logDetail.getStatus())) {
                        l2 = noOfSuccess;
                        l = noOfSuccess = Long.valueOf(noOfSuccess + 1L);
                    } else if (ProcessStatus.INCOMPLETE.equals((Object)logDetail.getStatus())) {
                        l2 = noOfFailure;
                        l = noOfFailure = Long.valueOf(noOfFailure + 1L);
                    }
                }
                advertisementNoList.add(logDetail.getAdvertisement().getAdvertisementNumber());
            }
        }
        demandStatus.setNoOfSuccess(noOfSuccess);
        demandStatus.setNoOfFailure(noOfFailure);
        return demandStatus;
    }
}

