/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.penalty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.exception.HoardingValidationError;
import org.egov.adtax.service.AdvertisementPenaltyRatesService;
import org.egov.adtax.service.penalty.AdvertisementPenaltyCalculator;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementPenaltyCalculatorImpl
implements AdvertisementPenaltyCalculator {
    @Autowired
    private AdvertisementPenaltyRatesService advertisementPenaltyRatesService;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    @Override
    public BigDecimal calculatePenalty(AdvertisementPermitDetail advPermitDetail) throws HoardingValidationError {
        BigDecimal penaltyAmt = BigDecimal.ZERO;
        if (this.penaltyCalculationRequired().booleanValue() && advPermitDetail != null && advPermitDetail.getAdvertisement() != null && advPermitDetail.getAdvertisement().getDemandId() != null) {
            for (EgDemandDetails demandDtl : advPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                penaltyAmt = penaltyAmt.add(this.getPenaltyAmount(advPermitDetail, demandDtl));
            }
        }
        return penaltyAmt.setScale(0, 4);
    }

    private BigDecimal getPenaltyAmount(AdvertisementPermitDetail advPermitDetail, EgDemandDetails demandDtl) {
        double percentage = 0.0;
        int days = 0;
        BigDecimal penaltyAmt = BigDecimal.ZERO;
        if (demandDtl.getBalance().compareTo(BigDecimal.ZERO) > 0 && (percentage = this.advertisementPenaltyRatesService.findPenaltyRatesByNumberOfDays(Long.valueOf(days = this.calculateNumberOfDaysForPenaltyCalculation(advPermitDetail, demandDtl))).doubleValue()) > 0.0) {
            penaltyAmt = demandDtl.getBalance().multiply(BigDecimal.valueOf(percentage)).divide(BigDecimal.valueOf(100L).setScale(0, 4));
        }
        return penaltyAmt;
    }

    private int calculateNumberOfDaysForPenaltyCalculation(AdvertisementPermitDetail advPermitDetail, EgDemandDetails demandDtl) {
        int days = 0;
        if (demandDtl.getInstallmentStartDate().after(new Date())) {
            days = Days.daysBetween((ReadableInstant)new DateTime((Object)demandDtl.getInstallmentStartDate()), (ReadableInstant)new DateTime((Object)new Date())).getDays();
        } else if (demandDtl.getInstallmentStartDate().before(new Date())) {
            days = advPermitDetail.getAdvertisement().getPenaltyCalculationDate() != null && demandDtl.getInstallmentStartDate().before(advPermitDetail.getAdvertisement().getPenaltyCalculationDate()) && (demandDtl.getInstallmentEndDate().equals(advPermitDetail.getAdvertisement().getPenaltyCalculationDate()) || demandDtl.getInstallmentEndDate().after(advPermitDetail.getAdvertisement().getPenaltyCalculationDate())) ? Days.daysBetween((ReadableInstant)new DateTime((Object)advPermitDetail.getAdvertisement().getPenaltyCalculationDate()), (ReadableInstant)new DateTime((Object)new Date())).getDays() : Days.daysBetween((ReadableInstant)new DateTime((Object)demandDtl.getInstallmentStartDate()), (ReadableInstant)new DateTime((Object)new Date())).getDays();
        }
        return days;
    }

    @Override
    public Map<Installment, BigDecimal> getPenaltyByInstallment(AdvertisementPermitDetail advPermitDetail) {
        HashMap<Installment, BigDecimal> penaltyReasons = new HashMap<Installment, BigDecimal>();
        BigDecimal penaltyAmt = BigDecimal.ZERO;
        if (this.penaltyCalculationRequired().booleanValue() && advPermitDetail != null && advPermitDetail.getAdvertisement() != null && advPermitDetail.getAdvertisement().getDemandId() != null) {
            for (EgDemandDetails egDemandDetails : advPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                penaltyAmt = this.getPenaltyAmount(advPermitDetail, egDemandDetails);
                if (penaltyReasons.get(egDemandDetails.getEgDemandReason().getEgInstallmentMaster()) == null) {
                    penaltyReasons.put(egDemandDetails.getEgDemandReason().getEgInstallmentMaster(), penaltyAmt);
                    continue;
                }
                penaltyReasons.put(egDemandDetails.getEgDemandReason().getEgInstallmentMaster(), ((BigDecimal)penaltyReasons.get(egDemandDetails.getEgDemandReason().getEgInstallmentMaster())).add(penaltyAmt));
            }
        }
        if (penaltyReasons != null && penaltyReasons.size() > 0) {
            for (Map.Entry entry : penaltyReasons.entrySet()) {
                entry.setValue(((BigDecimal)entry.getValue()).setScale(0, 4));
            }
        }
        return penaltyReasons;
    }

    private Boolean penaltyCalculationRequired() throws HoardingValidationError {
        AppConfigValues ispenaltyCalculationRequired = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "Penalty Calculation required").get(0);
        if (ispenaltyCalculationRequired == null) {
            throw new HoardingValidationError("taxAmount", "ADTAX.004");
        }
        if (ispenaltyCalculationRequired != null && "YES".equalsIgnoreCase(ispenaltyCalculationRequired.getValue())) {
            return true;
        }
        return false;
    }
}

