/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.AgencyWiseCollection;
import org.egov.adtax.entity.AgencyWiseCollectionDetail;
import org.egov.adtax.entity.AgencyWiseCollectionSearch;
import org.egov.adtax.repository.AgencyWiseCollectionRepository;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.penalty.AdvertisementPenaltyCalculator;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AgencyWiseCollectionService {
    private final AgencyWiseCollectionRepository agencyWiseCollectionRepository;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    private AdvertisementPenaltyCalculator advertisementPenaltyCalculator;

    @Autowired
    public AgencyWiseCollectionService(AgencyWiseCollectionRepository agencyWiseCollectionRepository) {
        this.agencyWiseCollectionRepository = agencyWiseCollectionRepository;
    }

    public AgencyWiseCollection findBy(Long id) {
        return (AgencyWiseCollection)((Object)this.agencyWiseCollectionRepository.findOne(id));
    }

    public AgencyWiseCollection findByBillNumber(String billNumber) {
        return this.agencyWiseCollectionRepository.findByBillNumber(billNumber);
    }

    @Transactional
    public AgencyWiseCollection createAgencyWiseCollection(AgencyWiseCollection agencyWiseCollection) {
        return (AgencyWiseCollection)((Object)this.agencyWiseCollectionRepository.save((Object)agencyWiseCollection));
    }

    public AgencyWiseCollection getAgencyWiseCollectionByDemand(EgDemand demand) {
        return this.agencyWiseCollectionRepository.findAgencyWiseCollectionByDemand(demand.getId());
    }

    public AgencyWiseCollection buildAgencyWiseObjectByHoardings(String[] hoardingList) {
        HashSet<AgencyWiseCollectionDetail> agencyWiseCollectionDetails = new HashSet<AgencyWiseCollectionDetail>(0);
        BigDecimal totalAmount = BigDecimal.ZERO;
        AgencyWiseCollection agencyWiseCollection = new AgencyWiseCollection();
        Installment installment = this.advertisementDemandService.getCurrentInstallment();
        Map<Object, Object> penaltyReasons = null;
        for (String hoardingId : hoardingList) {
            AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(hoardingId.trim()));
            penaltyReasons = new HashMap();
            if (advertisementPermitDetail == null || advertisementPermitDetail.getAdvertisement() == null) continue;
            for (EgDemandDetails demandDtl : advertisementPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                if (demandDtl.getAmount().subtract(demandDtl.getAmtCollected()).compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal amount = demandDtl.getAmount().subtract(demandDtl.getAmtCollected());
                totalAmount = totalAmount.add(amount);
                this.buildAgencyWiseCollectionDetail(agencyWiseCollectionDetails, agencyWiseCollection, demandDtl, amount);
            }
            penaltyReasons = this.advertisementPenaltyCalculator.getPenaltyByInstallment(advertisementPermitDetail);
            if (penaltyReasons == null || penaltyReasons.size() <= 0) continue;
            BigDecimal penaltyAmount = BigDecimal.ZERO;
            for (Map.Entry<Object, Object> penaltyReason : penaltyReasons.entrySet()) {
                penaltyAmount = (BigDecimal)penaltyReason.getValue();
                if (penaltyAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                totalAmount = totalAmount.add(penaltyAmount);
                EgDemandReason pendingTaxReason = this.advertisementDemandService.getDemandReasonByCodeAndInstallment("Penalty", (Installment)penaltyReason.getKey());
                List<EgDemandDetails> penaltyDmtDtails = this.advertisementDemandService.getDemandDetailByPassingDemandDemandReason(advertisementPermitDetail.getAdvertisement().getDemandId(), pendingTaxReason);
                AgencyWiseCollectionDetail agencyWiseDt = new AgencyWiseCollectionDetail();
                agencyWiseDt.setDemand(advertisementPermitDetail.getAdvertisement().getDemandId());
                agencyWiseDt.setDemandreason(pendingTaxReason);
                agencyWiseDt.setAmount(penaltyAmount);
                agencyWiseDt.setAgencyWiseCollection(agencyWiseCollection);
                if (penaltyDmtDtails != null && penaltyDmtDtails.size() > 0) {
                    agencyWiseDt.setDemandDetail(penaltyDmtDtails.get(0));
                } else {
                    agencyWiseDt.setDemandDetail(null);
                }
                agencyWiseCollectionDetails.add(agencyWiseDt);
            }
        }
        if (agencyWiseCollection != null) {
            this.buildAgencyWiseDemand(agencyWiseCollectionDetails, totalAmount, agencyWiseCollection, installment);
            agencyWiseCollection.setAgencyWiseCollectionDetails(agencyWiseCollectionDetails);
            agencyWiseCollection.setTotalAmount(totalAmount);
        }
        return agencyWiseCollection;
    }

    private void buildAgencyWiseDemand(Set<AgencyWiseCollectionDetail> agencyWiseCollectionDetails, BigDecimal totalAmount, AgencyWiseCollection agencyWiseCollection, Installment installment) {
        EgDemand agencyWiseDemand = new EgDemand();
        HashMap<EgDemandReason, BigDecimal> demandReasonWiseList = this.getAmountGroupingDemandReason(agencyWiseCollectionDetails);
        if (demandReasonWiseList.size() > 0) {
            demandReasonWiseList.forEach((key, value) -> agencyWiseDemand.addEgDemandDetails(EgDemandDetails.fromReasonAndAmounts((BigDecimal)value, (EgDemandReason)key, (BigDecimal)BigDecimal.ZERO)));
        }
        agencyWiseDemand.setEgInstallmentMaster(installment);
        agencyWiseDemand.setIsHistory("Y");
        agencyWiseDemand.setCreateDate(new Date());
        agencyWiseDemand.setBaseDemand(totalAmount);
        agencyWiseDemand.setModifiedDate(new Date());
        agencyWiseCollection.setAgencyWiseDemand(agencyWiseDemand);
    }

    private HashMap<EgDemandReason, BigDecimal> getAmountGroupingDemandReason(Set<AgencyWiseCollectionDetail> agencyWiseCollectionDetails) {
        HashMap<EgDemandReason, BigDecimal> demandReasonWiseList = new HashMap<EgDemandReason, BigDecimal>();
        for (AgencyWiseCollectionDetail agencyWiseDtl : agencyWiseCollectionDetails) {
            if (demandReasonWiseList.get(agencyWiseDtl.getDemandreason()) == null) {
                demandReasonWiseList.put(agencyWiseDtl.getDemandreason(), agencyWiseDtl.getAmount());
                continue;
            }
            demandReasonWiseList.put(agencyWiseDtl.getDemandreason(), demandReasonWiseList.get(agencyWiseDtl.getDemandreason()).add(agencyWiseDtl.getAmount()));
        }
        return demandReasonWiseList;
    }

    private void buildAgencyWiseCollectionDetail(Set<AgencyWiseCollectionDetail> agencyWiseCollectionDetails, AgencyWiseCollection agencyWiseCollection, EgDemandDetails demandDtl, BigDecimal amount) {
        AgencyWiseCollectionDetail agencyWiseDt = new AgencyWiseCollectionDetail();
        agencyWiseDt.setDemand(demandDtl.getEgDemand());
        agencyWiseDt.setDemandDetail(demandDtl);
        agencyWiseDt.setDemandreason(demandDtl.getEgDemandReason());
        agencyWiseDt.setAmount(amount);
        agencyWiseDt.setAgencyWiseCollection(agencyWiseCollection);
        agencyWiseCollectionDetails.add(agencyWiseDt);
    }

    public List<AgencyWiseCollectionSearch> buildAgencyWiseCollectionSearch(String[] hoardingList) {
        ArrayList<AgencyWiseCollectionSearch> permitDetails = new ArrayList<AgencyWiseCollectionSearch>();
        AgencyWiseCollectionSearch agencyWiseCollectionSearchResult = null;
        for (String hoardingId : hoardingList) {
            AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(hoardingId.trim()));
            if (!permitDetails.contains((Object)advertisementPermitDetail)) {
                agencyWiseCollectionSearchResult = new AgencyWiseCollectionSearch();
            } else {
                for (AgencyWiseCollectionSearch result : permitDetails) {
                    if (!result.getAdvertisementPermitId().equals(advertisementPermitDetail.getId())) continue;
                    agencyWiseCollectionSearchResult = result;
                }
            }
            Map<String, BigDecimal> demandWiseFeeDetail = this.advertisementDemandService.checkPedingAmountByDemand(advertisementPermitDetail);
            if (demandWiseFeeDetail.get("PENALTYAMOUNT").compareTo(BigDecimal.ZERO) <= 0 && demandWiseFeeDetail.get("PENDINGDEMANDAMOUNT").compareTo(BigDecimal.ZERO) <= 0) continue;
            agencyWiseCollectionSearchResult.setAdvertisementNumber(advertisementPermitDetail.getAdvertisement().getAdvertisementNumber());
            agencyWiseCollectionSearchResult.setAdvertisementPermitId(advertisementPermitDetail.getId());
            agencyWiseCollectionSearchResult.setAgencyName(advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getName() : " ");
            agencyWiseCollectionSearchResult.setApplicationNumber(advertisementPermitDetail.getApplicationNumber());
            agencyWiseCollectionSearchResult.setPenaltyAmount(demandWiseFeeDetail.get("PENALTYAMOUNT"));
            agencyWiseCollectionSearchResult.setPendingDemandAmount(demandWiseFeeDetail.get("PENDINGDEMANDAMOUNT"));
            permitDetails.add(agencyWiseCollectionSearchResult);
        }
        return permitDetails;
    }
}

