/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.HoardingAgencyWiseSearch;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.exception.HoardingValidationError;
import org.egov.adtax.repository.AdvertisementPermitDetailRepository;
import org.egov.adtax.search.contract.HoardingSearch;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementPermitDetailUpdateIndexService;
import org.egov.adtax.utils.AdTaxNumberGenerator;
import org.egov.adtax.workflow.AdtaxWorkflowCustomDefaultImpl;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.utils.StringUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementPermitDetailService {
    @Autowired
    private AdvertisementPermitDetailRepository advertisementPermitDetailRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    protected CollectionIntegrationService collectionIntegrationService;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    @Qualifier(value="adtaxWorkflowCustomDefaultImpl")
    private AdtaxWorkflowCustomDefaultImpl adtaxWorkflowCustomDefaultImpl;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private AdTaxNumberGenerator adTaxNumberGenerator;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private AdvertisementPermitDetailUpdateIndexService advertisementPermitDetailUpdateIndexService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public AdvertisementPermitDetail createAdvertisementPermitDetail(AdvertisementPermitDetail advertisementPermitDetail, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (advertisementPermitDetail != null && advertisementPermitDetail.getId() == null) {
            advertisementPermitDetail.getAdvertisement().setDemandId(this.advertisementDemandService.createDemand(advertisementPermitDetail));
        }
        this.roundOfAllTaxAmount(advertisementPermitDetail);
        if (advertisementPermitDetail.getApplicationNumber() == null) {
            advertisementPermitDetail.setApplicationNumber(this.adTaxNumberGenerator.generateApplicationNumber());
        }
        if (advertisementPermitDetail.getAdvertisement().getAdvertisementNumber() == null) {
            advertisementPermitDetail.getAdvertisement().setAdvertisementNumber(this.adTaxNumberGenerator.generateAdvertisementNumber());
        }
        if (advertisementPermitDetail.getAdvertisement().getLegacy().booleanValue() && advertisementPermitDetail.getPermissionNumber() == null) {
            advertisementPermitDetail.setPermissionNumber(this.adTaxNumberGenerator.generatePermitNumber());
        }
        this.advertisementPermitDetailRepository.save((Object)advertisementPermitDetail);
        if (approvalPosition != null && approvalPosition > 0L && additionalRule != null && StringUtils.isNotEmpty((String)workFlowAction)) {
            this.adtaxWorkflowCustomDefaultImpl.createCommonWorkflowTransition(advertisementPermitDetail, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        this.advertisementPermitDetailUpdateIndexService.updateAdvertisementPermitDetailIndexes(advertisementPermitDetail);
        return advertisementPermitDetail;
    }

    @Transactional
    public AdvertisementPermitDetail updateAdvertisementPermitDetailForLegacy(AdvertisementPermitDetail advertisementPermitDetail) throws HoardingValidationError {
        this.advertisementDemandService.updateDemandForLegacyEntry(advertisementPermitDetail, advertisementPermitDetail.getAdvertisement().getDemandId());
        this.roundOfAllTaxAmount(advertisementPermitDetail);
        this.advertisementPermitDetailRepository.save((Object)advertisementPermitDetail);
        this.advertisementPermitDetailUpdateIndexService.updateAdvertisementPermitDetailIndexes(advertisementPermitDetail);
        return advertisementPermitDetail;
    }

    @Transactional
    public AdvertisementPermitDetail updateAdvertisementPermitDetail(AdvertisementPermitDetail advertisementPermitDetail) throws HoardingValidationError {
        this.advertisementPermitDetailRepository.save((Object)advertisementPermitDetail);
        this.advertisementPermitDetailUpdateIndexService.updateAdvertisementPermitDetailIndexes(advertisementPermitDetail);
        return advertisementPermitDetail;
    }

    @Transactional
    public AdvertisementPermitDetail updateAdvertisementPermitDetail(AdvertisementPermitDetail advertisementPermitDetail, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) throws HoardingValidationError {
        boolean anyDemandPendingForCollection = this.advertisementDemandService.anyDemandPendingForCollection(advertisementPermitDetail);
        if (anyDemandPendingForCollection && advertisementPermitDetail.getPreviousapplicationid() == null) {
            this.advertisementDemandService.updateDemand(advertisementPermitDetail, advertisementPermitDetail.getAdvertisement().getDemandId());
        }
        this.roundOfAllTaxAmount(advertisementPermitDetail);
        this.advertisementPermitDetailRepository.save((Object)advertisementPermitDetail);
        if (approvalPosition != null && additionalRule != null && StringUtils.isNotEmpty((String)workFlowAction)) {
            this.adtaxWorkflowCustomDefaultImpl.createCommonWorkflowTransition(advertisementPermitDetail, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        this.advertisementPermitDetailUpdateIndexService.updateAdvertisementPermitDetailIndexes(advertisementPermitDetail);
        return advertisementPermitDetail;
    }

    private void roundOfAllTaxAmount(AdvertisementPermitDetail advertisementPermitDetail) {
        if (advertisementPermitDetail.getEncroachmentFee() != null) {
            advertisementPermitDetail.setEncroachmentFee(advertisementPermitDetail.getEncroachmentFee().setScale(2, 4));
        }
        if (advertisementPermitDetail.getTaxAmount() != null) {
            advertisementPermitDetail.setTaxAmount(advertisementPermitDetail.getTaxAmount().setScale(2, 4));
        }
        if (advertisementPermitDetail.getAdvertisement().getPendingTax() != null) {
            advertisementPermitDetail.getAdvertisement().setPendingTax(advertisementPermitDetail.getAdvertisement().getPendingTax().setScale(2, 4));
        }
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public AdvertisementPermitDetail getAdvertisementPermitDetailsByApplicationNumber(String applicationNumber) {
        return this.advertisementPermitDetailRepository.findByApplicationNumber(applicationNumber);
    }

    public AdvertisementPermitDetail findBy(Long advPermitId) {
        return (AdvertisementPermitDetail)((Object)this.advertisementPermitDetailRepository.findOne(advPermitId));
    }

    public EgwStatus getStatusByModuleAndCode(String code) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode("ADVERTISEMENT", code);
    }

    public List<HoardingSearch> getAdvertisementSearchResult(AdvertisementPermitDetail advPermitDetail, String searchType) {
        List advPermitDtl = this.advertisementPermitDetailRepository.searchAdvertisementPermitDetailBySearchParams(advPermitDetail);
        HashMap<String, HoardingSearch> agencyWiseHoardingList = new HashMap<String, HoardingSearch>();
        ArrayList<HoardingSearch> hoardingSearchResults = new ArrayList<HoardingSearch>();
        advPermitDtl.forEach(result -> {
            HoardingSearch hoardingSearchResult = new HoardingSearch();
            hoardingSearchResult.setAdvertisementNumber(result.getAdvertisement().getAdvertisementNumber());
            hoardingSearchResult.setApplicationNumber(result.getApplicationNumber());
            hoardingSearchResult.setApplicationFromDate(result.getApplicationDate());
            hoardingSearchResult.setAgencyName(result.getAgency() != null ? result.getAgency().getName() : "");
            hoardingSearchResult.setStatus(result.getAdvertisement().getStatus());
            hoardingSearchResult.setPermitStatus(result.getStatus().getCode());
            hoardingSearchResult.setPermissionNumber(result.getPermissionNumber());
            hoardingSearchResult.setId(result.getId());
            hoardingSearchResult.setLegacy(result.getAdvertisement().getLegacy());
            hoardingSearchResult.setCategoryName(result.getAdvertisement().getCategory().getName());
            hoardingSearchResult.setSubCategoryName(result.getAdvertisement().getSubCategory().getDescription());
            hoardingSearchResult.setOwnerDetail(result.getOwnerDetail() != null ? result.getOwnerDetail() : "");
            if (result.getAdvertisement().getDemandId() != null) {
                hoardingSearchResult.setFinancialYear(result.getAdvertisement().getDemandId().getEgInstallmentMaster().getDescription());
                if (searchType != null && searchType.equalsIgnoreCase("agency")) {
                    if (result.getAgency() != null) {
                        Map<String, BigDecimal> demandWiseFeeDetail = this.advertisementDemandService.checkPedingAmountByDemand((AdvertisementPermitDetail)((Object)result));
                        HoardingSearch hoardingSearchObj = (HoardingSearch)agencyWiseHoardingList.get(result.getAgency().getName());
                        if (hoardingSearchObj == null) {
                            hoardingSearchResult.setPenaltyAmount(demandWiseFeeDetail.get("PENALTYAMOUNT"));
                            hoardingSearchResult.setPendingDemandAmount(demandWiseFeeDetail.get("PENDINGDEMANDAMOUNT"));
                            hoardingSearchResult.setTotalAmount(hoardingSearchResult.getPendingDemandAmount().add(hoardingSearchResult.getPenaltyAmount()));
                            hoardingSearchResult.setTotalHoardingInAgency(1);
                            hoardingSearchResult.setHordingIdsSearchedByAgency(result.getId().toString());
                            agencyWiseHoardingList.put(result.getAgency().getName(), hoardingSearchResult);
                        } else {
                            StringBuffer hoardingIds = new StringBuffer();
                            hoardingSearchObj.setPenaltyAmount(hoardingSearchObj.getPenaltyAmount().add(demandWiseFeeDetail.get("PENALTYAMOUNT")));
                            hoardingSearchObj.setPendingDemandAmount(hoardingSearchObj.getPendingDemandAmount().add(demandWiseFeeDetail.get("PENDINGDEMANDAMOUNT")));
                            hoardingSearchObj.setTotalAmount(hoardingSearchObj.getPendingDemandAmount().add(hoardingSearchObj.getPenaltyAmount()));
                            hoardingSearchObj.setTotalHoardingInAgency(hoardingSearchObj.getTotalHoardingInAgency() + 1);
                            hoardingIds.append(hoardingSearchObj.getHordingIdsSearchedByAgency()).append("~").append(result.getId());
                            hoardingSearchObj.setHordingIdsSearchedByAgency(hoardingIds.toString());
                            agencyWiseHoardingList.put(result.getAgency().getName(), hoardingSearchObj);
                        }
                    }
                } else {
                    Map<String, BigDecimal> demandWiseFeeDetail = this.advertisementDemandService.checkPedingAmountByDemand((AdvertisementPermitDetail)((Object)result));
                    hoardingSearchResult.setPenaltyAmount(demandWiseFeeDetail.get("PENALTYAMOUNT"));
                    hoardingSearchResult.setPendingDemandAmount(demandWiseFeeDetail.get("PENDINGDEMANDAMOUNT"));
                    hoardingSearchResult.setTotalAmount(hoardingSearchResult.getPendingDemandAmount().add(hoardingSearchResult.getPenaltyAmount()));
                    hoardingSearchResults.add(hoardingSearchResult);
                }
            }
        });
        if (agencyWiseHoardingList.size() > 0) {
            ArrayList<HoardingSearch> agencyWiseFinalHoardingList = new ArrayList<HoardingSearch>();
            agencyWiseHoardingList.forEach((key, value) -> agencyWiseFinalHoardingList.add((HoardingSearch)value));
            return agencyWiseFinalHoardingList;
        }
        return hoardingSearchResults;
    }

    public List<HoardingSearch> getAdvertisementSearchResult(HoardingSearch hoardingSearch, String hoardingType) {
        List advPermitDtl = this.advertisementPermitDetailRepository.searchAdvertisementPermitDetailLike(hoardingSearch, hoardingType);
        ArrayList<HoardingSearch> hoardingSearchResults = new ArrayList<HoardingSearch>();
        advPermitDtl.forEach(result -> {
            HoardingSearch hoardingSearchResult = new HoardingSearch();
            hoardingSearchResult.setAdvertisementNumber(result.getAdvertisement().getAdvertisementNumber());
            hoardingSearchResult.setApplicationNumber(result.getApplicationNumber());
            hoardingSearchResult.setApplicationFromDate(result.getApplicationDate());
            hoardingSearchResult.setAgencyName(result.getAgency() != null ? result.getAgency().getName() : "");
            hoardingSearchResult.setStatus(result.getAdvertisement().getStatus());
            hoardingSearchResult.setHordingIdsSearchedByAgency(result.getId().toString());
            hoardingSearchResult.setId(result.getId());
            hoardingSearchResults.add(hoardingSearchResult);
        });
        return hoardingSearchResults;
    }

    public Assignment getWfInitiator(AdvertisementPermitDetail advertisementPermitDetail) {
        return this.assignmentService.getPrimaryAssignmentForUser(advertisementPermitDetail.getCreatedBy().getId());
    }

    public void updateStateTransition(AdvertisementPermitDetail advertisementPermitDetail, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (approvalPosition != null && additionalRule != null && StringUtils.isNotEmpty((String)workFlowAction)) {
            this.adtaxWorkflowCustomDefaultImpl.createCommonWorkflowTransition(advertisementPermitDetail, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        this.advertisementPermitDetailUpdateIndexService.updateAdvertisementPermitDetailIndexes(advertisementPermitDetail);
    }

    public AdvertisementPermitDetail findByApplicationNumber(String applicationNumber) {
        return this.advertisementPermitDetailRepository.findByApplicationNumber(applicationNumber);
    }

    @Transactional
    public AdvertisementPermitDetail renewal(AdvertisementPermitDetail advertisementPermitDetail, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        this.roundOfAllTaxAmount(advertisementPermitDetail);
        this.advertisementPermitDetailRepository.save((Object)advertisementPermitDetail);
        if (approvalPosition != null && approvalPosition > 0L && additionalRule != null && StringUtils.isNotEmpty((String)workFlowAction)) {
            this.adtaxWorkflowCustomDefaultImpl.createCommonWorkflowTransition(advertisementPermitDetail, approvalPosition, approvalComent, additionalRule, workFlowAction);
        }
        this.advertisementPermitDetailUpdateIndexService.updateAdvertisementPermitDetailIndexes(advertisementPermitDetail);
        return advertisementPermitDetail;
    }

    public List<HoardingSearch> getRenewalAdvertisementSearchResult(AdvertisementPermitDetail advPermitDetail, String searchType) {
        List advPermitDtl = this.advertisementPermitDetailRepository.searchActiveAdvertisementPermitDetailBySearchParams(advPermitDetail);
        ArrayList<HoardingSearch> hoardingSearchResults = new ArrayList<HoardingSearch>();
        advPermitDtl.forEach(result -> {
            HoardingSearch hoardingSearchResult = new HoardingSearch();
            hoardingSearchResult.setAdvertisementNumber(result.getAdvertisement().getAdvertisementNumber());
            hoardingSearchResult.setApplicationNumber(result.getApplicationNumber());
            hoardingSearchResult.setApplicationFromDate(result.getApplicationDate());
            hoardingSearchResult.setAgencyName(result.getAgency() != null ? result.getAgency().getName() : "");
            hoardingSearchResult.setStatus(result.getAdvertisement().getStatus());
            hoardingSearchResult.setPermitStatus(result.getStatus().getCode());
            hoardingSearchResult.setPermissionNumber(result.getPermissionNumber());
            hoardingSearchResult.setId(result.getId());
            hoardingSearchResult.setCategoryName(result.getAdvertisement().getCategory().getName());
            hoardingSearchResult.setSubCategoryName(result.getAdvertisement().getSubCategory().getDescription());
            hoardingSearchResult.setOwnerDetail(result.getOwnerDetail() != null ? result.getOwnerDetail() : "");
            if (result.getAdvertisement().getDemandId() != null) {
                hoardingSearchResult.setFinancialYear(result.getAdvertisement().getDemandId().getEgInstallmentMaster().getDescription());
            }
            hoardingSearchResults.add(hoardingSearchResult);
        });
        return hoardingSearchResults;
    }

    public AdvertisementPermitDetail findById(Long id) {
        return (AdvertisementPermitDetail)((Object)this.advertisementPermitDetailRepository.findOne(id));
    }

    public List<HoardingSearch> getActiveAdvertisementSearchResult(AdvertisementPermitDetail advPermitDetail, String searchType) {
        List advPermitDtl = this.advertisementPermitDetailRepository.searchActiveAdvertisementPermitDetailBySearchParams(advPermitDetail);
        HashMap<String, HoardingSearch> agencyWiseHoardingList = new HashMap<String, HoardingSearch>();
        ArrayList<HoardingSearch> hoardingSearchResults = new ArrayList<HoardingSearch>();
        advPermitDtl.forEach(result -> {
            HoardingSearch hoardingSearchResult = new HoardingSearch();
            hoardingSearchResult.setAdvertisementNumber(result.getAdvertisement().getAdvertisementNumber());
            hoardingSearchResult.setApplicationNumber(result.getApplicationNumber());
            hoardingSearchResult.setApplicationFromDate(result.getApplicationDate());
            hoardingSearchResult.setAgencyName(result.getAgency() != null ? result.getAgency().getName() : "");
            hoardingSearchResult.setStatus(result.getAdvertisement().getStatus());
            hoardingSearchResult.setPermitStatus(result.getStatus().getCode());
            hoardingSearchResult.setPermissionNumber(result.getPermissionNumber());
            hoardingSearchResult.setId(result.getId());
            hoardingSearchResult.setCategoryName(result.getAdvertisement().getCategory().getName());
            hoardingSearchResult.setSubCategoryName(result.getAdvertisement().getSubCategory().getDescription());
            hoardingSearchResult.setOwnerDetail(result.getOwnerDetail() != null ? result.getOwnerDetail() : "");
            if (result.getAdvertisement().getDemandId() != null) {
                hoardingSearchResult.setFinancialYear(result.getAdvertisement().getDemandId().getEgInstallmentMaster().getDescription());
                if (searchType != null && searchType.equalsIgnoreCase("agency") && result.getAgency() != null) {
                    Map<String, BigDecimal> demandWiseFeeDetail = this.advertisementDemandService.checkPedingAmountByDemand((AdvertisementPermitDetail)((Object)result));
                    HoardingSearch hoardingSearchObj = (HoardingSearch)agencyWiseHoardingList.get(result.getAgency().getName());
                    if (hoardingSearchObj == null) {
                        hoardingSearchResult.setPenaltyAmount(demandWiseFeeDetail.get("PENALTYAMOUNT"));
                        hoardingSearchResult.setPendingDemandAmount(demandWiseFeeDetail.get("PENDINGDEMANDAMOUNT"));
                        hoardingSearchResult.setTotalHoardingInAgency(1);
                        hoardingSearchResult.setHordingIdsSearchedByAgency(result.getId().toString());
                        agencyWiseHoardingList.put(result.getAgency().getName(), hoardingSearchResult);
                    } else {
                        StringBuffer hoardingIds = new StringBuffer();
                        hoardingSearchObj.setPenaltyAmount(hoardingSearchObj.getPenaltyAmount().add(demandWiseFeeDetail.get("PENALTYAMOUNT")));
                        hoardingSearchObj.setPendingDemandAmount(hoardingSearchObj.getPendingDemandAmount().add(demandWiseFeeDetail.get("PENDINGDEMANDAMOUNT")));
                        hoardingSearchObj.setTotalHoardingInAgency(hoardingSearchObj.getTotalHoardingInAgency() + 1);
                        hoardingIds.append(hoardingSearchObj.getHordingIdsSearchedByAgency()).append("~").append(result.getId());
                        hoardingSearchObj.setHordingIdsSearchedByAgency(hoardingIds.toString());
                        agencyWiseHoardingList.put(result.getAgency().getName(), hoardingSearchObj);
                    }
                } else {
                    Map<String, BigDecimal> demandWiseFeeDetail = this.advertisementDemandService.checkPedingAmountByDemand((AdvertisementPermitDetail)((Object)result));
                    hoardingSearchResult.setPenaltyAmount(demandWiseFeeDetail.get("PENALTYAMOUNT"));
                    hoardingSearchResult.setPendingDemandAmount(demandWiseFeeDetail.get("PENDINGDEMANDAMOUNT"));
                    hoardingSearchResults.add(hoardingSearchResult);
                }
            }
        });
        if (agencyWiseHoardingList.size() > 0) {
            ArrayList<HoardingSearch> agencyWiseFinalHoardingList = new ArrayList<HoardingSearch>();
            agencyWiseHoardingList.forEach((key, value) -> agencyWiseFinalHoardingList.add((HoardingSearch)value));
            return agencyWiseFinalHoardingList;
        }
        return hoardingSearchResults;
    }

    public List<HoardingAgencyWiseSearch> getAgencyWiseAdvertisementSearchResult(AdvertisementPermitDetail advPermitDetail) {
        List advPermitDtl = this.advertisementPermitDetailRepository.searchAdvertisementPermitDetailBySearchParams(advPermitDetail);
        HashMap<String, HoardingAgencyWiseSearch> agencyWiseHoardingMap = new HashMap<String, HoardingAgencyWiseSearch>();
        ArrayList<HoardingAgencyWiseSearch> agencyWiseFinalHoardingList = new ArrayList<HoardingAgencyWiseSearch>();
        advPermitDtl.forEach(result -> {
            if (result.getAgency() != null) {
                HoardingAgencyWiseSearch hoardingSearchResult = new HoardingAgencyWiseSearch();
                hoardingSearchResult.setAdvertisementNumber(result.getAdvertisement().getAdvertisementNumber());
                hoardingSearchResult.setAgencyName(result.getAgency() != null ? result.getAgency().getName() : "");
                hoardingSearchResult.setCategoryName(result.getAdvertisement().getCategory().getName());
                hoardingSearchResult.setSubCategoryName(result.getAdvertisement().getSubCategory().getDescription());
                BigDecimal totalDemandAmount = BigDecimal.ZERO;
                BigDecimal totalCollectedAmount = BigDecimal.ZERO;
                BigDecimal totalPending = BigDecimal.ZERO;
                BigDecimal totalPenalty = BigDecimal.ZERO;
                Map<String, BigDecimal> demandWiseFeeDetail = this.advertisementDemandService.checkPendingAmountByDemand((AdvertisementPermitDetail)((Object)result));
                totalDemandAmount = totalDemandAmount.add(demandWiseFeeDetail.get("Demand"));
                totalCollectedAmount = totalCollectedAmount.add(demandWiseFeeDetail.get(" Total Collection"));
                totalPending = totalPending.add(demandWiseFeeDetail.get("PENDINGDEMANDAMOUNT"));
                totalPenalty = totalPenalty.add(demandWiseFeeDetail.get("PENALTYAMOUNT"));
                HoardingAgencyWiseSearch hoardingSearchObj = (HoardingAgencyWiseSearch)agencyWiseHoardingMap.get(result.getAgency().getName());
                if (hoardingSearchObj == null) {
                    hoardingSearchResult.setAgency(result.getAgency().getId());
                    hoardingSearchResult.setTotalDemand(totalDemandAmount);
                    hoardingSearchResult.setCollectedAmount(totalCollectedAmount);
                    hoardingSearchResult.setPendingAmount(totalDemandAmount.subtract(totalCollectedAmount));
                    hoardingSearchResult.setPenaltyAmount(totalPenalty);
                    hoardingSearchResult.setTotalHoardingInAgency(1);
                    hoardingSearchResult.setHordingIdsSearchedByAgency(result.getId().toString());
                    agencyWiseHoardingMap.put(result.getAgency().getName(), hoardingSearchResult);
                } else {
                    hoardingSearchResult.setAgency(result.getAgency().getId());
                    hoardingSearchResult.setTotalDemand(((HoardingAgencyWiseSearch)agencyWiseHoardingMap.get(result.getAgency().getName())).getTotalDemand().add(totalDemandAmount));
                    hoardingSearchResult.setCollectedAmount(((HoardingAgencyWiseSearch)agencyWiseHoardingMap.get(result.getAgency().getName())).getCollectedAmount().add(totalCollectedAmount));
                    hoardingSearchResult.setPendingAmount(((HoardingAgencyWiseSearch)agencyWiseHoardingMap.get(result.getAgency().getName())).getPendingAmount().add(totalPending));
                    hoardingSearchResult.setPenaltyAmount(((HoardingAgencyWiseSearch)agencyWiseHoardingMap.get(result.getAgency().getName())).getPenaltyAmount().add(totalPenalty));
                    hoardingSearchResult.setTotalHoardingInAgency(hoardingSearchObj.getTotalHoardingInAgency() + 1);
                    agencyWiseHoardingMap.put(result.getAgency().getName(), hoardingSearchResult);
                }
            }
        });
        if (agencyWiseHoardingMap.size() > 0) {
            agencyWiseHoardingMap.forEach((key, value) -> agencyWiseFinalHoardingList.add((HoardingAgencyWiseSearch)value));
        }
        return agencyWiseFinalHoardingList;
    }

    public List<AdvertisementPermitDetail> getAdvertisementPermitDetailBySearchParam(Long agencyId, Long category, Long subcategory, Long zone, Long ward) {
        StringBuilder queryString = new StringBuilder();
        queryString.append(" from AdvertisementPermitDetail B where B.agency.id=:agencyId  and B.isActive=true and B.advertisement.status=:advertismentStatus");
        if (category != null) {
            queryString.append(" and B.advertisement.category.id =:category");
        }
        if (subcategory != null) {
            queryString.append("and B.advertisement.subCategory.id =:subcategory");
        }
        if (zone != null) {
            queryString.append("and B.advertisement.locality.id =:zone");
        }
        if (ward != null) {
            queryString.append("and B.advertisement.ward.id =:ward");
        }
        Query query = ((Session)this.entityManager.unwrap(Session.class)).createQuery(queryString.toString());
        query.setParameter("agencyId", (Object)agencyId);
        query.setParameter("advertismentStatus", (Object)AdvertisementStatus.ACTIVE);
        if (category != null) {
            query.setParameter("category", (Object)category);
        }
        if (subcategory != null) {
            query.setParameter("subCategory", (Object)subcategory);
        }
        if (zone != null) {
            query.setParameter("zone", (Object)zone);
        }
        if (ward != null) {
            query.setParameter("ward", (Object)ward);
        }
        return query.list();
    }
}

