/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.entity;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.egov.adtax.entity.HoardingDocumentType;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.hibernate.search.annotations.DocumentId;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="egadtax_hoardingdocument")
@SequenceGenerator(name="SEQ_EGADTAX_DOCUMENT", sequenceName="SEQ_EGADTAX_DOCUMENT", allocationSize=1)
public class HoardingDocument
extends AbstractAuditable {
    private static final long serialVersionUID = 1938612090916339332L;
    public static final String SEQ_HOARDING_DOCUMENT = "SEQ_EGADTAX_DOCUMENT";
    @Id
    @GeneratedValue(generator="SEQ_EGADTAX_DOCUMENT", strategy=GenerationType.SEQUENCE)
    @DocumentId
    private Long id;
    @ManyToOne
    @JoinColumn(name="doctype")
    private HoardingDocumentType doctype;
    private String description;
    @Temporal(value=TemporalType.DATE)
    private Date docDate;
    private boolean enclosed;
    @OneToMany(fetch=FetchType.LAZY, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinTable(name="EGADTAX_DOCUMENT_FILES", joinColumns={@JoinColumn(name="document")}, inverseJoinColumns={@JoinColumn(name="filestore")})
    private Set<FileStoreMapper> files = new HashSet<FileStoreMapper>();
    @Transient
    private MultipartFile[] attachments;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public HoardingDocumentType getDoctype() {
        return this.doctype;
    }

    public void setDoctype(HoardingDocumentType doctype) {
        this.doctype = doctype;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDocDate() {
        return this.docDate;
    }

    public void setDocDate(Date docDate) {
        this.docDate = docDate;
    }

    public boolean isEnclosed() {
        return this.enclosed;
    }

    public void setEnclosed(boolean enclosed) {
        this.enclosed = enclosed;
    }

    public Set<FileStoreMapper> getFiles() {
        return this.files;
    }

    public void setFiles(Set<FileStoreMapper> files) {
        this.files = files;
    }

    public void addFiles(Set<FileStoreMapper> files) {
        this.files.addAll(files);
    }

    public MultipartFile[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(MultipartFile[] attachments) {
        this.attachments = attachments;
    }
}

