/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.penalty;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.egov.adtax.entity.AdvertisementRatesDetails;
import org.egov.adtax.service.AdvertisementRateService;
import org.egov.adtax.service.penalty.AdvertisementTaxCalculator;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementTaxCalculatorImpl
implements AdvertisementTaxCalculator {
    @Autowired
    protected AdvertisementRateService advertisementRateService;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    @Override
    public Double calculateTaxAmount(Long unitOfMeasureId, Double measurement, Long subCategoryId, Long rateClassId) {
        List calculateSorByUnit;
        AdvertisementRatesDetails rate = null;
        rate = this.advertisementRateService.getRatesBySubcategoryUomClassAndMeasurementByFinancialYearInDecendingOrder(subCategoryId, unitOfMeasureId, rateClassId, measurement);
        if (rate != null && !(calculateSorByUnit = this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "Calculate SOR By Unit")).isEmpty()) {
            if (((AppConfigValues)calculateSorByUnit.get(0)).getValue().equalsIgnoreCase("NO")) {
                return BigDecimal.valueOf(rate.getAmount()).multiply(BigDecimal.valueOf(measurement)).setScale(2, 4).doubleValue();
            }
            if (((AppConfigValues)calculateSorByUnit.get(0)).getValue().equalsIgnoreCase("YES")) {
                BigDecimal unitRate;
                BigDecimal bigDecimal = unitRate = rate.getAdvertisementRate().getUnitrate() != null ? BigDecimal.valueOf(rate.getAdvertisementRate().getUnitrate()) : BigDecimal.ZERO;
                if (unitRate != BigDecimal.valueOf(0L)) {
                    return BigDecimal.valueOf(rate.getAmount()).multiply(BigDecimal.valueOf(measurement).divide(unitRate, 4, RoundingMode.HALF_UP).setScale(0, RoundingMode.UP)).setScale(4, 4).doubleValue();
                }
                return 0.0;
            }
        }
        return 0.0;
    }
}

