/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.collection;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.collection.AdvertisementBillable;
import org.egov.adtax.service.penalty.AdvertisementPenaltyCalculator;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.commons.Installment;
import org.egov.demand.interfaces.BillServiceInterface;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementBillServiceImpl
extends BillServiceInterface {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    private AdvertisementPenaltyCalculator advertisementPenaltyCalculator;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<EgBillDetails> getBilldetails(Billable billObj) {
        ArrayList<EgBillDetails> billDetailList = new ArrayList<EgBillDetails>();
        int orderNo = 1;
        AdvertisementBillable advBillable = (AdvertisementBillable)billObj;
        EgDemand dmd = advBillable.getCurrentDemand();
        ArrayList details = new ArrayList(dmd.getEgDemandDetails());
        if (!details.isEmpty()) {
            Collections.sort(details, (c1, c2) -> c1.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().compareTo(c2.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()));
        }
        for (EgDemandDetails demandDetail : details) {
            if (demandDetail.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal creaditAmt = BigDecimal.ZERO;
            creaditAmt = demandDetail.getAmount().subtract(demandDetail.getAmtCollected());
            if (creaditAmt.compareTo(BigDecimal.ZERO) <= 0 || "Penalty".equalsIgnoreCase(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster())) continue;
            EgBillDetails billdetail = this.createBillDetailObject(orderNo, BigDecimal.ZERO, creaditAmt, demandDetail.getEgDemandReason().getGlcodeId().getGlcode(), this.getReceiptDetailDescription(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster() + " " + "Collection", demandDetail.getEgDemandReason().getEgInstallmentMaster()));
            ++orderNo;
            billDetailList.add(billdetail);
        }
        Map<Installment, BigDecimal> penaltyReasons = this.advertisementPenaltyCalculator.getPenaltyByInstallment(advBillable.getAdvertisement().getActiveAdvertisementPermit());
        if (penaltyReasons != null && penaltyReasons.size() > 0) {
            BigDecimal penaltyAmount = BigDecimal.ZERO;
            for (Map.Entry<Installment, BigDecimal> penaltyReason : penaltyReasons.entrySet()) {
                penaltyAmount = penaltyReason.getValue();
                if (penaltyAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                EgDemandReason pendingTaxReason = this.advertisementDemandService.getDemandReasonByCodeAndInstallment("Penalty", penaltyReason.getKey());
                List<EgDemandDetails> penaltyDmtDtails = this.advertisementDemandService.getDemandDetailByPassingDemandDemandReason(dmd, pendingTaxReason);
                if (penaltyDmtDtails != null && penaltyDmtDtails.size() > 0) {
                    EgDemandDetails penaltyExistingDemandDetail = penaltyDmtDtails.get(0);
                    BigDecimal creaditAmt = penaltyExistingDemandDetail.getAmount().subtract(penaltyExistingDemandDetail.getAmtCollected());
                    EgBillDetails billdetail = this.createBillDetailObject(orderNo, BigDecimal.ZERO, creaditAmt.add(penaltyAmount), penaltyExistingDemandDetail.getEgDemandReason().getGlcodeId().getGlcode(), this.getReceiptDetailDescription(penaltyExistingDemandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster() + " " + "Collection", penaltyExistingDemandDetail.getEgDemandReason().getEgInstallmentMaster()));
                    ++orderNo;
                    billDetailList.add(billdetail);
                    continue;
                }
                EgBillDetails billdetail = this.createBillDetailObject(orderNo, BigDecimal.ZERO, penaltyAmount, pendingTaxReason.getGlcodeId().getGlcode(), this.getReceiptDetailDescription(pendingTaxReason.getEgDemandReasonMaster().getReasonMaster() + " " + "Collection", pendingTaxReason.getEgInstallmentMaster()));
                ++orderNo;
                billDetailList.add(billdetail);
            }
        }
        return billDetailList;
    }

    private String getReceiptDetailDescription(String reasonType, Installment instlment) {
        return reasonType + (instlment != null ? " " + instlment.getDescription() : "");
    }

    private EgBillDetails createBillDetailObject(int orderNo, BigDecimal debitAmount, BigDecimal creditAmount, String glCodeForDemandDetail, String description) {
        EgBillDetails billdetail = new EgBillDetails();
        billdetail.setFunctionCode("9300");
        billdetail.setOrderNo(Integer.valueOf(orderNo));
        billdetail.setCreateDate(new Date());
        billdetail.setModifiedDate(new Date());
        billdetail.setCrAmount(creditAmount);
        billdetail.setDrAmount(debitAmount);
        billdetail.setGlcode(glCodeForDemandDetail);
        billdetail.setDescription(description);
        billdetail.setAdditionalFlag(Integer.valueOf(1));
        billdetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
        return billdetail;
    }

    public void cancelBill() {
    }

    public String getBillXML(Billable billObj) {
        String collectXML;
        try {
            collectXML = URLEncoder.encode(super.getBillXML(billObj), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return collectXML;
    }
}

