/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.repository.AdvertisementRepository;
import org.egov.adtax.search.contract.HoardingDcbReport;
import org.egov.adtax.service.penalty.AdvertisementPenaltyCalculator;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementReportService {
    @Autowired
    private AdvertisementRepository advertisementRepository;
    @Autowired
    private AdvertisementPenaltyCalculator advtPenaltyCalculator;
    @Autowired
    protected CollectionIntegrationService collectionIntegrationService;

    public List<HoardingDcbReport> getHoardingWiseDCBResult(Advertisement hoarding) {
        ArrayList<HoardingDcbReport> HoardingDcbReportResults = new ArrayList<HoardingDcbReport>();
        Map<Object, Object> penaltyAmountMap = new HashMap();
        if (hoarding != null && hoarding.getDemandId() != null) {
            penaltyAmountMap = this.advtPenaltyCalculator.getPenaltyByInstallment(hoarding.getActiveAdvertisementPermit());
            HashMap<String, HoardingDcbReport> hoardingwiseMap = new HashMap<String, HoardingDcbReport>();
            HoardingDcbReport hoardingReport = new HoardingDcbReport();
            for (EgDemandDetails demandDtl : hoarding.getDemandId().getEgDemandDetails()) {
                HoardingDcbReport hoardingDcbReportObj = (HoardingDcbReport)hoardingwiseMap.get(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription());
                if (hoardingDcbReportObj == null) {
                    hoardingReport = new HoardingDcbReport();
                    hoardingReport.setInstallmentYearDescription(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription());
                    if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Arrear_Adv_Tax")) {
                        hoardingReport.setArrearAmount(demandDtl.getAmount().setScale(2, 6));
                        hoardingReport.setCollectedArrearAmount(demandDtl.getAmtCollected().setScale(2, 6));
                    }
                    if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Advertisemnt_Tax") || demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Enchroachmnt_Fee")) {
                        hoardingReport.setDemandAmount(demandDtl.getAmount().setScale(2, 6));
                        hoardingReport.setCollectedDemandAmount(demandDtl.getAmtCollected().setScale(2, 6));
                    }
                    if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Penalty")) {
                        hoardingReport.setPenaltyAmount(demandDtl.getAmount().setScale(2, 6));
                        hoardingReport.setCollectedPenaltyAmount(demandDtl.getAmtCollected().setScale(2, 6));
                    }
                    hoardingwiseMap.put(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription(), hoardingReport);
                    continue;
                }
                hoardingReport = (HoardingDcbReport)hoardingwiseMap.get(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription());
                if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Arrear_Adv_Tax")) {
                    hoardingReport.setArrearAmount(hoardingReport.getArrearAmount().add(demandDtl.getAmount().setScale(2, 6)));
                    hoardingReport.setCollectedArrearAmount(hoardingReport.getCollectedArrearAmount().add(demandDtl.getAmtCollected().setScale(2, 6)));
                }
                if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Advertisemnt_Tax") || demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Enchroachmnt_Fee")) {
                    hoardingReport.setDemandAmount(hoardingReport.getDemandAmount().add(demandDtl.getAmount().setScale(2, 6)));
                    hoardingReport.setCollectedDemandAmount(hoardingReport.getCollectedDemandAmount().add(demandDtl.getAmtCollected().setScale(2, 6)));
                }
                if (demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Penalty")) {
                    hoardingReport.setPenaltyAmount(hoardingReport.getPenaltyAmount() != null ? hoardingReport.getPenaltyAmount().add(demandDtl.getAmount().setScale(2, 6)) : demandDtl.getAmount().setScale(2, 6));
                    hoardingReport.setCollectedPenaltyAmount(hoardingReport.getCollectedPenaltyAmount() != null ? hoardingReport.getCollectedPenaltyAmount().add(demandDtl.getAmtCollected().setScale(2, 6)) : demandDtl.getAmtCollected().setScale(2, 6));
                }
                hoardingwiseMap.put(demandDtl.getEgDemandReason().getEgInstallmentMaster().getDescription(), hoardingReport);
            }
            HashMap<Date, String> collectedReceiptMap = new HashMap<Date, String>();
            StringBuffer receiptNumber = new StringBuffer();
            for (EgDemandDetails egDemandDetails : hoarding.getDemandId().getEgDemandDetails()) {
                for (EgdmCollectedReceipt collRecpt : egDemandDetails.getEgdmCollectedReceipts()) {
                    if (collRecpt.isCancelled().booleanValue()) continue;
                    receiptNumber.append(collRecpt.getReceiptNumber()).append(" ");
                    collectedReceiptMap.put(collRecpt.getReceiptDate(), collRecpt.getReceiptNumber());
                }
            }
            hoardingReport.setCollectReceiptMap(collectedReceiptMap);
            for (Map.Entry entry : penaltyAmountMap.entrySet()) {
                if (!hoardingwiseMap.containsKey(((Installment)entry.getKey()).getDescription())) continue;
                ((HoardingDcbReport)hoardingwiseMap.get(((Installment)entry.getKey()).getDescription())).setPenaltyAmount(((HoardingDcbReport)hoardingwiseMap.get(((Installment)entry.getKey()).getDescription())).getPenaltyAmount().add((BigDecimal)entry.getValue()));
            }
            if (hoardingwiseMap.size() > 0) {
                hoardingwiseMap.forEach((key, value) -> HoardingDcbReportResults.add((HoardingDcbReport)value));
            }
        }
        return HoardingDcbReportResults;
    }

    public Advertisement findByAdvertisementNumber(String hoardingNumber) {
        return this.advertisementRepository.findByAdvertisementNumber(hoardingNumber);
    }

    public Advertisement findBy(Long hoardingId) {
        return (Advertisement)((Object)this.advertisementRepository.findOne(hoardingId));
    }

    public Advertisement getAdvertisementByDemand(EgDemand demand) {
        return this.advertisementRepository.findByDemandId(demand);
    }
}

