/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.es;

import java.math.BigDecimal;
import java.util.Map;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.es.AdvertisementIndex;
import org.egov.adtax.repository.es.AdvertisementIndexRepository;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.elasticsearch.common.geo.GeoPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementIndexService {
    @Autowired
    private CityService cityService;
    @Autowired
    private AdvertisementIndexRepository advertisementIndexRepository;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;

    public AdvertisementIndex createAdvertisementIndex(AdvertisementPermitDetail advertisementPermitDetailIndex) {
        AdvertisementIndex advertisementSearch = null;
        if (advertisementPermitDetailIndex.getStatus() != null && (advertisementPermitDetailIndex.getStatus().getCode().equalsIgnoreCase("APPROVED") || advertisementPermitDetailIndex.getStatus().getCode().equalsIgnoreCase("ADTAXAMTPAYMENTPAID") || advertisementPermitDetailIndex.getStatus().getCode().equalsIgnoreCase("ADTAXPERMITGENERATED") || advertisementPermitDetailIndex.getStatus().getCode().equalsIgnoreCase("CANCELLED"))) {
            advertisementSearch = this.createOrUpdateAdvIndex(advertisementPermitDetailIndex);
        }
        return advertisementSearch;
    }

    public AdvertisementIndex createOrUpdateAdvIndex(AdvertisementPermitDetail advertisementPermitDetail) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        AdvertisementIndex advertisementSearch = new AdvertisementIndex(advertisementPermitDetail.getAdvertisement().getAdvertisementNumber(), cityWebsite.getName(), cityWebsite.getCode(), advertisementPermitDetail.getCreatedDate(), cityWebsite.getDistrictName(), cityWebsite.getRegionName(), cityWebsite.getGrade());
        advertisementSearch.setId(cityWebsite.getCode().concat("-").concat(advertisementPermitDetail.getApplicationNumber()));
        advertisementSearch.setAddress(advertisementPermitDetail.getAdvertisement().getAddress() != null ? advertisementPermitDetail.getAdvertisement().getAddress() : "");
        advertisementSearch.setAdvertisementClass(advertisementPermitDetail.getAdvertisement().getRateClass().getDescription());
        advertisementSearch.setAdvertisementCreatedBy(advertisementPermitDetail.getAdvertisement().getCreatedBy().getName());
        advertisementSearch.setAdvertisement_duration(advertisementPermitDetail.getAdvertisementDuration().name());
        advertisementSearch.setAdvertisementNumber(advertisementPermitDetail.getAdvertisement().getAdvertisementNumber());
        advertisementSearch.setAdvertisement_status(advertisementPermitDetail.getAdvertisement().getStatus().name());
        advertisementSearch.setType(advertisementPermitDetail.getAdvertisement().getType().name());
        advertisementSearch.setAdvertiser(advertisementPermitDetail.getAdvertiser() != null ? advertisementPermitDetail.getAdvertiser() : "");
        advertisementSearch.setAdvertiserParticular(advertisementPermitDetail.getAdvertisementParticular() != null ? advertisementPermitDetail.getAdvertisementParticular() : "");
        advertisementSearch.setAgencyName(advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getName() : "");
        advertisementSearch.setApplicationDate(advertisementPermitDetail.getApplicationDate());
        advertisementSearch.setApplicationNumber(advertisementPermitDetail.getApplicationNumber());
        advertisementSearch.setBlock(advertisementPermitDetail.getAdvertisement().getBlock() != null ? advertisementPermitDetail.getAdvertisement().getBlock().getName() : "");
        advertisementSearch.setBreadth(advertisementPermitDetail.getBreadth() != null ? advertisementPermitDetail.getBreadth() : 0.0);
        advertisementSearch.setCategory(advertisementPermitDetail.getAdvertisement().getCategory().getName());
        advertisementSearch.setCreatedDate(advertisementPermitDetail.getAdvertisement().getCreatedDate());
        advertisementSearch.setElectionWard(advertisementPermitDetail.getAdvertisement().getElectionWard() != null ? advertisementPermitDetail.getAdvertisement().getElectionWard().getName() : "");
        advertisementSearch.setElectricityServiceNumber(advertisementPermitDetail.getAdvertisement().getElectricityServiceNumber() != null ? advertisementPermitDetail.getAdvertisement().getElectricityServiceNumber() : "");
        advertisementSearch.setEncroachmentFee(advertisementPermitDetail.getEncroachmentFee() != null ? advertisementPermitDetail.getEncroachmentFee() : BigDecimal.ZERO);
        advertisementSearch.setIslegacy(advertisementPermitDetail.getAdvertisement().getLegacy());
        advertisementSearch.setLength(advertisementPermitDetail.getLength());
        advertisementSearch.setLocality(advertisementPermitDetail.getAdvertisement().getLocality() != null ? advertisementPermitDetail.getAdvertisement().getLocality().getName() : "");
        advertisementSearch.setMeasurement(advertisementPermitDetail.getMeasurement());
        advertisementSearch.setMobileNumber(advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getMobileNumber() : "");
        advertisementSearch.setOwnerDetail(advertisementPermitDetail.getOwnerDetail() != null ? advertisementPermitDetail.getOwnerDetail() : "");
        advertisementSearch.setPermissionEndDate(advertisementPermitDetail.getPermissionenddate());
        advertisementSearch.setPermissionNumber(advertisementPermitDetail.getPermissionNumber());
        advertisementSearch.setPermissionStartDate(advertisementPermitDetail.getPermissionstartdate());
        advertisementSearch.setPermitStatus(advertisementPermitDetail.getStatus().getDescription());
        advertisementSearch.setAssessmentNumber(advertisementPermitDetail.getAdvertisement().getPropertyNumber() != null ? advertisementPermitDetail.getAdvertisement().getPropertyNumber() : "");
        advertisementSearch.setPropertyType(advertisementPermitDetail.getAdvertisement().getPropertyType().name());
        advertisementSearch.setRevenueInspector(advertisementPermitDetail.getAdvertisement().getRevenueInspector().getName());
        advertisementSearch.setStreet(advertisementPermitDetail.getAdvertisement().getStreet() != null ? advertisementPermitDetail.getAdvertisement().getStreet().getName() : "");
        advertisementSearch.setSubCategory(advertisementPermitDetail.getAdvertisement().getSubCategory().getCode());
        advertisementSearch.setTaxAmount(advertisementPermitDetail.getTaxAmount());
        advertisementSearch.setTotalHeight(advertisementPermitDetail.getTotalHeight() != null ? advertisementPermitDetail.getTotalHeight() : 0.0);
        advertisementSearch.setUom(advertisementPermitDetail.getUnitOfMeasure().getCode());
        advertisementSearch.setWard(advertisementPermitDetail.getAdvertisement().getWard() != null ? advertisementPermitDetail.getAdvertisement().getWard().getName() : "");
        advertisementSearch.setWidth(advertisementPermitDetail.getWidth() != null ? advertisementPermitDetail.getWidth() : 0.0);
        String consumerName = advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getName() : advertisementPermitDetail.getOwnerDetail();
        advertisementSearch.setConsumerName(consumerName);
        advertisementSearch.setConsumerName_Clauses(consumerName);
        advertisementSearch.setConsumerNumber(advertisementPermitDetail.getApplicationNumber());
        advertisementSearch.setAdvertisementNumber_Clauses(advertisementPermitDetail.getAdvertisement().getAdvertisementNumber());
        advertisementSearch.setPermissionNumber_Clauses(advertisementPermitDetail.getPermissionNumber());
        advertisementSearch.setAgencyName_Clauses(advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getName() : "");
        advertisementSearch.setTax_demand(advertisementPermitDetail.getAdvertisement().getDemandId().getBaseDemand());
        advertisementSearch.setTax_collected(advertisementPermitDetail.getAdvertisement().getDemandId().getAmtCollected());
        Map<String, Map<String, BigDecimal>> demandCollectionMap = this.advertisementDemandService.getReasonWiseDemandAndCollection(advertisementPermitDetail);
        advertisementSearch.setEncroachmentfee_demand(demandCollectionMap.get("Enchroachmnt_Fee") != null ? (demandCollectionMap.get("Enchroachmnt_Fee").get("demandAmount") != null ? demandCollectionMap.get("Enchroachmnt_Fee").get("demandAmount") : BigDecimal.ZERO) : BigDecimal.ZERO);
        advertisementSearch.setEncroachmentfee_collected(demandCollectionMap.get("Enchroachmnt_Fee") != null ? (demandCollectionMap.get("Enchroachmnt_Fee").get("collectedAmount") != null ? demandCollectionMap.get("Enchroachmnt_Fee").get("collectedAmount") : BigDecimal.ZERO) : BigDecimal.ZERO);
        advertisementSearch.setArrears_demand(demandCollectionMap.get("Arrear_Adv_Tax") != null ? (demandCollectionMap.get("Arrear_Adv_Tax").get("demandAmount") != null ? demandCollectionMap.get("Arrear_Adv_Tax").get("demandAmount") : BigDecimal.ZERO) : BigDecimal.ZERO);
        advertisementSearch.setArrears_collected(demandCollectionMap.get("Arrear_Adv_Tax") != null ? (demandCollectionMap.get("Arrear_Adv_Tax").get("collectedAmount") != null ? demandCollectionMap.get("Arrear_Adv_Tax").get("collectedAmount") : BigDecimal.ZERO) : BigDecimal.ZERO);
        advertisementSearch.setPenalty_demand(demandCollectionMap.get("Penalty") != null ? (demandCollectionMap.get("Penalty").get("demandAmount") != null ? demandCollectionMap.get("Penalty").get("demandAmount") : BigDecimal.ZERO) : BigDecimal.ZERO);
        advertisementSearch.setPenalty_collected(demandCollectionMap.get("Penalty") != null ? (demandCollectionMap.get("Penalty").get("collectedAmount") != null ? demandCollectionMap.get("Penalty").get("collectedAmount") : BigDecimal.ZERO) : BigDecimal.ZERO);
        advertisementSearch.setTotalamount(demandCollectionMap.get("Total") != null ? (demandCollectionMap.get("Total").get("totalAmount") != null ? demandCollectionMap.get("Total").get("totalAmount") : BigDecimal.ZERO) : BigDecimal.ZERO);
        advertisementSearch.setTotalamountcollected(demandCollectionMap.get("Total") != null ? (demandCollectionMap.get("Total").get("totalAmountCollected") != null ? demandCollectionMap.get("Total").get("totalAmountCollected") : BigDecimal.ZERO) : BigDecimal.ZERO);
        advertisementSearch.setTotalbalance(advertisementSearch.getTotalamount().subtract(advertisementSearch.getTotalamountcollected()));
        if (advertisementPermitDetail.getAdvertisement().getLatitude() != 0.0 && advertisementPermitDetail.getAdvertisement().getLongitude() != 0.0) {
            advertisementSearch.setAdvertisementLocation(new GeoPoint(advertisementPermitDetail.getAdvertisement().getLatitude(), advertisementPermitDetail.getAdvertisement().getLongitude()));
        }
        if (advertisementPermitDetail.getAdvertisement().getStatus().name().equalsIgnoreCase("INACTIVE")) {
            advertisementSearch.setDeactivationDate(advertisementPermitDetail.getDeactivation_date());
            advertisementSearch.setDeactivationRemarks(advertisementPermitDetail.getDeactivation_remarks());
        }
        this.advertisementIndexRepository.save(advertisementSearch);
        return advertisementSearch;
    }
}

