/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.exception.HoardingValidationError;
import org.egov.adtax.repository.AdvertisementRepository;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemand;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementService {
    @Autowired
    private AdvertisementRepository advertisementRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    protected CollectionIntegrationService collectionIntegrationService;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public Advertisement createAdvertisement(Advertisement hoarding) {
        if (hoarding != null && hoarding.getId() == null) {
            hoarding.setDemandId(this.advertisementDemandService.createDemand(hoarding));
        }
        this.roundOfAllTaxAmount(hoarding);
        return (Advertisement)((Object)this.advertisementRepository.save((Object)hoarding));
    }

    @Transactional
    public Advertisement updateAdvertisement(Advertisement advertisement) throws HoardingValidationError {
        this.getCurrentSession().evict((Object)advertisement);
        Advertisement actualHoarding = this.getHoardingByAdvertisementNumber(advertisement.getAdvertisementNumber());
        boolean anyDemandPendingForCollection = this.advertisementDemandService.anyDemandPendingForCollection(actualHoarding);
        if (!actualHoarding.getStatus().equals((Object)advertisement.getStatus()) && advertisement.getStatus().equals((Object)AdvertisementStatus.CANCELLED) && anyDemandPendingForCollection) {
            throw new HoardingValidationError("status", "ADTAX.003");
        }
        if (anyDemandPendingForCollection) {
            this.advertisementDemandService.updateDemand(advertisement, actualHoarding.getDemandId());
        }
        this.roundOfAllTaxAmount(advertisement);
        return (Advertisement)((Object)this.advertisementRepository.save((Object)advertisement));
    }

    private void roundOfAllTaxAmount(Advertisement hoarding) {
    }

    private boolean checkPendingTaxChanged(Advertisement hoarding, Advertisement actualHoarding) {
        if (actualHoarding.getPendingTax() == null && hoarding.getPendingTax() != null) {
            return true;
        }
        if (hoarding.getPendingTax() == null && actualHoarding.getPendingTax() != null) {
            return true;
        }
        return actualHoarding.getPendingTax() != null && hoarding.getPendingTax() != null && !actualHoarding.getPendingTax().equals(hoarding.getPendingTax());
    }

    private boolean checkEncroachmentFeeChanged(Advertisement hoarding, Advertisement actualHoarding) {
        return false;
    }

    public List<Object[]> searchBySearchType(Advertisement hoarding, String searchType) {
        return this.advertisementRepository.fetchAdvertisementBySearchType(hoarding, searchType);
    }

    public int getActivePermanentAdvertisementsByCurrentInstallment(Installment installment) {
        return this.advertisementRepository.findActivePermanentAdvertisementsByCurrentInstallment(installment);
    }

    @Transactional
    public List<Advertisement> findActivePermanentAdvertisementsByCurrentInstallmentAndNumberOfResultToFetch(Installment installment, int noOfResultToFetch) {
        return this.advertisementRepository.findActivePermanentAdvertisementsByCurrentInstallmentAndNumberOfResultToFetch(installment, noOfResultToFetch);
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public Advertisement getHoardingByAdvertisementNumber(String hoardingNumber) {
        return this.advertisementRepository.findByAdvertisementNumber(hoardingNumber);
    }

    public Advertisement findByAdvertisementNumber(String hoardingNumber) {
        return this.advertisementRepository.findByAdvertisementNumber(hoardingNumber);
    }

    public Advertisement findBy(Long hoardingId) {
        return (Advertisement)((Object)this.advertisementRepository.findOne(hoardingId));
    }

    public Advertisement getAdvertisementByDemand(EgDemand demand) {
        return this.advertisementRepository.findByDemandId(demand);
    }
}

