/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementBatchDemandGenerate;
import org.egov.adtax.repository.AdvertisementBatchDemandGenRepository;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementPermitDetailUpdateIndexService;
import org.egov.adtax.service.AdvertisementService;
import org.egov.commons.Installment;
import org.egov.demand.dao.EgDemandDao;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementBatchDemandGenService {
    private static final Logger LOGGER = Logger.getLogger(AdvertisementBatchDemandGenService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EgDemandDao egDemandDao;
    @Autowired
    private AdvertisementService advertisementService;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private AdvertisementBatchDemandGenRepository batchDemandGenRepository;
    @Autowired
    private AdvertisementPermitDetailUpdateIndexService advertisementPermitDetailUpdateIndexService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public AdvertisementBatchDemandGenerate getBatchDemandGenById(Long id) {
        return (AdvertisementBatchDemandGenerate)((Object)this.batchDemandGenRepository.findOne(id));
    }

    public List<AdvertisementBatchDemandGenerate> findActiveBatchDemands() {
        return this.batchDemandGenRepository.findActiveBatchDemands();
    }

    @Transactional
    public AdvertisementBatchDemandGenerate createAdvertisementBatchDemandGenerate(AdvertisementBatchDemandGenerate advBatchDmd) {
        return (AdvertisementBatchDemandGenerate)((Object)this.batchDemandGenRepository.save((Object)advBatchDmd));
    }

    @Transactional
    public AdvertisementBatchDemandGenerate updateAdvertisementBatchDemandGenerate(AdvertisementBatchDemandGenerate advBatchDmd) {
        return (AdvertisementBatchDemandGenerate)((Object)this.batchDemandGenRepository.save((Object)advBatchDmd));
    }

    @Transactional
    public int generateDemandForNextFinYear() {
        int totalRecordsProcessed = 0;
        List<AdvertisementBatchDemandGenerate> advBatchDmdGenResult = this.findActiveBatchDemands();
        LOGGER.info((Object)("advBatchDmdGenResult " + advBatchDmdGenResult.size()));
        List<Object> advertisements = new ArrayList();
        if (advBatchDmdGenResult != null && !advBatchDmdGenResult.isEmpty()) {
            AppConfigValues totalRecordToFeatch = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "Number of Records used in next year demand generation").get(0);
            LOGGER.info((Object)("*************************************** totalRecordToFeatch records " + totalRecordToFeatch.getValue()));
            AdvertisementBatchDemandGenerate advDmdGen = advBatchDmdGenResult.get(0);
            if (advDmdGen != null && advDmdGen.getInstallment() != null) {
                List<Installment> previousInstallment = this.advertisementDemandService.getPreviousInstallment(advDmdGen.getInstallment().getToDate());
                Installment installment = this.advertisementDemandService.getInsatllmentByModuleForGivenDate(advDmdGen.getInstallment().getToDate());
                if (installment != null && previousInstallment != null && previousInstallment.size() > 0) {
                    advertisements = this.advertisementService.findActivePermanentAdvertisementsByCurrentInstallmentAndNumberOfResultToFetch(previousInstallment.get(0), Integer.valueOf(totalRecordToFeatch.getValue()));
                    for (Advertisement advertisement : advertisements) {
                        advertisement.setDemandId(this.egDemandDao.findById(advertisement.getDemandId().getId(), false));
                    }
                    totalRecordsProcessed = this.advertisementDemandService.generateDemandForNextInstallment(advertisements, previousInstallment, installment);
                }
            }
            advDmdGen.setActive(false);
            advDmdGen.setTotalRecords(totalRecordsProcessed);
            this.updateAdvertisementBatchDemandGenerate(advDmdGen);
            for (Advertisement advertisement : advertisements) {
                this.advertisementPermitDetailUpdateIndexService.updateAdvertisementPermitDetailIndexes(advertisement.getActiveAdvertisementPermit());
            }
        }
        return totalRecordsProcessed;
    }
}

