/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.adtax.entity.AdvertisementRatesDetails;
import org.egov.adtax.entity.HoardingCategory;
import org.egov.adtax.entity.RatesClass;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.entity.UnitOfMeasure;
import org.egov.commons.CFinancialYear;
import org.egov.infra.persistence.entity.AbstractAuditable;

@Entity
@Table(name="EGADTAX_RATES")
@SequenceGenerator(name="SEQ_EGADTAX_RATES", sequenceName="SEQ_EGADTAX_RATES", allocationSize=1)
public class AdvertisementRate
extends AbstractAuditable {
    private static final long serialVersionUID = -3661778599272146492L;
    public static final String SEQ_RATES = "SEQ_EGADTAX_RATES";
    @Id
    @GeneratedValue(generator="SEQ_EGADTAX_RATES", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne
    @JoinColumn(name="category")
    private HoardingCategory category;
    @NotNull
    @ManyToOne
    @JoinColumn(name="subcategory")
    private SubCategory subCategory;
    @NotNull
    @ManyToOne
    @JoinColumn(name="unitofmeasure")
    private UnitOfMeasure unitofmeasure;
    @NotNull
    @ManyToOne
    @JoinColumn(name="class")
    private RatesClass classtype;
    private boolean active = Boolean.TRUE;
    @NotNull
    @ManyToOne
    @JoinColumn(name="financialyear")
    private CFinancialYear financialyear;
    @NotNull
    private Double unitrate;
    @Temporal(value=TemporalType.DATE)
    private Date validFromDate;
    @Temporal(value=TemporalType.DATE)
    private Date validToDate;
    @OrderBy(value="id")
    @OneToMany(mappedBy="advertisementRate", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<AdvertisementRatesDetails> advertisementRatesDetails = new ArrayList<AdvertisementRatesDetails>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public HoardingCategory getCategory() {
        return this.category;
    }

    public void setCategory(HoardingCategory category) {
        this.category = category;
    }

    public SubCategory getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(SubCategory subCategory) {
        this.subCategory = subCategory;
    }

    public UnitOfMeasure getUnitofmeasure() {
        return this.unitofmeasure;
    }

    public void setUnitofmeasure(UnitOfMeasure unitofmeasure) {
        this.unitofmeasure = unitofmeasure;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Date getValidFromDate() {
        return this.validFromDate;
    }

    public void setValidFromDate(Date validFromDate) {
        this.validFromDate = validFromDate;
    }

    public Date getValidToDate() {
        return this.validToDate;
    }

    public void setValidToDate(Date validToDate) {
        this.validToDate = validToDate;
    }

    public List<AdvertisementRatesDetails> getAdvertisementRatesDetails() {
        return this.advertisementRatesDetails;
    }

    public void setAdvertisementRatesDetails(List<AdvertisementRatesDetails> advertisementRatesDetails) {
        this.advertisementRatesDetails = advertisementRatesDetails;
    }

    public RatesClass getClasstype() {
        return this.classtype;
    }

    public void setClasstype(RatesClass classtype) {
        this.classtype = classtype;
    }

    public CFinancialYear getFinancialyear() {
        return this.financialyear;
    }

    public void setFinancialyear(CFinancialYear financialyear) {
        this.financialyear = financialyear;
    }

    public Double getUnitrate() {
        return this.unitrate;
    }

    public void setUnitrate(Double unitrate) {
        this.unitrate = unitrate;
    }
}

