/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.workflow;

import java.util.Date;
import javax.transaction.Transactional;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.utils.AdTaxNumberGenerator;
import org.egov.adtax.workflow.AdtaxWorkflowCustom;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AdtaxWorkflowCustomImpl
implements AdtaxWorkflowCustom {
    private static final Logger LOG = LoggerFactory.getLogger(AdtaxWorkflowCustomImpl.class);
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<AdvertisementPermitDetail> advertisementPermitDetailWorkflowService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private AdTaxNumberGenerator adTaxNumberGenerator;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;

    @Autowired
    public AdtaxWorkflowCustomImpl() {
    }

    @Override
    @Transactional
    public void createCommonWorkflowTransition(AdvertisementPermitDetail advertisementPermitDetail, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(advertisementPermitDetail.getCreatedBy().getId());
        if (approvalPosition != null && approvalPosition > 0L) {
            pos = this.positionMasterService.getPositionById(approvalPosition);
        }
        WorkFlowMatrix wfmatrix = null;
        if (null == advertisementPermitDetail.getState()) {
            wfmatrix = this.advertisementPermitDetailWorkflowService.getWfMatrix(advertisementPermitDetail.getStateType(), null, null, additionalRule, "NEW", null);
            advertisementPermitDetail.setStatus(this.getStatusByPassingModuleAndCode(wfmatrix));
            advertisementPermitDetail.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("CREATEADVERTISEMENT");
        } else if ("Approve".equalsIgnoreCase(workFlowAction)) {
            wfmatrix = this.advertisementPermitDetailWorkflowService.getWfMatrix(advertisementPermitDetail.getStateType(), null, null, additionalRule, advertisementPermitDetail.getCurrentState().getValue(), null);
            advertisementPermitDetail.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("ADVERTISEMENT", "APPROVED"));
            advertisementPermitDetail.setIsActive(true);
            advertisementPermitDetail.getAdvertisement().setStatus(AdvertisementStatus.ACTIVE);
            if (additionalRule != null && advertisementPermitDetail.getPreviousapplicationid() != null && additionalRule.equalsIgnoreCase("RENEWADVERTISEMENT")) {
                advertisementPermitDetail.getPreviousapplicationid().setIsActive(false);
                advertisementPermitDetail.getAdvertisement().setDemandId(this.advertisementDemandService.updateDemandOnRenewal(advertisementPermitDetail, advertisementPermitDetail.getAdvertisement().getDemandId()));
            }
            advertisementPermitDetail.setPermissionNumber(this.adTaxNumberGenerator.generatePermitNumber());
            advertisementPermitDetail.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(wfInitiator != null ? wfInitiator.getPosition() : null).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("CREATEADVERTISEMENT");
        } else if ("REJECT".equalsIgnoreCase(workFlowAction) || "CANCEL APPLICATION".equalsIgnoreCase(workFlowAction) || "CANCEL RENEWAL".equalsIgnoreCase(workFlowAction)) {
            if (ApplicationThreadLocals.getUserId().equals(wfInitiator != null && wfInitiator.getEmployee() != null ? wfInitiator.getEmployee().getId() : 0L)) {
                advertisementPermitDetail.setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("ADVERTISEMENT", "CANCELLED"));
                advertisementPermitDetail.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask("CREATEADVERTISEMENT");
                if (additionalRule != null && additionalRule.equalsIgnoreCase("CREATEADVERTISEMENT")) {
                    advertisementPermitDetail.getAdvertisement().setStatus(AdvertisementStatus.CANCELLED);
                } else {
                    advertisementPermitDetail.getAdvertisement().setStatus(AdvertisementStatus.ACTIVE);
                    if ("CANCEL RENEWAL".equalsIgnoreCase(workFlowAction) && additionalRule != null && advertisementPermitDetail.getPreviousapplicationid() != null && additionalRule.equalsIgnoreCase("RENEWADVERTISEMENT")) {
                        advertisementPermitDetail.getPreviousapplicationid().setIsActive(true);
                        advertisementPermitDetail.getPreviousapplicationid().setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("ADVERTISEMENT", "ADTAXPERMITGENERATED"));
                        advertisementPermitDetail.setIsActive(false);
                        advertisementPermitDetail.getAdvertisement().setDemandId(this.advertisementDemandService.updateDemandOnRenewal(advertisementPermitDetail.getPreviousapplicationid(), advertisementPermitDetail.getAdvertisement().getDemandId()));
                    }
                }
            } else {
                wfmatrix = this.advertisementPermitDetailWorkflowService.getWfMatrix(advertisementPermitDetail.getStateType(), null, null, additionalRule, "Rejected", null);
                advertisementPermitDetail.setStatus(this.getStatusByPassingModuleAndCode(wfmatrix));
                advertisementPermitDetail.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator != null ? wfInitiator.getPosition() : null).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("CREATEADVERTISEMENT");
            }
        } else if ("GENERATE DEMAND NOTICE".equalsIgnoreCase(workFlowAction)) {
            wfmatrix = this.advertisementPermitDetailWorkflowService.getWfMatrix(advertisementPermitDetail.getStateType(), null, null, additionalRule, advertisementPermitDetail.getCurrentState().getValue(), null);
            advertisementPermitDetail.setStatus(this.getStatusByPassingModuleAndCode(wfmatrix));
            advertisementPermitDetail.transition(true).withSenderName((wfInitiator != null && wfInitiator.getEmployee() != null ? wfInitiator.getEmployee().getUsername() : "") + "::" + (wfInitiator != null && wfInitiator.getEmployee() != null ? wfInitiator.getEmployee().getName() : "")).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(wfInitiator != null ? wfInitiator.getPosition() : null).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("CREATEADVERTISEMENT");
        } else if ("GENERATE PERMIT ORDER".equalsIgnoreCase(workFlowAction)) {
            wfmatrix = this.advertisementPermitDetailWorkflowService.getWfMatrix(advertisementPermitDetail.getStateType(), null, null, additionalRule, advertisementPermitDetail.getCurrentState().getValue(), null);
            advertisementPermitDetail.setStatus(this.getStatusByPassingModuleAndCode(wfmatrix));
            advertisementPermitDetail.getAdvertisement().setStatus(AdvertisementStatus.ACTIVE);
            if (wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                advertisementPermitDetail.transition(true).end().withSenderName((wfInitiator != null && wfInitiator.getEmployee() != null ? wfInitiator.getEmployee().getUsername() : "") + "::" + (wfInitiator != null && wfInitiator.getEmployee() != null ? wfInitiator.getEmployee().getName() : "")).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask("CREATEADVERTISEMENT");
            }
        } else {
            wfmatrix = this.advertisementPermitDetailWorkflowService.getWfMatrix(advertisementPermitDetail.getStateType(), null, null, additionalRule, advertisementPermitDetail.getCurrentState().getValue(), null);
            advertisementPermitDetail.setStatus(this.getStatusByPassingModuleAndCode(wfmatrix));
            advertisementPermitDetail.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("CREATEADVERTISEMENT");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed ");
        }
    }

    private EgwStatus getStatusByPassingModuleAndCode(WorkFlowMatrix wfmatrix) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode("ADVERTISEMENT", wfmatrix.getNextStatus());
    }
}

