/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.utils;

import java.io.Serializable;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.DBSequenceGenerator;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdTaxNumberGenerator {
    private static final String ADVERTISEMENT_NUMBER_SEQ_PREFIX = "SEQ_ADVERTISEMENT_NUMBER";
    private static final String PERMIT_NUMBER_SEQ_PREFIX = "SEQ_PERMIT_NUMBER";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private DBSequenceGenerator dbSequenceGenerator;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;

    @Transactional
    public String generateAdvertisementNumber() {
        try {
            Serializable sequenceNumber;
            String sequenceName = ADVERTISEMENT_NUMBER_SEQ_PREFIX;
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(ADVERTISEMENT_NUMBER_SEQ_PREFIX);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(ADVERTISEMENT_NUMBER_SEQ_PREFIX);
            }
            return String.format("%s%06d", ApplicationThreadLocals.getCityCode(), sequenceNumber);
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Advertisement Number", (Throwable)e);
        }
    }

    @Transactional
    public String generatePermitNumber() {
        try {
            Serializable sequenceNumber;
            String sequenceName = PERMIT_NUMBER_SEQ_PREFIX;
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(PERMIT_NUMBER_SEQ_PREFIX);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(PERMIT_NUMBER_SEQ_PREFIX);
            }
            return String.format("%s%06d", ApplicationThreadLocals.getCityCode(), sequenceNumber);
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException("Error occurred while generating Permit Number", (Throwable)e);
        }
    }

    @Transactional
    public String generateApplicationNumber() {
        return this.applicationNumberGenerator.generate();
    }
}

