/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.HoardingCategory;
import org.egov.adtax.entity.HoardingDocument;
import org.egov.adtax.entity.RatesClass;
import org.egov.adtax.entity.RevenueInspector;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.entity.enums.AdvertisementPropertyType;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.entity.enums.AdvertisementStructureType;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGADTAX_ADVERTISEMENT")
@SequenceGenerator(name="SEQ_EGADTAX_ADVERTISEMENT", sequenceName="SEQ_EGADTAX_ADVERTISEMENT", allocationSize=1)
@Unique(id="id", tableName="EGADTAX_ADVERTISEMENT", columnName={"advertisementnumber"}, fields={"advertisementnumber"}, enableDfltMsg=true)
public class Advertisement
extends AbstractAuditable {
    private static final long serialVersionUID = 8916477826209092997L;
    public static final String SEQ_ADVERTISEMENT = "SEQ_EGADTAX_ADVERTISEMENT";
    @Id
    @GeneratedValue(generator="SEQ_EGADTAX_ADVERTISEMENT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Column(name="advertisementnumber", unique=true)
    @SafeHtml
    @Length(max=25)
    private String advertisementNumber;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    private AdvertisementStructureType type = AdvertisementStructureType.PERMANENT;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    private AdvertisementPropertyType propertyType;
    @SafeHtml
    @Length(max=50)
    private String propertyNumber;
    @SafeHtml
    @Length(max=50)
    private String electricityServiceNumber;
    @Enumerated(value=EnumType.ORDINAL)
    private AdvertisementStatus status;
    @NotNull
    @ManyToOne
    @JoinColumn(name="category", nullable=false)
    private HoardingCategory category;
    @NotNull
    @ManyToOne
    @JoinColumn(name="subcategory", nullable=false)
    private SubCategory subCategory;
    private Boolean legacy = false;
    private BigDecimal pendingTax;
    private Date penaltyCalculationDate;
    @NotNull
    @ManyToOne
    @JoinColumn(name="class", nullable=false)
    private RatesClass rateClass;
    @ManyToOne
    @JoinColumn(name="revenueinspector")
    private RevenueInspector revenueInspector;
    @ManyToOne
    @JoinColumn(name="locality")
    private Boundary locality;
    @NotNull
    @ManyToOne
    @JoinColumn(name="ward", nullable=false)
    private Boundary ward;
    @ManyToOne
    @JoinColumn(name="block")
    private Boundary block;
    @ManyToOne
    @JoinColumn(name="street")
    private Boundary street;
    @ManyToOne
    @JoinColumn(name="electionward")
    private Boundary electionWard;
    @NotNull
    @SafeHtml
    @Length(max=512)
    private String address;
    @OneToMany(mappedBy="advertisement", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Set<AdvertisementPermitDetail> advertisementPermitDetail = new HashSet<AdvertisementPermitDetail>(0);
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="demandid", nullable=false)
    private EgDemand demandId;
    private double longitude;
    private double latitude;
    @OneToMany(fetch=FetchType.LAZY, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinTable(name="egadtax_advertisement_docs", joinColumns={@JoinColumn(name="advertisement")}, inverseJoinColumns={@JoinColumn(name="document")})
    private List<HoardingDocument> documents = new ArrayList<HoardingDocument>();
    @Transient
    private Boolean taxPaidForCurrentYear = false;

    public AdvertisementPermitDetail getActiveAdvertisementPermit() {
        AdvertisementPermitDetail advPermitDtl = null;
        for (AdvertisementPermitDetail advPermitDetail : this.getAdvertisementPermitDetail()) {
            if (!advPermitDetail.getIsActive().booleanValue()) continue;
            advPermitDtl = advPermitDetail;
        }
        return advPermitDtl;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getPendingTax() {
        return this.pendingTax;
    }

    public void setPendingTax(BigDecimal pendingTax) {
        this.pendingTax = pendingTax;
    }

    public AdvertisementPropertyType getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(AdvertisementPropertyType propertyType) {
        this.propertyType = propertyType;
    }

    public String getPropertyNumber() {
        return this.propertyNumber;
    }

    public void setPropertyNumber(String propertyNumber) {
        this.propertyNumber = propertyNumber;
    }

    public AdvertisementStatus getStatus() {
        return this.status;
    }

    public void setStatus(AdvertisementStatus status) {
        this.status = status;
    }

    public HoardingCategory getCategory() {
        return this.category;
    }

    public void setCategory(HoardingCategory category) {
        this.category = category;
    }

    public SubCategory getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(SubCategory subCategory) {
        this.subCategory = subCategory;
    }

    public RatesClass getRateClass() {
        return this.rateClass;
    }

    public void setRateClass(RatesClass rateClass) {
        this.rateClass = rateClass;
    }

    public RevenueInspector getRevenueInspector() {
        return this.revenueInspector;
    }

    public void setRevenueInspector(RevenueInspector revenueInspector) {
        this.revenueInspector = revenueInspector;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public EgDemand getDemandId() {
        return this.demandId;
    }

    public void setDemandId(EgDemand demandId) {
        this.demandId = demandId;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public List<HoardingDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<HoardingDocument> documents) {
        this.documents = documents;
    }

    public Boolean getLegacy() {
        return this.legacy;
    }

    public void setLegacy(Boolean legacy) {
        this.legacy = legacy;
    }

    public Date getPenaltyCalculationDate() {
        return this.penaltyCalculationDate;
    }

    public void setPenaltyCalculationDate(Date penaltyCalculationDate) {
        this.penaltyCalculationDate = penaltyCalculationDate;
    }

    public Boundary getLocality() {
        return this.locality;
    }

    public void setLocality(Boundary locality) {
        this.locality = locality;
    }

    public Boundary getWard() {
        return this.ward;
    }

    public void setWard(Boundary ward) {
        this.ward = ward;
    }

    public Boundary getBlock() {
        return this.block;
    }

    public void setBlock(Boundary block) {
        this.block = block;
    }

    public Boundary getStreet() {
        return this.street;
    }

    public void setStreet(Boundary street) {
        this.street = street;
    }

    public Boundary getElectionWard() {
        return this.electionWard;
    }

    public void setElectionWard(Boundary electionWard) {
        this.electionWard = electionWard;
    }

    public String getElectricityServiceNumber() {
        return this.electricityServiceNumber;
    }

    public void setElectricityServiceNumber(String electricityServiceNumber) {
        this.electricityServiceNumber = electricityServiceNumber;
    }

    public String getAdvertisementNumber() {
        return this.advertisementNumber;
    }

    public void setAdvertisementNumber(String advertisementNumber) {
        this.advertisementNumber = advertisementNumber;
    }

    public AdvertisementStructureType getType() {
        return this.type;
    }

    public void setType(AdvertisementStructureType type) {
        this.type = type;
    }

    public Set<AdvertisementPermitDetail> getAdvertisementPermitDetail() {
        return this.advertisementPermitDetail;
    }

    public void setAdvertisementPermitDetail(Set<AdvertisementPermitDetail> advertisementPermitDetail) {
        this.advertisementPermitDetail = advertisementPermitDetail;
    }

    public Boolean getTaxPaidForCurrentYear() {
        return this.taxPaidForCurrentYear;
    }

    public void setTaxPaidForCurrentYear(Boolean taxPaidForCurrentYear) {
        this.taxPaidForCurrentYear = taxPaidForCurrentYear;
    }
}

