/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.referralmanagement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.referralmanagement.Referral;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReferralBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Referrals")
    @NotNull
    @Valid
    private List<Referral> referrals = new ArrayList<Referral>();

    public ReferralBulkResponse addReferralItem(Referral referralItem) {
        this.referrals.add(referralItem);
        return this;
    }

    public static ReferralBulkResponseBuilder builder() {
        return new ReferralBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Referral> getReferrals() {
        return this.referrals;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Referrals")
    public void setReferrals(List<Referral> referrals) {
        this.referrals = referrals;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferralBulkResponse)) {
            return false;
        }
        ReferralBulkResponse other = (ReferralBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Referral> this$referrals = this.getReferrals();
        List<Referral> other$referrals = other.getReferrals();
        return !(this$referrals == null ? other$referrals != null : !((Object)this$referrals).equals(other$referrals));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReferralBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Referral> $referrals = this.getReferrals();
        result = result * 59 + ($referrals == null ? 43 : ((Object)$referrals).hashCode());
        return result;
    }

    public String toString() {
        return "ReferralBulkResponse(responseInfo=" + this.getResponseInfo() + ", referrals=" + this.getReferrals() + ")";
    }

    public ReferralBulkResponse() {
    }

    public ReferralBulkResponse(ResponseInfo responseInfo, List<Referral> referrals) {
        this.responseInfo = responseInfo;
        this.referrals = referrals;
    }

    public static class ReferralBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Referral> referrals;

        ReferralBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public ReferralBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Referrals")
        public ReferralBulkResponseBuilder referrals(List<Referral> referrals) {
            this.referrals = referrals;
            return this;
        }

        public ReferralBulkResponse build() {
            return new ReferralBulkResponse(this.responseInfo, this.referrals);
        }

        public String toString() {
            return "ReferralBulkResponse.ReferralBulkResponseBuilder(responseInfo=" + this.responseInfo + ", referrals=" + this.referrals + ")";
        }
    }
}

