/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.product;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductVariantSearch {
    @JsonProperty(value="id")
    private List<String> id = null;
    @JsonProperty(value="productId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String productId = null;
    @JsonProperty(value="sku")
    @Size(min=0, max=1000)
    private @Size(min=0, max=1000) String sku = null;
    @JsonProperty(value="variation")
    @Size(min=0, max=1000)
    private @Size(min=0, max=1000) String variation = null;

    public static ProductVariantSearchBuilder builder() {
        return new ProductVariantSearchBuilder();
    }

    public List<String> getId() {
        return this.id;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getSku() {
        return this.sku;
    }

    public String getVariation() {
        return this.variation;
    }

    @JsonProperty(value="id")
    public void setId(List<String> id) {
        this.id = id;
    }

    @JsonProperty(value="productId")
    public void setProductId(String productId) {
        this.productId = productId;
    }

    @JsonProperty(value="sku")
    public void setSku(String sku) {
        this.sku = sku;
    }

    @JsonProperty(value="variation")
    public void setVariation(String variation) {
        this.variation = variation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductVariantSearch)) {
            return false;
        }
        ProductVariantSearch other = (ProductVariantSearch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$id = this.getId();
        List<String> other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$productId = this.getProductId();
        String other$productId = other.getProductId();
        if (this$productId == null ? other$productId != null : !this$productId.equals(other$productId)) {
            return false;
        }
        String this$sku = this.getSku();
        String other$sku = other.getSku();
        if (this$sku == null ? other$sku != null : !this$sku.equals(other$sku)) {
            return false;
        }
        String this$variation = this.getVariation();
        String other$variation = other.getVariation();
        return !(this$variation == null ? other$variation != null : !this$variation.equals(other$variation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProductVariantSearch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
        String $sku = this.getSku();
        result = result * 59 + ($sku == null ? 43 : $sku.hashCode());
        String $variation = this.getVariation();
        result = result * 59 + ($variation == null ? 43 : $variation.hashCode());
        return result;
    }

    public String toString() {
        return "ProductVariantSearch(id=" + this.getId() + ", productId=" + this.getProductId() + ", sku=" + this.getSku() + ", variation=" + this.getVariation() + ")";
    }

    public ProductVariantSearch() {
    }

    public ProductVariantSearch(List<String> id, String productId, String sku, String variation) {
        this.id = id;
        this.productId = productId;
        this.sku = sku;
        this.variation = variation;
    }

    public static class ProductVariantSearchBuilder {
        private List<String> id;
        private String productId;
        private String sku;
        private String variation;

        ProductVariantSearchBuilder() {
        }

        @JsonProperty(value="id")
        public ProductVariantSearchBuilder id(List<String> id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="productId")
        public ProductVariantSearchBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        @JsonProperty(value="sku")
        public ProductVariantSearchBuilder sku(String sku) {
            this.sku = sku;
            return this;
        }

        @JsonProperty(value="variation")
        public ProductVariantSearchBuilder variation(String variation) {
            this.variation = variation;
            return this;
        }

        public ProductVariantSearch build() {
            return new ProductVariantSearch(this.id, this.productId, this.sku, this.variation);
        }

        public String toString() {
            return "ProductVariantSearch.ProductVariantSearchBuilder(id=" + this.id + ", productId=" + this.productId + ", sku=" + this.sku + ", variation=" + this.variation + ")";
        }
    }
}

