/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.stock.Stock;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class StockResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Stock")
    @NotNull
    @Valid
    private Stock stock = null;

    public static StockResponseBuilder builder() {
        return new StockResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public Stock getStock() {
        return this.stock;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Stock")
    public void setStock(Stock stock) {
        this.stock = stock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StockResponse)) {
            return false;
        }
        StockResponse other = (StockResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        Stock this$stock = this.getStock();
        Stock other$stock = other.getStock();
        return !(this$stock == null ? other$stock != null : !((Object)this$stock).equals(other$stock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StockResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        Stock $stock = this.getStock();
        result = result * 59 + ($stock == null ? 43 : ((Object)$stock).hashCode());
        return result;
    }

    public String toString() {
        return "StockResponse(responseInfo=" + this.getResponseInfo() + ", stock=" + this.getStock() + ")";
    }

    public StockResponse() {
    }

    public StockResponse(ResponseInfo responseInfo, Stock stock) {
        this.responseInfo = responseInfo;
        this.stock = stock;
    }

    public static class StockResponseBuilder {
        private ResponseInfo responseInfo;
        private Stock stock;

        StockResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public StockResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Stock")
        public StockResponseBuilder stock(Stock stock) {
            this.stock = stock;
            return this;
        }

        public StockResponse build() {
            return new StockResponse(this.responseInfo, this.stock);
        }

        public String toString() {
            return "StockResponse.StockResponseBuilder(responseInfo=" + this.responseInfo + ", stock=" + this.stock + ")";
        }
    }
}

