/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import digit.models.coremodels.AuditDetails;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.models.stock.AdditionalFields;
import org.egov.common.models.stock.TransactionReason;
import org.egov.common.models.stock.TransactionType;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Stock {
    @JsonProperty(value="id")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String id = null;
    @JsonProperty(value="clientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String clientReferenceId = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=1000)
    private @NotNull @Size(min=2, max=1000) String tenantId = null;
    @JsonProperty(value="facilityId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String facilityId = null;
    @JsonProperty(value="productVariantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String productVariantId = null;
    @JsonProperty(value="quantity")
    @NotNull
    private Integer quantity = null;
    @JsonProperty(value="referenceId")
    private String referenceId = null;
    @JsonProperty(value="referenceIdType")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String referenceIdType = null;
    @JsonProperty(value="transactionType")
    @NotNull
    @Valid
    private TransactionType transactionType = null;
    @JsonProperty(value="transactionReason")
    @Valid
    private TransactionReason transactionReason = null;
    @JsonProperty(value="transactingPartyId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String transactingPartyId = null;
    @JsonProperty(value="transactingPartyType")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String transactingPartyType = null;
    @JsonProperty(value="wayBillNumber")
    @Size(min=2, max=200)
    private @Size(min=2, max=200) String wayBillNumber = null;
    @JsonProperty(value="additionalFields")
    @Valid
    private AdditionalFields additionalFields = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;
    @JsonProperty(value="rowVersion")
    private Integer rowVersion = null;
    @JsonIgnore
    private Boolean hasErrors = Boolean.FALSE;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;
    @JsonProperty(value="dateOfEntry")
    private Long dateOfEntry = null;
    @JsonProperty(value="clientAuditDetails")
    @Valid
    private AuditDetails clientAuditDetails = null;

    public static StockBuilder builder() {
        return new StockBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getFacilityId() {
        return this.facilityId;
    }

    public String getProductVariantId() {
        return this.productVariantId;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getReferenceIdType() {
        return this.referenceIdType;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public TransactionReason getTransactionReason() {
        return this.transactionReason;
    }

    public String getTransactingPartyId() {
        return this.transactingPartyId;
    }

    public String getTransactingPartyType() {
        return this.transactingPartyType;
    }

    public String getWayBillNumber() {
        return this.wayBillNumber;
    }

    public AdditionalFields getAdditionalFields() {
        return this.additionalFields;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Integer getRowVersion() {
        return this.rowVersion;
    }

    public Boolean getHasErrors() {
        return this.hasErrors;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Long getDateOfEntry() {
        return this.dateOfEntry;
    }

    public AuditDetails getClientAuditDetails() {
        return this.clientAuditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="clientReferenceId")
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="facilityId")
    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    @JsonProperty(value="productVariantId")
    public void setProductVariantId(String productVariantId) {
        this.productVariantId = productVariantId;
    }

    @JsonProperty(value="quantity")
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="referenceIdType")
    public void setReferenceIdType(String referenceIdType) {
        this.referenceIdType = referenceIdType;
    }

    @JsonProperty(value="transactionType")
    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    @JsonProperty(value="transactionReason")
    public void setTransactionReason(TransactionReason transactionReason) {
        this.transactionReason = transactionReason;
    }

    @JsonProperty(value="transactingPartyId")
    public void setTransactingPartyId(String transactingPartyId) {
        this.transactingPartyId = transactingPartyId;
    }

    @JsonProperty(value="transactingPartyType")
    public void setTransactingPartyType(String transactingPartyType) {
        this.transactingPartyType = transactingPartyType;
    }

    @JsonProperty(value="wayBillNumber")
    public void setWayBillNumber(String wayBillNumber) {
        this.wayBillNumber = wayBillNumber;
    }

    @JsonProperty(value="additionalFields")
    public void setAdditionalFields(AdditionalFields additionalFields) {
        this.additionalFields = additionalFields;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="rowVersion")
    public void setRowVersion(Integer rowVersion) {
        this.rowVersion = rowVersion;
    }

    @JsonIgnore
    public void setHasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="dateOfEntry")
    public void setDateOfEntry(Long dateOfEntry) {
        this.dateOfEntry = dateOfEntry;
    }

    @JsonProperty(value="clientAuditDetails")
    public void setClientAuditDetails(AuditDetails clientAuditDetails) {
        this.clientAuditDetails = clientAuditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Stock)) {
            return false;
        }
        Stock other = (Stock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$quantity = this.getQuantity();
        Integer other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Integer this$rowVersion = this.getRowVersion();
        Integer other$rowVersion = other.getRowVersion();
        if (this$rowVersion == null ? other$rowVersion != null : !((Object)this$rowVersion).equals(other$rowVersion)) {
            return false;
        }
        Boolean this$hasErrors = this.getHasErrors();
        Boolean other$hasErrors = other.getHasErrors();
        if (this$hasErrors == null ? other$hasErrors != null : !((Object)this$hasErrors).equals(other$hasErrors)) {
            return false;
        }
        Long this$dateOfEntry = this.getDateOfEntry();
        Long other$dateOfEntry = other.getDateOfEntry();
        if (this$dateOfEntry == null ? other$dateOfEntry != null : !((Object)this$dateOfEntry).equals(other$dateOfEntry)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$facilityId = this.getFacilityId();
        String other$facilityId = other.getFacilityId();
        if (this$facilityId == null ? other$facilityId != null : !this$facilityId.equals(other$facilityId)) {
            return false;
        }
        String this$productVariantId = this.getProductVariantId();
        String other$productVariantId = other.getProductVariantId();
        if (this$productVariantId == null ? other$productVariantId != null : !this$productVariantId.equals(other$productVariantId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$referenceIdType = this.getReferenceIdType();
        String other$referenceIdType = other.getReferenceIdType();
        if (this$referenceIdType == null ? other$referenceIdType != null : !this$referenceIdType.equals(other$referenceIdType)) {
            return false;
        }
        TransactionType this$transactionType = this.getTransactionType();
        TransactionType other$transactionType = other.getTransactionType();
        if (this$transactionType == null ? other$transactionType != null : !((Object)((Object)this$transactionType)).equals((Object)other$transactionType)) {
            return false;
        }
        TransactionReason this$transactionReason = this.getTransactionReason();
        TransactionReason other$transactionReason = other.getTransactionReason();
        if (this$transactionReason == null ? other$transactionReason != null : !((Object)((Object)this$transactionReason)).equals((Object)other$transactionReason)) {
            return false;
        }
        String this$transactingPartyId = this.getTransactingPartyId();
        String other$transactingPartyId = other.getTransactingPartyId();
        if (this$transactingPartyId == null ? other$transactingPartyId != null : !this$transactingPartyId.equals(other$transactingPartyId)) {
            return false;
        }
        String this$transactingPartyType = this.getTransactingPartyType();
        String other$transactingPartyType = other.getTransactingPartyType();
        if (this$transactingPartyType == null ? other$transactingPartyType != null : !this$transactingPartyType.equals(other$transactingPartyType)) {
            return false;
        }
        String this$wayBillNumber = this.getWayBillNumber();
        String other$wayBillNumber = other.getWayBillNumber();
        if (this$wayBillNumber == null ? other$wayBillNumber != null : !this$wayBillNumber.equals(other$wayBillNumber)) {
            return false;
        }
        AdditionalFields this$additionalFields = this.getAdditionalFields();
        AdditionalFields other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        AuditDetails this$clientAuditDetails = this.getClientAuditDetails();
        AuditDetails other$clientAuditDetails = other.getClientAuditDetails();
        return !(this$clientAuditDetails == null ? other$clientAuditDetails != null : !this$clientAuditDetails.equals(other$clientAuditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Stock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Integer $rowVersion = this.getRowVersion();
        result = result * 59 + ($rowVersion == null ? 43 : ((Object)$rowVersion).hashCode());
        Boolean $hasErrors = this.getHasErrors();
        result = result * 59 + ($hasErrors == null ? 43 : ((Object)$hasErrors).hashCode());
        Long $dateOfEntry = this.getDateOfEntry();
        result = result * 59 + ($dateOfEntry == null ? 43 : ((Object)$dateOfEntry).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $facilityId = this.getFacilityId();
        result = result * 59 + ($facilityId == null ? 43 : $facilityId.hashCode());
        String $productVariantId = this.getProductVariantId();
        result = result * 59 + ($productVariantId == null ? 43 : $productVariantId.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $referenceIdType = this.getReferenceIdType();
        result = result * 59 + ($referenceIdType == null ? 43 : $referenceIdType.hashCode());
        TransactionType $transactionType = this.getTransactionType();
        result = result * 59 + ($transactionType == null ? 43 : ((Object)((Object)$transactionType)).hashCode());
        TransactionReason $transactionReason = this.getTransactionReason();
        result = result * 59 + ($transactionReason == null ? 43 : ((Object)((Object)$transactionReason)).hashCode());
        String $transactingPartyId = this.getTransactingPartyId();
        result = result * 59 + ($transactingPartyId == null ? 43 : $transactingPartyId.hashCode());
        String $transactingPartyType = this.getTransactingPartyType();
        result = result * 59 + ($transactingPartyType == null ? 43 : $transactingPartyType.hashCode());
        String $wayBillNumber = this.getWayBillNumber();
        result = result * 59 + ($wayBillNumber == null ? 43 : $wayBillNumber.hashCode());
        AdditionalFields $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        AuditDetails $clientAuditDetails = this.getClientAuditDetails();
        result = result * 59 + ($clientAuditDetails == null ? 43 : $clientAuditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "Stock(id=" + this.getId() + ", clientReferenceId=" + this.getClientReferenceId() + ", tenantId=" + this.getTenantId() + ", facilityId=" + this.getFacilityId() + ", productVariantId=" + this.getProductVariantId() + ", quantity=" + this.getQuantity() + ", referenceId=" + this.getReferenceId() + ", referenceIdType=" + this.getReferenceIdType() + ", transactionType=" + (Object)((Object)this.getTransactionType()) + ", transactionReason=" + (Object)((Object)this.getTransactionReason()) + ", transactingPartyId=" + this.getTransactingPartyId() + ", transactingPartyType=" + this.getTransactingPartyType() + ", wayBillNumber=" + this.getWayBillNumber() + ", additionalFields=" + this.getAdditionalFields() + ", isDeleted=" + this.getIsDeleted() + ", rowVersion=" + this.getRowVersion() + ", hasErrors=" + this.getHasErrors() + ", auditDetails=" + this.getAuditDetails() + ", dateOfEntry=" + this.getDateOfEntry() + ", clientAuditDetails=" + this.getClientAuditDetails() + ")";
    }

    public Stock() {
    }

    public Stock(String id, String clientReferenceId, String tenantId, String facilityId, String productVariantId, Integer quantity, String referenceId, String referenceIdType, TransactionType transactionType, TransactionReason transactionReason, String transactingPartyId, String transactingPartyType, String wayBillNumber, AdditionalFields additionalFields, Boolean isDeleted, Integer rowVersion, Boolean hasErrors, AuditDetails auditDetails, Long dateOfEntry, AuditDetails clientAuditDetails) {
        this.id = id;
        this.clientReferenceId = clientReferenceId;
        this.tenantId = tenantId;
        this.facilityId = facilityId;
        this.productVariantId = productVariantId;
        this.quantity = quantity;
        this.referenceId = referenceId;
        this.referenceIdType = referenceIdType;
        this.transactionType = transactionType;
        this.transactionReason = transactionReason;
        this.transactingPartyId = transactingPartyId;
        this.transactingPartyType = transactingPartyType;
        this.wayBillNumber = wayBillNumber;
        this.additionalFields = additionalFields;
        this.isDeleted = isDeleted;
        this.rowVersion = rowVersion;
        this.hasErrors = hasErrors;
        this.auditDetails = auditDetails;
        this.dateOfEntry = dateOfEntry;
        this.clientAuditDetails = clientAuditDetails;
    }

    public static class StockBuilder {
        private String id;
        private String clientReferenceId;
        private String tenantId;
        private String facilityId;
        private String productVariantId;
        private Integer quantity;
        private String referenceId;
        private String referenceIdType;
        private TransactionType transactionType;
        private TransactionReason transactionReason;
        private String transactingPartyId;
        private String transactingPartyType;
        private String wayBillNumber;
        private AdditionalFields additionalFields;
        private Boolean isDeleted;
        private Integer rowVersion;
        private Boolean hasErrors;
        private AuditDetails auditDetails;
        private Long dateOfEntry;
        private AuditDetails clientAuditDetails;

        StockBuilder() {
        }

        @JsonProperty(value="id")
        public StockBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="clientReferenceId")
        public StockBuilder clientReferenceId(String clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        @JsonProperty(value="tenantId")
        public StockBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="facilityId")
        public StockBuilder facilityId(String facilityId) {
            this.facilityId = facilityId;
            return this;
        }

        @JsonProperty(value="productVariantId")
        public StockBuilder productVariantId(String productVariantId) {
            this.productVariantId = productVariantId;
            return this;
        }

        @JsonProperty(value="quantity")
        public StockBuilder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        @JsonProperty(value="referenceId")
        public StockBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="referenceIdType")
        public StockBuilder referenceIdType(String referenceIdType) {
            this.referenceIdType = referenceIdType;
            return this;
        }

        @JsonProperty(value="transactionType")
        public StockBuilder transactionType(TransactionType transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        @JsonProperty(value="transactionReason")
        public StockBuilder transactionReason(TransactionReason transactionReason) {
            this.transactionReason = transactionReason;
            return this;
        }

        @JsonProperty(value="transactingPartyId")
        public StockBuilder transactingPartyId(String transactingPartyId) {
            this.transactingPartyId = transactingPartyId;
            return this;
        }

        @JsonProperty(value="transactingPartyType")
        public StockBuilder transactingPartyType(String transactingPartyType) {
            this.transactingPartyType = transactingPartyType;
            return this;
        }

        @JsonProperty(value="wayBillNumber")
        public StockBuilder wayBillNumber(String wayBillNumber) {
            this.wayBillNumber = wayBillNumber;
            return this;
        }

        @JsonProperty(value="additionalFields")
        public StockBuilder additionalFields(AdditionalFields additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        @JsonProperty(value="isDeleted")
        public StockBuilder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        @JsonProperty(value="rowVersion")
        public StockBuilder rowVersion(Integer rowVersion) {
            this.rowVersion = rowVersion;
            return this;
        }

        @JsonIgnore
        public StockBuilder hasErrors(Boolean hasErrors) {
            this.hasErrors = hasErrors;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public StockBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="dateOfEntry")
        public StockBuilder dateOfEntry(Long dateOfEntry) {
            this.dateOfEntry = dateOfEntry;
            return this;
        }

        @JsonProperty(value="clientAuditDetails")
        public StockBuilder clientAuditDetails(AuditDetails clientAuditDetails) {
            this.clientAuditDetails = clientAuditDetails;
            return this;
        }

        public Stock build() {
            return new Stock(this.id, this.clientReferenceId, this.tenantId, this.facilityId, this.productVariantId, this.quantity, this.referenceId, this.referenceIdType, this.transactionType, this.transactionReason, this.transactingPartyId, this.transactingPartyType, this.wayBillNumber, this.additionalFields, this.isDeleted, this.rowVersion, this.hasErrors, this.auditDetails, this.dateOfEntry, this.clientAuditDetails);
        }

        public String toString() {
            return "Stock.StockBuilder(id=" + this.id + ", clientReferenceId=" + this.clientReferenceId + ", tenantId=" + this.tenantId + ", facilityId=" + this.facilityId + ", productVariantId=" + this.productVariantId + ", quantity=" + this.quantity + ", referenceId=" + this.referenceId + ", referenceIdType=" + this.referenceIdType + ", transactionType=" + (Object)((Object)this.transactionType) + ", transactionReason=" + (Object)((Object)this.transactionReason) + ", transactingPartyId=" + this.transactingPartyId + ", transactingPartyType=" + this.transactingPartyType + ", wayBillNumber=" + this.wayBillNumber + ", additionalFields=" + this.additionalFields + ", isDeleted=" + this.isDeleted + ", rowVersion=" + this.rowVersion + ", hasErrors=" + this.hasErrors + ", auditDetails=" + this.auditDetails + ", dateOfEntry=" + this.dateOfEntry + ", clientAuditDetails=" + this.clientAuditDetails + ")";
        }
    }
}

