/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.product;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.product.ProductVariant;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductVariantResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="ProductVariant")
    @NotNull
    @Valid
    private List<ProductVariant> productVariant = new ArrayList<ProductVariant>();

    public ProductVariantResponse addProductVariantItem(ProductVariant productVariantItem) {
        this.productVariant.add(productVariantItem);
        return this;
    }

    public static ProductVariantResponseBuilder builder() {
        return new ProductVariantResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<ProductVariant> getProductVariant() {
        return this.productVariant;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="ProductVariant")
    public void setProductVariant(List<ProductVariant> productVariant) {
        this.productVariant = productVariant;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductVariantResponse)) {
            return false;
        }
        ProductVariantResponse other = (ProductVariantResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<ProductVariant> this$productVariant = this.getProductVariant();
        List<ProductVariant> other$productVariant = other.getProductVariant();
        return !(this$productVariant == null ? other$productVariant != null : !((Object)this$productVariant).equals(other$productVariant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProductVariantResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<ProductVariant> $productVariant = this.getProductVariant();
        result = result * 59 + ($productVariant == null ? 43 : ((Object)$productVariant).hashCode());
        return result;
    }

    public String toString() {
        return "ProductVariantResponse(responseInfo=" + this.getResponseInfo() + ", productVariant=" + this.getProductVariant() + ")";
    }

    public ProductVariantResponse() {
    }

    public ProductVariantResponse(ResponseInfo responseInfo, List<ProductVariant> productVariant) {
        this.responseInfo = responseInfo;
        this.productVariant = productVariant;
    }

    public static class ProductVariantResponseBuilder {
        private ResponseInfo responseInfo;
        private List<ProductVariant> productVariant;

        ProductVariantResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public ProductVariantResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="ProductVariant")
        public ProductVariantResponseBuilder productVariant(List<ProductVariant> productVariant) {
            this.productVariant = productVariant;
            return this;
        }

        public ProductVariantResponse build() {
            return new ProductVariantResponse(this.responseInfo, this.productVariant);
        }

        public String toString() {
            return "ProductVariantResponse.ProductVariantResponseBuilder(responseInfo=" + this.responseInfo + ", productVariant=" + this.productVariant + ")";
        }
    }
}

