/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.project.Task;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Tasks")
    @NotNull
    @Valid
    private List<Task> tasks = null;

    public TaskBulkResponse addIndividualItem(Task taskItem) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<Task>();
        }
        this.tasks.add(taskItem);
        return this;
    }

    public static TaskBulkResponseBuilder builder() {
        return new TaskBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Tasks")
    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskBulkResponse)) {
            return false;
        }
        TaskBulkResponse other = (TaskBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }

    public String toString() {
        return "TaskBulkResponse(responseInfo=" + this.getResponseInfo() + ", tasks=" + this.getTasks() + ")";
    }

    public TaskBulkResponse() {
    }

    public TaskBulkResponse(ResponseInfo responseInfo, List<Task> tasks) {
        this.responseInfo = responseInfo;
        this.tasks = tasks;
    }

    public static class TaskBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Task> tasks;

        TaskBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public TaskBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Tasks")
        public TaskBulkResponseBuilder tasks(List<Task> tasks) {
            this.tasks = tasks;
            return this;
        }

        public TaskBulkResponse build() {
            return new TaskBulkResponse(this.responseInfo, this.tasks);
        }

        public String toString() {
            return "TaskBulkResponse.TaskBulkResponseBuilder(responseInfo=" + this.responseInfo + ", tasks=" + this.tasks + ")";
        }
    }
}

