/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.project.ProjectBeneficiary;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class BeneficiaryBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="ProjectBeneficiaries")
    @Valid
    @NotNull
    @Size(min=1)
    private @Valid @NotNull @Size(min=1) List<ProjectBeneficiary> projectBeneficiaries = null;

    public BeneficiaryBulkRequest addProjectBeneficiaryItem(ProjectBeneficiary projectBeneficiaryItem) {
        if (this.projectBeneficiaries == null) {
            this.projectBeneficiaries = new ArrayList<ProjectBeneficiary>();
        }
        this.projectBeneficiaries.add(projectBeneficiaryItem);
        return this;
    }

    public static BeneficiaryBulkRequestBuilder builder() {
        return new BeneficiaryBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<ProjectBeneficiary> getProjectBeneficiaries() {
        return this.projectBeneficiaries;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="ProjectBeneficiaries")
    public void setProjectBeneficiaries(List<ProjectBeneficiary> projectBeneficiaries) {
        this.projectBeneficiaries = projectBeneficiaries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeneficiaryBulkRequest)) {
            return false;
        }
        BeneficiaryBulkRequest other = (BeneficiaryBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<ProjectBeneficiary> this$projectBeneficiaries = this.getProjectBeneficiaries();
        List<ProjectBeneficiary> other$projectBeneficiaries = other.getProjectBeneficiaries();
        return !(this$projectBeneficiaries == null ? other$projectBeneficiaries != null : !((Object)this$projectBeneficiaries).equals(other$projectBeneficiaries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeneficiaryBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<ProjectBeneficiary> $projectBeneficiaries = this.getProjectBeneficiaries();
        result = result * 59 + ($projectBeneficiaries == null ? 43 : ((Object)$projectBeneficiaries).hashCode());
        return result;
    }

    public String toString() {
        return "BeneficiaryBulkRequest(requestInfo=" + this.getRequestInfo() + ", projectBeneficiaries=" + this.getProjectBeneficiaries() + ")";
    }

    public BeneficiaryBulkRequest() {
    }

    public BeneficiaryBulkRequest(RequestInfo requestInfo, List<ProjectBeneficiary> projectBeneficiaries) {
        this.requestInfo = requestInfo;
        this.projectBeneficiaries = projectBeneficiaries;
    }

    public static class BeneficiaryBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<ProjectBeneficiary> projectBeneficiaries;

        BeneficiaryBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public BeneficiaryBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="ProjectBeneficiaries")
        public BeneficiaryBulkRequestBuilder projectBeneficiaries(List<ProjectBeneficiary> projectBeneficiaries) {
            this.projectBeneficiaries = projectBeneficiaries;
            return this;
        }

        public BeneficiaryBulkRequest build() {
            return new BeneficiaryBulkRequest(this.requestInfo, this.projectBeneficiaries);
        }

        public String toString() {
            return "BeneficiaryBulkRequest.BeneficiaryBulkRequestBuilder(requestInfo=" + this.requestInfo + ", projectBeneficiaries=" + this.projectBeneficiaries + ")";
        }
    }
}

