/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.project.Task;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Tasks")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<Task> tasks = new ArrayList<Task>();

    public TaskBulkRequest addTaskItem(Task taskItem) {
        this.tasks.add(taskItem);
        return this;
    }

    public static TaskBulkRequestBuilder builder() {
        return new TaskBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Tasks")
    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskBulkRequest)) {
            return false;
        }
        TaskBulkRequest other = (TaskBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }

    public String toString() {
        return "TaskBulkRequest(requestInfo=" + this.getRequestInfo() + ", tasks=" + this.getTasks() + ")";
    }

    public TaskBulkRequest() {
    }

    public TaskBulkRequest(RequestInfo requestInfo, List<Task> tasks) {
        this.requestInfo = requestInfo;
        this.tasks = tasks;
    }

    public static class TaskBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<Task> tasks;

        TaskBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public TaskBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Tasks")
        public TaskBulkRequestBuilder tasks(List<Task> tasks) {
            this.tasks = tasks;
            return this;
        }

        public TaskBulkRequest build() {
            return new TaskBulkRequest(this.requestInfo, this.tasks);
        }

        public String toString() {
            return "TaskBulkRequest.TaskBulkRequestBuilder(requestInfo=" + this.requestInfo + ", tasks=" + this.tasks + ")";
        }
    }
}

