/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="minimal representation of the Roles in the system to be carried along in UserInfo with RequestInfo meta data. Actual authorization service to extend this to have more role related attributes ")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Role {
    @JsonProperty(value="name")
    @NotNull
    @Size(max=64)
    private @NotNull @Size(max=64) String name = null;
    @JsonProperty(value="code")
    @Size(max=64)
    private @Size(max=64) String code = null;
    @JsonProperty(value="description")
    private String description = null;

    public static RoleBuilder builder() {
        return new RoleBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="code")
    public void setCode(String code) {
        this.code = code;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role other = (Role)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Role;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "Role(name=" + this.getName() + ", code=" + this.getCode() + ", description=" + this.getDescription() + ")";
    }

    public Role() {
    }

    public Role(String name, String code, String description) {
        this.name = name;
        this.code = code;
        this.description = description;
    }

    public static class RoleBuilder {
        private String name;
        private String code;
        private String description;

        RoleBuilder() {
        }

        @JsonProperty(value="name")
        public RoleBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="code")
        public RoleBuilder code(String code) {
            this.code = code;
            return this;
        }

        @JsonProperty(value="description")
        public RoleBuilder description(String description) {
            this.description = description;
            return this;
        }

        public Role build() {
            return new Role(this.name, this.code, this.description);
        }

        public String toString() {
            return "Role.RoleBuilder(name=" + this.name + ", code=" + this.code + ", description=" + this.description + ")";
        }
    }
}

