/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.project.ProjectResource;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectResourceBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="ProjectResources")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<ProjectResource> projectResource = new ArrayList<ProjectResource>();

    public ProjectResourceBulkRequest addProjectResourceItem(ProjectResource projectResourceItem) {
        this.projectResource.add(projectResourceItem);
        return this;
    }

    public static ProjectResourceBulkRequestBuilder builder() {
        return new ProjectResourceBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<ProjectResource> getProjectResource() {
        return this.projectResource;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="ProjectResources")
    public void setProjectResource(List<ProjectResource> projectResource) {
        this.projectResource = projectResource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectResourceBulkRequest)) {
            return false;
        }
        ProjectResourceBulkRequest other = (ProjectResourceBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<ProjectResource> this$projectResource = this.getProjectResource();
        List<ProjectResource> other$projectResource = other.getProjectResource();
        return !(this$projectResource == null ? other$projectResource != null : !((Object)this$projectResource).equals(other$projectResource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectResourceBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<ProjectResource> $projectResource = this.getProjectResource();
        result = result * 59 + ($projectResource == null ? 43 : ((Object)$projectResource).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectResourceBulkRequest(requestInfo=" + this.getRequestInfo() + ", projectResource=" + this.getProjectResource() + ")";
    }

    public ProjectResourceBulkRequest() {
    }

    public ProjectResourceBulkRequest(RequestInfo requestInfo, List<ProjectResource> projectResource) {
        this.requestInfo = requestInfo;
        this.projectResource = projectResource;
    }

    public static class ProjectResourceBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<ProjectResource> projectResource;

        ProjectResourceBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ProjectResourceBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="ProjectResources")
        public ProjectResourceBulkRequestBuilder projectResource(List<ProjectResource> projectResource) {
            this.projectResource = projectResource;
            return this;
        }

        public ProjectResourceBulkRequest build() {
            return new ProjectResourceBulkRequest(this.requestInfo, this.projectResource);
        }

        public String toString() {
            return "ProjectResourceBulkRequest.ProjectResourceBulkRequestBuilder(requestInfo=" + this.requestInfo + ", projectResource=" + this.projectResource + ")";
        }
    }
}

