/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import digit.models.coremodels.AuditDetails;
import io.swagger.annotations.ApiModel;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.models.project.ProjectProductVariant;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="This object defines the mapping of a resource to a project.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectResource {
    @JsonProperty(value="id")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String id = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=1000)
    private @NotNull @Size(min=2, max=1000) String tenantId = null;
    @JsonProperty(value="projectId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String projectId = null;
    @JsonProperty(value="resource")
    @NotNull
    private ProjectProductVariant resource = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;
    @JsonProperty(value="rowVersion")
    private Integer rowVersion = null;
    @JsonProperty(value="startDate")
    private Long startDate = null;
    @JsonProperty(value="endDate")
    private Long endDate = null;
    @JsonIgnore
    private Boolean hasErrors = Boolean.FALSE;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;

    public static ProjectResourceBuilder builder() {
        return new ProjectResourceBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public ProjectProductVariant getResource() {
        return this.resource;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Integer getRowVersion() {
        return this.rowVersion;
    }

    public Long getStartDate() {
        return this.startDate;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public Boolean getHasErrors() {
        return this.hasErrors;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="resource")
    public void setResource(ProjectProductVariant resource) {
        this.resource = resource;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="rowVersion")
    public void setRowVersion(Integer rowVersion) {
        this.rowVersion = rowVersion;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    @JsonIgnore
    public void setHasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectResource)) {
            return false;
        }
        ProjectResource other = (ProjectResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Integer this$rowVersion = this.getRowVersion();
        Integer other$rowVersion = other.getRowVersion();
        if (this$rowVersion == null ? other$rowVersion != null : !((Object)this$rowVersion).equals(other$rowVersion)) {
            return false;
        }
        Long this$startDate = this.getStartDate();
        Long other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Long this$endDate = this.getEndDate();
        Long other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Boolean this$hasErrors = this.getHasErrors();
        Boolean other$hasErrors = other.getHasErrors();
        if (this$hasErrors == null ? other$hasErrors != null : !((Object)this$hasErrors).equals(other$hasErrors)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        ProjectProductVariant this$resource = this.getResource();
        ProjectProductVariant other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Integer $rowVersion = this.getRowVersion();
        result = result * 59 + ($rowVersion == null ? 43 : ((Object)$rowVersion).hashCode());
        Long $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Long $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Boolean $hasErrors = this.getHasErrors();
        result = result * 59 + ($hasErrors == null ? 43 : ((Object)$hasErrors).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        ProjectProductVariant $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "ProjectResource(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", projectId=" + this.getProjectId() + ", resource=" + this.getResource() + ", isDeleted=" + this.getIsDeleted() + ", rowVersion=" + this.getRowVersion() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", hasErrors=" + this.getHasErrors() + ", auditDetails=" + this.getAuditDetails() + ")";
    }

    public ProjectResource() {
    }

    public ProjectResource(String id, String tenantId, String projectId, ProjectProductVariant resource, Boolean isDeleted, Integer rowVersion, Long startDate, Long endDate, Boolean hasErrors, AuditDetails auditDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.projectId = projectId;
        this.resource = resource;
        this.isDeleted = isDeleted;
        this.rowVersion = rowVersion;
        this.startDate = startDate;
        this.endDate = endDate;
        this.hasErrors = hasErrors;
        this.auditDetails = auditDetails;
    }

    public static class ProjectResourceBuilder {
        private String id;
        private String tenantId;
        private String projectId;
        private ProjectProductVariant resource;
        private Boolean isDeleted;
        private Integer rowVersion;
        private Long startDate;
        private Long endDate;
        private Boolean hasErrors;
        private AuditDetails auditDetails;

        ProjectResourceBuilder() {
        }

        @JsonProperty(value="id")
        public ProjectResourceBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public ProjectResourceBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="projectId")
        public ProjectResourceBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @JsonProperty(value="resource")
        public ProjectResourceBuilder resource(ProjectProductVariant resource) {
            this.resource = resource;
            return this;
        }

        @JsonProperty(value="isDeleted")
        public ProjectResourceBuilder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        @JsonProperty(value="rowVersion")
        public ProjectResourceBuilder rowVersion(Integer rowVersion) {
            this.rowVersion = rowVersion;
            return this;
        }

        @JsonProperty(value="startDate")
        public ProjectResourceBuilder startDate(Long startDate) {
            this.startDate = startDate;
            return this;
        }

        @JsonProperty(value="endDate")
        public ProjectResourceBuilder endDate(Long endDate) {
            this.endDate = endDate;
            return this;
        }

        @JsonIgnore
        public ProjectResourceBuilder hasErrors(Boolean hasErrors) {
            this.hasErrors = hasErrors;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public ProjectResourceBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public ProjectResource build() {
            return new ProjectResource(this.id, this.tenantId, this.projectId, this.resource, this.isDeleted, this.rowVersion, this.startDate, this.endDate, this.hasErrors, this.auditDetails);
        }

        public String toString() {
            return "ProjectResource.ProjectResourceBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", projectId=" + this.projectId + ", resource=" + this.resource + ", isDeleted=" + this.isDeleted + ", rowVersion=" + this.rowVersion + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", hasErrors=" + this.hasErrors + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

