/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Size;
import org.egov.common.models.core.EgovSearchModel;
import org.egov.common.models.core.ProjectSearchURLParams;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectSearch
extends EgovSearchModel {
    @JsonProperty(value="startDate")
    private Long startDate;
    @JsonProperty(value="endDate")
    private Long endDate;
    @JsonProperty(value="isTaskEnabled")
    private Boolean isTaskEnabled = Boolean.FALSE;
    @JsonProperty(value="parent")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String parent;
    @JsonProperty(value="projectTypeId")
    private String projectTypeId;
    @JsonProperty(value="subProjectTypeId")
    private String subProjectTypeId;
    @JsonProperty(value="department")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String department;
    @JsonProperty(value="referenceId")
    @Size(min=2, max=100)
    private @Size(min=2, max=100) String referenceId;
    @JsonProperty(value="boundaryCode")
    private String boundaryCode;
    @JsonProperty(value="includeAncestors")
    private Boolean includeAncestors;
    @JsonProperty(value="includeDescendants")
    private Boolean includeDescendants;
    @JsonProperty(value="createdFrom")
    private Long createdFrom;
    @JsonProperty(value="createdTo")
    private Long createdTo;
    @JsonProperty(value="name")
    private String name;

    public void setURLParams(ProjectSearchURLParams urlParams) {
        if (urlParams.getIncludeAncestors() != null) {
            this.includeAncestors = urlParams.getIncludeAncestors();
        }
        if (urlParams.getIncludeDescendants() != null) {
            this.includeDescendants = urlParams.getIncludeDescendants();
        }
        if (urlParams.getCreatedFrom() != null) {
            this.createdFrom = urlParams.getCreatedFrom();
        }
        if (urlParams.getCreatedTo() != null) {
            this.createdTo = urlParams.getCreatedTo();
        }
    }

    protected ProjectSearch(ProjectSearchBuilder<?, ?> b) {
        super(b);
        this.startDate = b.startDate;
        this.endDate = b.endDate;
        this.isTaskEnabled = b.isTaskEnabled;
        this.parent = b.parent;
        this.projectTypeId = b.projectTypeId;
        this.subProjectTypeId = b.subProjectTypeId;
        this.department = b.department;
        this.referenceId = b.referenceId;
        this.boundaryCode = b.boundaryCode;
        this.includeAncestors = b.includeAncestors;
        this.includeDescendants = b.includeDescendants;
        this.createdFrom = b.createdFrom;
        this.createdTo = b.createdTo;
        this.name = b.name;
    }

    public static ProjectSearchBuilder<?, ?> builder() {
        return new ProjectSearchBuilderImpl();
    }

    public Long getStartDate() {
        return this.startDate;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public Boolean getIsTaskEnabled() {
        return this.isTaskEnabled;
    }

    public String getParent() {
        return this.parent;
    }

    public String getProjectTypeId() {
        return this.projectTypeId;
    }

    public String getSubProjectTypeId() {
        return this.subProjectTypeId;
    }

    public String getDepartment() {
        return this.department;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getBoundaryCode() {
        return this.boundaryCode;
    }

    public Boolean getIncludeAncestors() {
        return this.includeAncestors;
    }

    public Boolean getIncludeDescendants() {
        return this.includeDescendants;
    }

    public Long getCreatedFrom() {
        return this.createdFrom;
    }

    public Long getCreatedTo() {
        return this.createdTo;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="isTaskEnabled")
    public void setIsTaskEnabled(Boolean isTaskEnabled) {
        this.isTaskEnabled = isTaskEnabled;
    }

    @JsonProperty(value="parent")
    public void setParent(String parent) {
        this.parent = parent;
    }

    @JsonProperty(value="projectTypeId")
    public void setProjectTypeId(String projectTypeId) {
        this.projectTypeId = projectTypeId;
    }

    @JsonProperty(value="subProjectTypeId")
    public void setSubProjectTypeId(String subProjectTypeId) {
        this.subProjectTypeId = subProjectTypeId;
    }

    @JsonProperty(value="department")
    public void setDepartment(String department) {
        this.department = department;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="boundaryCode")
    public void setBoundaryCode(String boundaryCode) {
        this.boundaryCode = boundaryCode;
    }

    @JsonProperty(value="includeAncestors")
    public void setIncludeAncestors(Boolean includeAncestors) {
        this.includeAncestors = includeAncestors;
    }

    @JsonProperty(value="includeDescendants")
    public void setIncludeDescendants(Boolean includeDescendants) {
        this.includeDescendants = includeDescendants;
    }

    @JsonProperty(value="createdFrom")
    public void setCreatedFrom(Long createdFrom) {
        this.createdFrom = createdFrom;
    }

    @JsonProperty(value="createdTo")
    public void setCreatedTo(Long createdTo) {
        this.createdTo = createdTo;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectSearch)) {
            return false;
        }
        ProjectSearch other = (ProjectSearch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$startDate = this.getStartDate();
        Long other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Long this$endDate = this.getEndDate();
        Long other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Boolean this$isTaskEnabled = this.getIsTaskEnabled();
        Boolean other$isTaskEnabled = other.getIsTaskEnabled();
        if (this$isTaskEnabled == null ? other$isTaskEnabled != null : !((Object)this$isTaskEnabled).equals(other$isTaskEnabled)) {
            return false;
        }
        Boolean this$includeAncestors = this.getIncludeAncestors();
        Boolean other$includeAncestors = other.getIncludeAncestors();
        if (this$includeAncestors == null ? other$includeAncestors != null : !((Object)this$includeAncestors).equals(other$includeAncestors)) {
            return false;
        }
        Boolean this$includeDescendants = this.getIncludeDescendants();
        Boolean other$includeDescendants = other.getIncludeDescendants();
        if (this$includeDescendants == null ? other$includeDescendants != null : !((Object)this$includeDescendants).equals(other$includeDescendants)) {
            return false;
        }
        Long this$createdFrom = this.getCreatedFrom();
        Long other$createdFrom = other.getCreatedFrom();
        if (this$createdFrom == null ? other$createdFrom != null : !((Object)this$createdFrom).equals(other$createdFrom)) {
            return false;
        }
        Long this$createdTo = this.getCreatedTo();
        Long other$createdTo = other.getCreatedTo();
        if (this$createdTo == null ? other$createdTo != null : !((Object)this$createdTo).equals(other$createdTo)) {
            return false;
        }
        String this$parent = this.getParent();
        String other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        String this$projectTypeId = this.getProjectTypeId();
        String other$projectTypeId = other.getProjectTypeId();
        if (this$projectTypeId == null ? other$projectTypeId != null : !this$projectTypeId.equals(other$projectTypeId)) {
            return false;
        }
        String this$subProjectTypeId = this.getSubProjectTypeId();
        String other$subProjectTypeId = other.getSubProjectTypeId();
        if (this$subProjectTypeId == null ? other$subProjectTypeId != null : !this$subProjectTypeId.equals(other$subProjectTypeId)) {
            return false;
        }
        String this$department = this.getDepartment();
        String other$department = other.getDepartment();
        if (this$department == null ? other$department != null : !this$department.equals(other$department)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        String this$boundaryCode = this.getBoundaryCode();
        String other$boundaryCode = other.getBoundaryCode();
        if (this$boundaryCode == null ? other$boundaryCode != null : !this$boundaryCode.equals(other$boundaryCode)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProjectSearch;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Long $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Boolean $isTaskEnabled = this.getIsTaskEnabled();
        result = result * 59 + ($isTaskEnabled == null ? 43 : ((Object)$isTaskEnabled).hashCode());
        Boolean $includeAncestors = this.getIncludeAncestors();
        result = result * 59 + ($includeAncestors == null ? 43 : ((Object)$includeAncestors).hashCode());
        Boolean $includeDescendants = this.getIncludeDescendants();
        result = result * 59 + ($includeDescendants == null ? 43 : ((Object)$includeDescendants).hashCode());
        Long $createdFrom = this.getCreatedFrom();
        result = result * 59 + ($createdFrom == null ? 43 : ((Object)$createdFrom).hashCode());
        Long $createdTo = this.getCreatedTo();
        result = result * 59 + ($createdTo == null ? 43 : ((Object)$createdTo).hashCode());
        String $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        String $projectTypeId = this.getProjectTypeId();
        result = result * 59 + ($projectTypeId == null ? 43 : $projectTypeId.hashCode());
        String $subProjectTypeId = this.getSubProjectTypeId();
        result = result * 59 + ($subProjectTypeId == null ? 43 : $subProjectTypeId.hashCode());
        String $department = this.getDepartment();
        result = result * 59 + ($department == null ? 43 : $department.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        String $boundaryCode = this.getBoundaryCode();
        result = result * 59 + ($boundaryCode == null ? 43 : $boundaryCode.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ProjectSearch(startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", isTaskEnabled=" + this.getIsTaskEnabled() + ", parent=" + this.getParent() + ", projectTypeId=" + this.getProjectTypeId() + ", subProjectTypeId=" + this.getSubProjectTypeId() + ", department=" + this.getDepartment() + ", referenceId=" + this.getReferenceId() + ", boundaryCode=" + this.getBoundaryCode() + ", includeAncestors=" + this.getIncludeAncestors() + ", includeDescendants=" + this.getIncludeDescendants() + ", createdFrom=" + this.getCreatedFrom() + ", createdTo=" + this.getCreatedTo() + ", name=" + this.getName() + ")";
    }

    public ProjectSearch() {
    }

    public ProjectSearch(Long startDate, Long endDate, Boolean isTaskEnabled, String parent, String projectTypeId, String subProjectTypeId, String department, String referenceId, String boundaryCode, Boolean includeAncestors, Boolean includeDescendants, Long createdFrom, Long createdTo, String name) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.isTaskEnabled = isTaskEnabled;
        this.parent = parent;
        this.projectTypeId = projectTypeId;
        this.subProjectTypeId = subProjectTypeId;
        this.department = department;
        this.referenceId = referenceId;
        this.boundaryCode = boundaryCode;
        this.includeAncestors = includeAncestors;
        this.includeDescendants = includeDescendants;
        this.createdFrom = createdFrom;
        this.createdTo = createdTo;
        this.name = name;
    }

    public static abstract class ProjectSearchBuilder<C extends ProjectSearch, B extends ProjectSearchBuilder<C, B>>
    extends EgovSearchModel.EgovSearchModelBuilder<C, B> {
        private Long startDate;
        private Long endDate;
        private Boolean isTaskEnabled;
        private String parent;
        private String projectTypeId;
        private String subProjectTypeId;
        private String department;
        private String referenceId;
        private String boundaryCode;
        private Boolean includeAncestors;
        private Boolean includeDescendants;
        private Long createdFrom;
        private Long createdTo;
        private String name;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="startDate")
        public B startDate(Long startDate) {
            this.startDate = startDate;
            return (B)this.self();
        }

        @JsonProperty(value="endDate")
        public B endDate(Long endDate) {
            this.endDate = endDate;
            return (B)this.self();
        }

        @JsonProperty(value="isTaskEnabled")
        public B isTaskEnabled(Boolean isTaskEnabled) {
            this.isTaskEnabled = isTaskEnabled;
            return (B)this.self();
        }

        @JsonProperty(value="parent")
        public B parent(String parent) {
            this.parent = parent;
            return (B)this.self();
        }

        @JsonProperty(value="projectTypeId")
        public B projectTypeId(String projectTypeId) {
            this.projectTypeId = projectTypeId;
            return (B)this.self();
        }

        @JsonProperty(value="subProjectTypeId")
        public B subProjectTypeId(String subProjectTypeId) {
            this.subProjectTypeId = subProjectTypeId;
            return (B)this.self();
        }

        @JsonProperty(value="department")
        public B department(String department) {
            this.department = department;
            return (B)this.self();
        }

        @JsonProperty(value="referenceId")
        public B referenceId(String referenceId) {
            this.referenceId = referenceId;
            return (B)this.self();
        }

        @JsonProperty(value="boundaryCode")
        public B boundaryCode(String boundaryCode) {
            this.boundaryCode = boundaryCode;
            return (B)this.self();
        }

        @JsonProperty(value="includeAncestors")
        public B includeAncestors(Boolean includeAncestors) {
            this.includeAncestors = includeAncestors;
            return (B)this.self();
        }

        @JsonProperty(value="includeDescendants")
        public B includeDescendants(Boolean includeDescendants) {
            this.includeDescendants = includeDescendants;
            return (B)this.self();
        }

        @JsonProperty(value="createdFrom")
        public B createdFrom(Long createdFrom) {
            this.createdFrom = createdFrom;
            return (B)this.self();
        }

        @JsonProperty(value="createdTo")
        public B createdTo(Long createdTo) {
            this.createdTo = createdTo;
            return (B)this.self();
        }

        @JsonProperty(value="name")
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ProjectSearch.ProjectSearchBuilder(super=" + super.toString() + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", isTaskEnabled=" + this.isTaskEnabled + ", parent=" + this.parent + ", projectTypeId=" + this.projectTypeId + ", subProjectTypeId=" + this.subProjectTypeId + ", department=" + this.department + ", referenceId=" + this.referenceId + ", boundaryCode=" + this.boundaryCode + ", includeAncestors=" + this.includeAncestors + ", includeDescendants=" + this.includeDescendants + ", createdFrom=" + this.createdFrom + ", createdTo=" + this.createdTo + ", name=" + this.name + ")";
        }
    }

    private static final class ProjectSearchBuilderImpl
    extends ProjectSearchBuilder<ProjectSearch, ProjectSearchBuilderImpl> {
        private ProjectSearchBuilderImpl() {
        }

        @Override
        protected ProjectSearchBuilderImpl self() {
            return this;
        }

        @Override
        public ProjectSearch build() {
            return new ProjectSearch(this);
        }
    }
}

