/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.individual;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.individual.Individual;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class IndividualBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Individuals")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<Individual> individuals = new ArrayList<Individual>();

    public IndividualBulkRequest addIndividualItem(Individual individualItem) {
        this.individuals.add(individualItem);
        return this;
    }

    public static IndividualBulkRequestBuilder builder() {
        return new IndividualBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Individual> getIndividuals() {
        return this.individuals;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Individuals")
    public void setIndividuals(List<Individual> individuals) {
        this.individuals = individuals;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndividualBulkRequest)) {
            return false;
        }
        IndividualBulkRequest other = (IndividualBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<Individual> this$individuals = this.getIndividuals();
        List<Individual> other$individuals = other.getIndividuals();
        return !(this$individuals == null ? other$individuals != null : !((Object)this$individuals).equals(other$individuals));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndividualBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<Individual> $individuals = this.getIndividuals();
        result = result * 59 + ($individuals == null ? 43 : ((Object)$individuals).hashCode());
        return result;
    }

    public String toString() {
        return "IndividualBulkRequest(requestInfo=" + this.getRequestInfo() + ", individuals=" + this.getIndividuals() + ")";
    }

    public IndividualBulkRequest() {
    }

    public IndividualBulkRequest(RequestInfo requestInfo, List<Individual> individuals) {
        this.requestInfo = requestInfo;
        this.individuals = individuals;
    }

    public static class IndividualBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<Individual> individuals;

        IndividualBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public IndividualBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Individuals")
        public IndividualBulkRequestBuilder individuals(List<Individual> individuals) {
            this.individuals = individuals;
            return this;
        }

        public IndividualBulkRequest build() {
            return new IndividualBulkRequest(this.requestInfo, this.individuals);
        }

        public String toString() {
            return "IndividualBulkRequest.IndividualBulkRequestBuilder(requestInfo=" + this.requestInfo + ", individuals=" + this.individuals + ")";
        }
    }
}

