/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.models.core.EgovOfflineModel;
import org.egov.common.models.household.Relationship;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A representation of a household member (already registered as an individual)")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class HouseholdMember
extends EgovOfflineModel {
    @JsonProperty(value="householdId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String householdId = null;
    @JsonProperty(value="householdClientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String householdClientReferenceId = null;
    @JsonProperty(value="individualId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String individualId = null;
    @JsonProperty(value="individualClientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String individualClientReferenceId = null;
    @JsonProperty(value="isHeadOfHousehold")
    private Boolean isHeadOfHousehold = false;
    @JsonProperty(value="memberRelationships")
    @Valid
    private List<Relationship> memberRelationships;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;

    public HouseholdMember addHouseholdMemberRelationship(Relationship relationship) {
        if (this.memberRelationships == null) {
            this.memberRelationships = new ArrayList<Relationship>();
        }
        relationship.setSelfId(this.getId());
        relationship.setSelfClientReferenceId(this.getClientReferenceId());
        this.memberRelationships.add(relationship);
        return this;
    }

    protected HouseholdMember(HouseholdMemberBuilder<?, ?> b) {
        super((EgovOfflineModel.EgovOfflineModelBuilder<?, ?>)b);
        this.householdId = b.householdId;
        this.householdClientReferenceId = b.householdClientReferenceId;
        this.individualId = b.individualId;
        this.individualClientReferenceId = b.individualClientReferenceId;
        this.isHeadOfHousehold = b.isHeadOfHousehold;
        this.memberRelationships = b.memberRelationships;
        this.isDeleted = b.isDeleted;
    }

    public static HouseholdMemberBuilder<?, ?> builder() {
        return new HouseholdMemberBuilderImpl();
    }

    public String getHouseholdId() {
        return this.householdId;
    }

    public String getHouseholdClientReferenceId() {
        return this.householdClientReferenceId;
    }

    public String getIndividualId() {
        return this.individualId;
    }

    public String getIndividualClientReferenceId() {
        return this.individualClientReferenceId;
    }

    public Boolean getIsHeadOfHousehold() {
        return this.isHeadOfHousehold;
    }

    public List<Relationship> getMemberRelationships() {
        return this.memberRelationships;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @JsonProperty(value="householdId")
    public void setHouseholdId(String householdId) {
        this.householdId = householdId;
    }

    @JsonProperty(value="householdClientReferenceId")
    public void setHouseholdClientReferenceId(String householdClientReferenceId) {
        this.householdClientReferenceId = householdClientReferenceId;
    }

    @JsonProperty(value="individualId")
    public void setIndividualId(String individualId) {
        this.individualId = individualId;
    }

    @JsonProperty(value="individualClientReferenceId")
    public void setIndividualClientReferenceId(String individualClientReferenceId) {
        this.individualClientReferenceId = individualClientReferenceId;
    }

    @JsonProperty(value="isHeadOfHousehold")
    public void setIsHeadOfHousehold(Boolean isHeadOfHousehold) {
        this.isHeadOfHousehold = isHeadOfHousehold;
    }

    @JsonProperty(value="memberRelationships")
    public void setMemberRelationships(List<Relationship> memberRelationships) {
        this.memberRelationships = memberRelationships;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholdMember)) {
            return false;
        }
        HouseholdMember other = (HouseholdMember)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isHeadOfHousehold = this.getIsHeadOfHousehold();
        Boolean other$isHeadOfHousehold = other.getIsHeadOfHousehold();
        if (this$isHeadOfHousehold == null ? other$isHeadOfHousehold != null : !((Object)this$isHeadOfHousehold).equals(other$isHeadOfHousehold)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$householdId = this.getHouseholdId();
        String other$householdId = other.getHouseholdId();
        if (this$householdId == null ? other$householdId != null : !this$householdId.equals(other$householdId)) {
            return false;
        }
        String this$householdClientReferenceId = this.getHouseholdClientReferenceId();
        String other$householdClientReferenceId = other.getHouseholdClientReferenceId();
        if (this$householdClientReferenceId == null ? other$householdClientReferenceId != null : !this$householdClientReferenceId.equals(other$householdClientReferenceId)) {
            return false;
        }
        String this$individualId = this.getIndividualId();
        String other$individualId = other.getIndividualId();
        if (this$individualId == null ? other$individualId != null : !this$individualId.equals(other$individualId)) {
            return false;
        }
        String this$individualClientReferenceId = this.getIndividualClientReferenceId();
        String other$individualClientReferenceId = other.getIndividualClientReferenceId();
        if (this$individualClientReferenceId == null ? other$individualClientReferenceId != null : !this$individualClientReferenceId.equals(other$individualClientReferenceId)) {
            return false;
        }
        List<Relationship> this$memberRelationships = this.getMemberRelationships();
        List<Relationship> other$memberRelationships = other.getMemberRelationships();
        return !(this$memberRelationships == null ? other$memberRelationships != null : !((Object)this$memberRelationships).equals(other$memberRelationships));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HouseholdMember;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isHeadOfHousehold = this.getIsHeadOfHousehold();
        result = result * 59 + ($isHeadOfHousehold == null ? 43 : ((Object)$isHeadOfHousehold).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $householdId = this.getHouseholdId();
        result = result * 59 + ($householdId == null ? 43 : $householdId.hashCode());
        String $householdClientReferenceId = this.getHouseholdClientReferenceId();
        result = result * 59 + ($householdClientReferenceId == null ? 43 : $householdClientReferenceId.hashCode());
        String $individualId = this.getIndividualId();
        result = result * 59 + ($individualId == null ? 43 : $individualId.hashCode());
        String $individualClientReferenceId = this.getIndividualClientReferenceId();
        result = result * 59 + ($individualClientReferenceId == null ? 43 : $individualClientReferenceId.hashCode());
        List<Relationship> $memberRelationships = this.getMemberRelationships();
        result = result * 59 + ($memberRelationships == null ? 43 : ((Object)$memberRelationships).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "HouseholdMember(householdId=" + this.getHouseholdId() + ", householdClientReferenceId=" + this.getHouseholdClientReferenceId() + ", individualId=" + this.getIndividualId() + ", individualClientReferenceId=" + this.getIndividualClientReferenceId() + ", isHeadOfHousehold=" + this.getIsHeadOfHousehold() + ", memberRelationships=" + this.getMemberRelationships() + ", isDeleted=" + this.getIsDeleted() + ")";
    }

    public HouseholdMember() {
    }

    public HouseholdMember(String householdId, String householdClientReferenceId, String individualId, String individualClientReferenceId, Boolean isHeadOfHousehold, List<Relationship> memberRelationships, Boolean isDeleted) {
        this.householdId = householdId;
        this.householdClientReferenceId = householdClientReferenceId;
        this.individualId = individualId;
        this.individualClientReferenceId = individualClientReferenceId;
        this.isHeadOfHousehold = isHeadOfHousehold;
        this.memberRelationships = memberRelationships;
        this.isDeleted = isDeleted;
    }

    public static abstract class HouseholdMemberBuilder<C extends HouseholdMember, B extends HouseholdMemberBuilder<C, B>>
    extends EgovOfflineModel.EgovOfflineModelBuilder<C, B> {
        private String householdId;
        private String householdClientReferenceId;
        private String individualId;
        private String individualClientReferenceId;
        private Boolean isHeadOfHousehold;
        private List<Relationship> memberRelationships;
        private Boolean isDeleted;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="householdId")
        public B householdId(String householdId) {
            this.householdId = householdId;
            return (B)this.self();
        }

        @JsonProperty(value="householdClientReferenceId")
        public B householdClientReferenceId(String householdClientReferenceId) {
            this.householdClientReferenceId = householdClientReferenceId;
            return (B)this.self();
        }

        @JsonProperty(value="individualId")
        public B individualId(String individualId) {
            this.individualId = individualId;
            return (B)this.self();
        }

        @JsonProperty(value="individualClientReferenceId")
        public B individualClientReferenceId(String individualClientReferenceId) {
            this.individualClientReferenceId = individualClientReferenceId;
            return (B)this.self();
        }

        @JsonProperty(value="isHeadOfHousehold")
        public B isHeadOfHousehold(Boolean isHeadOfHousehold) {
            this.isHeadOfHousehold = isHeadOfHousehold;
            return (B)this.self();
        }

        @JsonProperty(value="memberRelationships")
        public B memberRelationships(List<Relationship> memberRelationships) {
            this.memberRelationships = memberRelationships;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HouseholdMember.HouseholdMemberBuilder(super=" + super.toString() + ", householdId=" + this.householdId + ", householdClientReferenceId=" + this.householdClientReferenceId + ", individualId=" + this.individualId + ", individualClientReferenceId=" + this.individualClientReferenceId + ", isHeadOfHousehold=" + this.isHeadOfHousehold + ", memberRelationships=" + this.memberRelationships + ", isDeleted=" + this.isDeleted + ")";
        }
    }

    private static final class HouseholdMemberBuilderImpl
    extends HouseholdMemberBuilder<HouseholdMember, HouseholdMemberBuilderImpl> {
        private HouseholdMemberBuilderImpl() {
        }

        @Override
        protected HouseholdMemberBuilderImpl self() {
            return this;
        }

        @Override
        public HouseholdMember build() {
            return new HouseholdMember(this);
        }
    }
}

