/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.stock.StockReconciliation;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class StockReconciliationBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="StockReconciliation")
    @NotNull
    @Valid
    private List<StockReconciliation> stockReconciliation = new ArrayList<StockReconciliation>();
    @JsonProperty(value="TotalCount")
    @Valid
    private Long totalCount;

    public StockReconciliationBulkResponse addStockReconciliationItem(StockReconciliation stockReconciliationItem) {
        this.stockReconciliation.add(stockReconciliationItem);
        return this;
    }

    private static Long $default$totalCount() {
        return 0L;
    }

    public static StockReconciliationBulkResponseBuilder builder() {
        return new StockReconciliationBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<StockReconciliation> getStockReconciliation() {
        return this.stockReconciliation;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="StockReconciliation")
    public void setStockReconciliation(List<StockReconciliation> stockReconciliation) {
        this.stockReconciliation = stockReconciliation;
    }

    @JsonProperty(value="TotalCount")
    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StockReconciliationBulkResponse)) {
            return false;
        }
        StockReconciliationBulkResponse other = (StockReconciliationBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<StockReconciliation> this$stockReconciliation = this.getStockReconciliation();
        List<StockReconciliation> other$stockReconciliation = other.getStockReconciliation();
        return !(this$stockReconciliation == null ? other$stockReconciliation != null : !((Object)this$stockReconciliation).equals(other$stockReconciliation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StockReconciliationBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<StockReconciliation> $stockReconciliation = this.getStockReconciliation();
        result = result * 59 + ($stockReconciliation == null ? 43 : ((Object)$stockReconciliation).hashCode());
        return result;
    }

    public String toString() {
        return "StockReconciliationBulkResponse(responseInfo=" + this.getResponseInfo() + ", stockReconciliation=" + this.getStockReconciliation() + ", totalCount=" + this.getTotalCount() + ")";
    }

    public StockReconciliationBulkResponse() {
        this.totalCount = StockReconciliationBulkResponse.$default$totalCount();
    }

    public StockReconciliationBulkResponse(ResponseInfo responseInfo, List<StockReconciliation> stockReconciliation, Long totalCount) {
        this.responseInfo = responseInfo;
        this.stockReconciliation = stockReconciliation;
        this.totalCount = totalCount;
    }

    public static class StockReconciliationBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<StockReconciliation> stockReconciliation;
        private boolean totalCount$set;
        private Long totalCount$value;

        StockReconciliationBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public StockReconciliationBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="StockReconciliation")
        public StockReconciliationBulkResponseBuilder stockReconciliation(List<StockReconciliation> stockReconciliation) {
            this.stockReconciliation = stockReconciliation;
            return this;
        }

        @JsonProperty(value="TotalCount")
        public StockReconciliationBulkResponseBuilder totalCount(Long totalCount) {
            this.totalCount$value = totalCount;
            this.totalCount$set = true;
            return this;
        }

        public StockReconciliationBulkResponse build() {
            Long totalCount$value = this.totalCount$value;
            if (!this.totalCount$set) {
                totalCount$value = StockReconciliationBulkResponse.$default$totalCount();
            }
            return new StockReconciliationBulkResponse(this.responseInfo, this.stockReconciliation, totalCount$value);
        }

        public String toString() {
            return "StockReconciliationBulkResponse.StockReconciliationBulkResponseBuilder(responseInfo=" + this.responseInfo + ", stockReconciliation=" + this.stockReconciliation + ", totalCount$value=" + this.totalCount$value + ")";
        }
    }
}

