/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.idgen;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.idgen.IdRecord;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class IdRecordBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="IdRecords")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<IdRecord> idRecords = new ArrayList<IdRecord>();

    public IdRecordBulkRequest addIdRecordItem(IdRecord idRecord) {
        this.idRecords.add(idRecord);
        return this;
    }

    public static IdRecordBulkRequestBuilder builder() {
        return new IdRecordBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<IdRecord> getIdRecords() {
        return this.idRecords;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="IdRecords")
    public void setIdRecords(List<IdRecord> idRecords) {
        this.idRecords = idRecords;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdRecordBulkRequest)) {
            return false;
        }
        IdRecordBulkRequest other = (IdRecordBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<IdRecord> this$idRecords = this.getIdRecords();
        List<IdRecord> other$idRecords = other.getIdRecords();
        return !(this$idRecords == null ? other$idRecords != null : !((Object)this$idRecords).equals(other$idRecords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IdRecordBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<IdRecord> $idRecords = this.getIdRecords();
        result = result * 59 + ($idRecords == null ? 43 : ((Object)$idRecords).hashCode());
        return result;
    }

    public String toString() {
        return "IdRecordBulkRequest(requestInfo=" + this.getRequestInfo() + ", idRecords=" + this.getIdRecords() + ")";
    }

    public IdRecordBulkRequest() {
    }

    public IdRecordBulkRequest(RequestInfo requestInfo, List<IdRecord> idRecords) {
        this.requestInfo = requestInfo;
        this.idRecords = idRecords;
    }

    public static class IdRecordBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<IdRecord> idRecords;

        IdRecordBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public IdRecordBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="IdRecords")
        public IdRecordBulkRequestBuilder idRecords(List<IdRecord> idRecords) {
            this.idRecords = idRecords;
            return this;
        }

        public IdRecordBulkRequest build() {
            return new IdRecordBulkRequest(this.requestInfo, this.idRecords);
        }

        public String toString() {
            return "IdRecordBulkRequest.IdRecordBulkRequestBuilder(requestInfo=" + this.requestInfo + ", idRecords=" + this.idRecords + ")";
        }
    }
}

