/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.stock.Stock;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class StockRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Stock")
    @NotNull
    @Valid
    private Stock stock = null;

    public static StockRequestBuilder builder() {
        return new StockRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public Stock getStock() {
        return this.stock;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Stock")
    public void setStock(Stock stock) {
        this.stock = stock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StockRequest)) {
            return false;
        }
        StockRequest other = (StockRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        Stock this$stock = this.getStock();
        Stock other$stock = other.getStock();
        return !(this$stock == null ? other$stock != null : !((Object)this$stock).equals(other$stock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StockRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        Stock $stock = this.getStock();
        result = result * 59 + ($stock == null ? 43 : ((Object)$stock).hashCode());
        return result;
    }

    public String toString() {
        return "StockRequest(requestInfo=" + this.getRequestInfo() + ", stock=" + this.getStock() + ")";
    }

    public StockRequest() {
    }

    public StockRequest(RequestInfo requestInfo, Stock stock) {
        this.requestInfo = requestInfo;
        this.stock = stock;
    }

    public static class StockRequestBuilder {
        private RequestInfo requestInfo;
        private Stock stock;

        StockRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public StockRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Stock")
        public StockRequestBuilder stock(Stock stock) {
            this.stock = stock;
            return this;
        }

        public StockRequest build() {
            return new StockRequest(this.requestInfo, this.stock);
        }

        public String toString() {
            return "StockRequest.StockRequestBuilder(requestInfo=" + this.requestInfo + ", stock=" + this.stock + ")";
        }
    }
}

