/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.household.HouseholdMemberSearch;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class HouseholdMemberSearchRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="HouseholdMember")
    @NotNull
    @Valid
    private HouseholdMemberSearch householdMemberSearch = null;

    public static HouseholdMemberSearchRequestBuilder builder() {
        return new HouseholdMemberSearchRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public HouseholdMemberSearch getHouseholdMemberSearch() {
        return this.householdMemberSearch;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="HouseholdMember")
    public void setHouseholdMemberSearch(HouseholdMemberSearch householdMemberSearch) {
        this.householdMemberSearch = householdMemberSearch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholdMemberSearchRequest)) {
            return false;
        }
        HouseholdMemberSearchRequest other = (HouseholdMemberSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        HouseholdMemberSearch this$householdMemberSearch = this.getHouseholdMemberSearch();
        HouseholdMemberSearch other$householdMemberSearch = other.getHouseholdMemberSearch();
        return !(this$householdMemberSearch == null ? other$householdMemberSearch != null : !((Object)this$householdMemberSearch).equals(other$householdMemberSearch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HouseholdMemberSearchRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        HouseholdMemberSearch $householdMemberSearch = this.getHouseholdMemberSearch();
        result = result * 59 + ($householdMemberSearch == null ? 43 : ((Object)$householdMemberSearch).hashCode());
        return result;
    }

    public String toString() {
        return "HouseholdMemberSearchRequest(requestInfo=" + this.getRequestInfo() + ", householdMemberSearch=" + this.getHouseholdMemberSearch() + ")";
    }

    public HouseholdMemberSearchRequest() {
    }

    public HouseholdMemberSearchRequest(RequestInfo requestInfo, HouseholdMemberSearch householdMemberSearch) {
        this.requestInfo = requestInfo;
        this.householdMemberSearch = householdMemberSearch;
    }

    public static class HouseholdMemberSearchRequestBuilder {
        private RequestInfo requestInfo;
        private HouseholdMemberSearch householdMemberSearch;

        HouseholdMemberSearchRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public HouseholdMemberSearchRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="HouseholdMember")
        public HouseholdMemberSearchRequestBuilder householdMemberSearch(HouseholdMemberSearch householdMemberSearch) {
            this.householdMemberSearch = householdMemberSearch;
            return this;
        }

        public HouseholdMemberSearchRequest build() {
            return new HouseholdMemberSearchRequest(this.requestInfo, this.householdMemberSearch);
        }

        public String toString() {
            return "HouseholdMemberSearchRequest.HouseholdMemberSearchRequestBuilder(requestInfo=" + this.requestInfo + ", householdMemberSearch=" + this.householdMemberSearch + ")";
        }
    }
}

