/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.project.ProjectFacility;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectFacilityBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="ProjectFacilities")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<ProjectFacility> projectFacilities = new ArrayList<ProjectFacility>();

    public ProjectFacilityBulkRequest addProjectFacilityItem(ProjectFacility projectFacilityItem) {
        this.projectFacilities.add(projectFacilityItem);
        return this;
    }

    public static ProjectFacilityBulkRequestBuilder builder() {
        return new ProjectFacilityBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<ProjectFacility> getProjectFacilities() {
        return this.projectFacilities;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="ProjectFacilities")
    public void setProjectFacilities(List<ProjectFacility> projectFacilities) {
        this.projectFacilities = projectFacilities;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectFacilityBulkRequest)) {
            return false;
        }
        ProjectFacilityBulkRequest other = (ProjectFacilityBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<ProjectFacility> this$projectFacilities = this.getProjectFacilities();
        List<ProjectFacility> other$projectFacilities = other.getProjectFacilities();
        return !(this$projectFacilities == null ? other$projectFacilities != null : !((Object)this$projectFacilities).equals(other$projectFacilities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectFacilityBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<ProjectFacility> $projectFacilities = this.getProjectFacilities();
        result = result * 59 + ($projectFacilities == null ? 43 : ((Object)$projectFacilities).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectFacilityBulkRequest(requestInfo=" + this.getRequestInfo() + ", projectFacilities=" + this.getProjectFacilities() + ")";
    }

    public ProjectFacilityBulkRequest() {
    }

    public ProjectFacilityBulkRequest(RequestInfo requestInfo, List<ProjectFacility> projectFacilities) {
        this.requestInfo = requestInfo;
        this.projectFacilities = projectFacilities;
    }

    public static class ProjectFacilityBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<ProjectFacility> projectFacilities;

        ProjectFacilityBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ProjectFacilityBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="ProjectFacilities")
        public ProjectFacilityBulkRequestBuilder projectFacilities(List<ProjectFacility> projectFacilities) {
            this.projectFacilities = projectFacilities;
            return this;
        }

        public ProjectFacilityBulkRequest build() {
            return new ProjectFacilityBulkRequest(this.requestInfo, this.projectFacilities);
        }

        public String toString() {
            return "ProjectFacilityBulkRequest.ProjectFacilityBulkRequestBuilder(requestInfo=" + this.requestInfo + ", projectFacilities=" + this.projectFacilities + ")";
        }
    }
}

