/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.referralmanagement.hfreferral;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.referralmanagement.hfreferral.HFReferral;

public class HFReferralBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo;
    @JsonProperty(value="HFReferrals")
    @NotNull
    @Valid
    private List<HFReferral> hfReferrals;
    @JsonProperty(value="TotalCount")
    @Valid
    private Long totalCount;

    public HFReferralBulkResponse addReferralItem(HFReferral hfReferralItem) {
        if (Objects.isNull(this.hfReferrals)) {
            this.hfReferrals = new ArrayList<HFReferral>();
        }
        if (Objects.nonNull(hfReferralItem)) {
            this.hfReferrals.add(hfReferralItem);
        }
        return this;
    }

    private static Long $default$totalCount() {
        return 0L;
    }

    public static HFReferralBulkResponseBuilder builder() {
        return new HFReferralBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<HFReferral> getHfReferrals() {
        return this.hfReferrals;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="HFReferrals")
    public void setHfReferrals(List<HFReferral> hfReferrals) {
        this.hfReferrals = hfReferrals;
    }

    @JsonProperty(value="TotalCount")
    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HFReferralBulkResponse)) {
            return false;
        }
        HFReferralBulkResponse other = (HFReferralBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<HFReferral> this$hfReferrals = this.getHfReferrals();
        List<HFReferral> other$hfReferrals = other.getHfReferrals();
        return !(this$hfReferrals == null ? other$hfReferrals != null : !((Object)this$hfReferrals).equals(other$hfReferrals));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HFReferralBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<HFReferral> $hfReferrals = this.getHfReferrals();
        result = result * 59 + ($hfReferrals == null ? 43 : ((Object)$hfReferrals).hashCode());
        return result;
    }

    public String toString() {
        return "HFReferralBulkResponse(responseInfo=" + this.getResponseInfo() + ", hfReferrals=" + this.getHfReferrals() + ", totalCount=" + this.getTotalCount() + ")";
    }

    public HFReferralBulkResponse() {
        this.totalCount = HFReferralBulkResponse.$default$totalCount();
    }

    public HFReferralBulkResponse(ResponseInfo responseInfo, List<HFReferral> hfReferrals, Long totalCount) {
        this.responseInfo = responseInfo;
        this.hfReferrals = hfReferrals;
        this.totalCount = totalCount;
    }

    public static class HFReferralBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<HFReferral> hfReferrals;
        private boolean totalCount$set;
        private Long totalCount$value;

        HFReferralBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public HFReferralBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="HFReferrals")
        public HFReferralBulkResponseBuilder hfReferrals(List<HFReferral> hfReferrals) {
            this.hfReferrals = hfReferrals;
            return this;
        }

        @JsonProperty(value="TotalCount")
        public HFReferralBulkResponseBuilder totalCount(Long totalCount) {
            this.totalCount$value = totalCount;
            this.totalCount$set = true;
            return this;
        }

        public HFReferralBulkResponse build() {
            Long totalCount$value = this.totalCount$value;
            if (!this.totalCount$set) {
                totalCount$value = HFReferralBulkResponse.$default$totalCount();
            }
            return new HFReferralBulkResponse(this.responseInfo, this.hfReferrals, totalCount$value);
        }

        public String toString() {
            return "HFReferralBulkResponse.HFReferralBulkResponseBuilder(responseInfo=" + this.responseInfo + ", hfReferrals=" + this.hfReferrals + ", totalCount$value=" + this.totalCount$value + ")";
        }
    }
}

