/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.household.HouseholdSearch;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class HouseholdSearchRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Household")
    @NotNull
    @Valid
    private HouseholdSearch household = null;

    public static HouseholdSearchRequestBuilder builder() {
        return new HouseholdSearchRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public HouseholdSearch getHousehold() {
        return this.household;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Household")
    public void setHousehold(HouseholdSearch household) {
        this.household = household;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholdSearchRequest)) {
            return false;
        }
        HouseholdSearchRequest other = (HouseholdSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        HouseholdSearch this$household = this.getHousehold();
        HouseholdSearch other$household = other.getHousehold();
        return !(this$household == null ? other$household != null : !((Object)this$household).equals(other$household));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HouseholdSearchRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        HouseholdSearch $household = this.getHousehold();
        result = result * 59 + ($household == null ? 43 : ((Object)$household).hashCode());
        return result;
    }

    public String toString() {
        return "HouseholdSearchRequest(requestInfo=" + this.getRequestInfo() + ", household=" + this.getHousehold() + ")";
    }

    public HouseholdSearchRequest() {
    }

    public HouseholdSearchRequest(RequestInfo requestInfo, HouseholdSearch household) {
        this.requestInfo = requestInfo;
        this.household = household;
    }

    public static class HouseholdSearchRequestBuilder {
        private RequestInfo requestInfo;
        private HouseholdSearch household;

        HouseholdSearchRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public HouseholdSearchRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Household")
        public HouseholdSearchRequestBuilder household(HouseholdSearch household) {
            this.household = household;
            return this;
        }

        public HouseholdSearchRequest build() {
            return new HouseholdSearchRequest(this.requestInfo, this.household);
        }

        public String toString() {
            return "HouseholdSearchRequest.HouseholdSearchRequestBuilder(requestInfo=" + this.requestInfo + ", household=" + this.household + ")";
        }
    }
}

