/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.project.ProjectStaff;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectStaffBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="ProjectStaff")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<ProjectStaff> projectStaff = new ArrayList<ProjectStaff>();

    public ProjectStaffBulkRequest addProjectStaffItem(ProjectStaff projectStaffItem) {
        this.projectStaff.add(projectStaffItem);
        return this;
    }

    public static ProjectStaffBulkRequestBuilder builder() {
        return new ProjectStaffBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<ProjectStaff> getProjectStaff() {
        return this.projectStaff;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="ProjectStaff")
    public void setProjectStaff(List<ProjectStaff> projectStaff) {
        this.projectStaff = projectStaff;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectStaffBulkRequest)) {
            return false;
        }
        ProjectStaffBulkRequest other = (ProjectStaffBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<ProjectStaff> this$projectStaff = this.getProjectStaff();
        List<ProjectStaff> other$projectStaff = other.getProjectStaff();
        return !(this$projectStaff == null ? other$projectStaff != null : !((Object)this$projectStaff).equals(other$projectStaff));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectStaffBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<ProjectStaff> $projectStaff = this.getProjectStaff();
        result = result * 59 + ($projectStaff == null ? 43 : ((Object)$projectStaff).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectStaffBulkRequest(requestInfo=" + this.getRequestInfo() + ", projectStaff=" + this.getProjectStaff() + ")";
    }

    public ProjectStaffBulkRequest() {
    }

    public ProjectStaffBulkRequest(RequestInfo requestInfo, List<ProjectStaff> projectStaff) {
        this.requestInfo = requestInfo;
        this.projectStaff = projectStaff;
    }

    public static class ProjectStaffBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<ProjectStaff> projectStaff;

        ProjectStaffBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ProjectStaffBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="ProjectStaff")
        public ProjectStaffBulkRequestBuilder projectStaff(List<ProjectStaff> projectStaff) {
            this.projectStaff = projectStaff;
            return this;
        }

        public ProjectStaffBulkRequest build() {
            return new ProjectStaffBulkRequest(this.requestInfo, this.projectStaff);
        }

        public String toString() {
            return "ProjectStaffBulkRequest.ProjectStaffBulkRequestBuilder(requestInfo=" + this.requestInfo + ", projectStaff=" + this.projectStaff + ")";
        }
    }
}

