/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.egov.common.models.core.EgovOfflineModel;
import org.egov.common.models.stock.ReferenceIdType;
import org.egov.common.models.stock.SenderReceiverType;
import org.egov.common.models.stock.TransactionReason;
import org.egov.common.models.stock.TransactionType;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Stock
extends EgovOfflineModel {
    @JsonProperty(value="productVariantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String productVariantId;
    @JsonProperty(value="quantity")
    @NotNull
    @Min(value=0L, message="Minimum value cannot be less than 0")
    @Max(value=0x7FFFFFFFL, message="Value exceeds maximum allowable limit")
    private @NotNull @Min(value=0L, message="Minimum value cannot be less than 0") @Max(value=0x7FFFFFFFL, message="Value exceeds maximum allowable limit") Integer quantity;
    @JsonProperty(value="referenceId")
    private String referenceId;
    @JsonProperty(value="referenceIdType")
    @NotNull(message="referenceIdType must be PROJECT or OTHER")
    @Valid
    private @NotNull(message="referenceIdType must be PROJECT or OTHER") @Valid ReferenceIdType referenceIdType;
    @JsonProperty(value="transactionType")
    @NotNull(message="transactionType must be either RECEIVED or DISPATCHED")
    @Valid
    private @NotNull(message="transactionType must be either RECEIVED or DISPATCHED") @Valid TransactionType transactionType;
    @JsonProperty(value="transactionReason")
    @Valid
    private TransactionReason transactionReason;
    @JsonProperty(value="senderId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String senderId;
    @JsonProperty(value="senderType")
    @NotNull(message="Sender Type can be either WAREHOUSE or STAFF")
    @Valid
    private @NotNull(message="Sender Type can be either WAREHOUSE or STAFF") @Valid SenderReceiverType senderType;
    @JsonProperty(value="receiverId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String receiverId;
    @JsonProperty(value="receiverType")
    @NotNull(message="Receiver Type can be either WAREHOUSE or STAFF")
    @Valid
    private @NotNull(message="Receiver Type can be either WAREHOUSE or STAFF") @Valid SenderReceiverType receiverType;
    @JsonProperty(value="wayBillNumber")
    @Size(min=2, max=200)
    private @Size(min=2, max=200) String wayBillNumber;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted;
    @JsonProperty(value="dateOfEntry")
    private Long dateOfEntry;

    private static Boolean $default$isDeleted() {
        return Boolean.FALSE;
    }

    protected Stock(StockBuilder<?, ?> b) {
        super((EgovOfflineModel.EgovOfflineModelBuilder<?, ?>)b);
        this.productVariantId = b.productVariantId;
        this.quantity = b.quantity;
        this.referenceId = b.referenceId;
        this.referenceIdType = b.referenceIdType;
        this.transactionType = b.transactionType;
        this.transactionReason = b.transactionReason;
        this.senderId = b.senderId;
        this.senderType = b.senderType;
        this.receiverId = b.receiverId;
        this.receiverType = b.receiverType;
        this.wayBillNumber = b.wayBillNumber;
        this.isDeleted = b.isDeleted$set ? b.isDeleted$value : Stock.$default$isDeleted();
        this.dateOfEntry = b.dateOfEntry;
    }

    public static StockBuilder<?, ?> builder() {
        return new StockBuilderImpl();
    }

    public String getProductVariantId() {
        return this.productVariantId;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public ReferenceIdType getReferenceIdType() {
        return this.referenceIdType;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public TransactionReason getTransactionReason() {
        return this.transactionReason;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public SenderReceiverType getSenderType() {
        return this.senderType;
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public SenderReceiverType getReceiverType() {
        return this.receiverType;
    }

    public String getWayBillNumber() {
        return this.wayBillNumber;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Long getDateOfEntry() {
        return this.dateOfEntry;
    }

    @JsonProperty(value="productVariantId")
    public void setProductVariantId(String productVariantId) {
        this.productVariantId = productVariantId;
    }

    @JsonProperty(value="quantity")
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="referenceIdType")
    public void setReferenceIdType(ReferenceIdType referenceIdType) {
        this.referenceIdType = referenceIdType;
    }

    @JsonProperty(value="transactionType")
    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    @JsonProperty(value="transactionReason")
    public void setTransactionReason(TransactionReason transactionReason) {
        this.transactionReason = transactionReason;
    }

    @JsonProperty(value="senderId")
    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    @JsonProperty(value="senderType")
    public void setSenderType(SenderReceiverType senderType) {
        this.senderType = senderType;
    }

    @JsonProperty(value="receiverId")
    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
    }

    @JsonProperty(value="receiverType")
    public void setReceiverType(SenderReceiverType receiverType) {
        this.receiverType = receiverType;
    }

    @JsonProperty(value="wayBillNumber")
    public void setWayBillNumber(String wayBillNumber) {
        this.wayBillNumber = wayBillNumber;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="dateOfEntry")
    public void setDateOfEntry(Long dateOfEntry) {
        this.dateOfEntry = dateOfEntry;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Stock)) {
            return false;
        }
        Stock other = (Stock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$quantity = this.getQuantity();
        Integer other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Long this$dateOfEntry = this.getDateOfEntry();
        Long other$dateOfEntry = other.getDateOfEntry();
        if (this$dateOfEntry == null ? other$dateOfEntry != null : !((Object)this$dateOfEntry).equals(other$dateOfEntry)) {
            return false;
        }
        String this$productVariantId = this.getProductVariantId();
        String other$productVariantId = other.getProductVariantId();
        if (this$productVariantId == null ? other$productVariantId != null : !this$productVariantId.equals(other$productVariantId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        ReferenceIdType this$referenceIdType = this.getReferenceIdType();
        ReferenceIdType other$referenceIdType = other.getReferenceIdType();
        if (this$referenceIdType == null ? other$referenceIdType != null : !((Object)((Object)this$referenceIdType)).equals((Object)other$referenceIdType)) {
            return false;
        }
        TransactionType this$transactionType = this.getTransactionType();
        TransactionType other$transactionType = other.getTransactionType();
        if (this$transactionType == null ? other$transactionType != null : !((Object)((Object)this$transactionType)).equals((Object)other$transactionType)) {
            return false;
        }
        TransactionReason this$transactionReason = this.getTransactionReason();
        TransactionReason other$transactionReason = other.getTransactionReason();
        if (this$transactionReason == null ? other$transactionReason != null : !((Object)((Object)this$transactionReason)).equals((Object)other$transactionReason)) {
            return false;
        }
        String this$senderId = this.getSenderId();
        String other$senderId = other.getSenderId();
        if (this$senderId == null ? other$senderId != null : !this$senderId.equals(other$senderId)) {
            return false;
        }
        SenderReceiverType this$senderType = this.getSenderType();
        SenderReceiverType other$senderType = other.getSenderType();
        if (this$senderType == null ? other$senderType != null : !((Object)((Object)this$senderType)).equals((Object)other$senderType)) {
            return false;
        }
        String this$receiverId = this.getReceiverId();
        String other$receiverId = other.getReceiverId();
        if (this$receiverId == null ? other$receiverId != null : !this$receiverId.equals(other$receiverId)) {
            return false;
        }
        SenderReceiverType this$receiverType = this.getReceiverType();
        SenderReceiverType other$receiverType = other.getReceiverType();
        if (this$receiverType == null ? other$receiverType != null : !((Object)((Object)this$receiverType)).equals((Object)other$receiverType)) {
            return false;
        }
        String this$wayBillNumber = this.getWayBillNumber();
        String other$wayBillNumber = other.getWayBillNumber();
        return !(this$wayBillNumber == null ? other$wayBillNumber != null : !this$wayBillNumber.equals(other$wayBillNumber));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Stock;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Long $dateOfEntry = this.getDateOfEntry();
        result = result * 59 + ($dateOfEntry == null ? 43 : ((Object)$dateOfEntry).hashCode());
        String $productVariantId = this.getProductVariantId();
        result = result * 59 + ($productVariantId == null ? 43 : $productVariantId.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        ReferenceIdType $referenceIdType = this.getReferenceIdType();
        result = result * 59 + ($referenceIdType == null ? 43 : ((Object)((Object)$referenceIdType)).hashCode());
        TransactionType $transactionType = this.getTransactionType();
        result = result * 59 + ($transactionType == null ? 43 : ((Object)((Object)$transactionType)).hashCode());
        TransactionReason $transactionReason = this.getTransactionReason();
        result = result * 59 + ($transactionReason == null ? 43 : ((Object)((Object)$transactionReason)).hashCode());
        String $senderId = this.getSenderId();
        result = result * 59 + ($senderId == null ? 43 : $senderId.hashCode());
        SenderReceiverType $senderType = this.getSenderType();
        result = result * 59 + ($senderType == null ? 43 : ((Object)((Object)$senderType)).hashCode());
        String $receiverId = this.getReceiverId();
        result = result * 59 + ($receiverId == null ? 43 : $receiverId.hashCode());
        SenderReceiverType $receiverType = this.getReceiverType();
        result = result * 59 + ($receiverType == null ? 43 : ((Object)((Object)$receiverType)).hashCode());
        String $wayBillNumber = this.getWayBillNumber();
        result = result * 59 + ($wayBillNumber == null ? 43 : $wayBillNumber.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Stock(productVariantId=" + this.getProductVariantId() + ", quantity=" + this.getQuantity() + ", referenceId=" + this.getReferenceId() + ", referenceIdType=" + this.getReferenceIdType() + ", transactionType=" + this.getTransactionType() + ", transactionReason=" + this.getTransactionReason() + ", senderId=" + this.getSenderId() + ", senderType=" + this.getSenderType() + ", receiverId=" + this.getReceiverId() + ", receiverType=" + this.getReceiverType() + ", wayBillNumber=" + this.getWayBillNumber() + ", isDeleted=" + this.getIsDeleted() + ", dateOfEntry=" + this.getDateOfEntry() + ")";
    }

    public Stock() {
        this.isDeleted = Stock.$default$isDeleted();
    }

    public Stock(String productVariantId, Integer quantity, String referenceId, ReferenceIdType referenceIdType, TransactionType transactionType, TransactionReason transactionReason, String senderId, SenderReceiverType senderType, String receiverId, SenderReceiverType receiverType, String wayBillNumber, Boolean isDeleted, Long dateOfEntry) {
        this.productVariantId = productVariantId;
        this.quantity = quantity;
        this.referenceId = referenceId;
        this.referenceIdType = referenceIdType;
        this.transactionType = transactionType;
        this.transactionReason = transactionReason;
        this.senderId = senderId;
        this.senderType = senderType;
        this.receiverId = receiverId;
        this.receiverType = receiverType;
        this.wayBillNumber = wayBillNumber;
        this.isDeleted = isDeleted;
        this.dateOfEntry = dateOfEntry;
    }

    public static abstract class StockBuilder<C extends Stock, B extends StockBuilder<C, B>>
    extends EgovOfflineModel.EgovOfflineModelBuilder<C, B> {
        private String productVariantId;
        private Integer quantity;
        private String referenceId;
        private ReferenceIdType referenceIdType;
        private TransactionType transactionType;
        private TransactionReason transactionReason;
        private String senderId;
        private SenderReceiverType senderType;
        private String receiverId;
        private SenderReceiverType receiverType;
        private String wayBillNumber;
        private boolean isDeleted$set;
        private Boolean isDeleted$value;
        private Long dateOfEntry;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="productVariantId")
        public B productVariantId(String productVariantId) {
            this.productVariantId = productVariantId;
            return (B)this.self();
        }

        @JsonProperty(value="quantity")
        public B quantity(Integer quantity) {
            this.quantity = quantity;
            return (B)this.self();
        }

        @JsonProperty(value="referenceId")
        public B referenceId(String referenceId) {
            this.referenceId = referenceId;
            return (B)this.self();
        }

        @JsonProperty(value="referenceIdType")
        public B referenceIdType(ReferenceIdType referenceIdType) {
            this.referenceIdType = referenceIdType;
            return (B)this.self();
        }

        @JsonProperty(value="transactionType")
        public B transactionType(TransactionType transactionType) {
            this.transactionType = transactionType;
            return (B)this.self();
        }

        @JsonProperty(value="transactionReason")
        public B transactionReason(TransactionReason transactionReason) {
            this.transactionReason = transactionReason;
            return (B)this.self();
        }

        @JsonProperty(value="senderId")
        public B senderId(String senderId) {
            this.senderId = senderId;
            return (B)this.self();
        }

        @JsonProperty(value="senderType")
        public B senderType(SenderReceiverType senderType) {
            this.senderType = senderType;
            return (B)this.self();
        }

        @JsonProperty(value="receiverId")
        public B receiverId(String receiverId) {
            this.receiverId = receiverId;
            return (B)this.self();
        }

        @JsonProperty(value="receiverType")
        public B receiverType(SenderReceiverType receiverType) {
            this.receiverType = receiverType;
            return (B)this.self();
        }

        @JsonProperty(value="wayBillNumber")
        public B wayBillNumber(String wayBillNumber) {
            this.wayBillNumber = wayBillNumber;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted$value = isDeleted;
            this.isDeleted$set = true;
            return (B)this.self();
        }

        @JsonProperty(value="dateOfEntry")
        public B dateOfEntry(Long dateOfEntry) {
            this.dateOfEntry = dateOfEntry;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Stock.StockBuilder(super=" + super.toString() + ", productVariantId=" + this.productVariantId + ", quantity=" + this.quantity + ", referenceId=" + this.referenceId + ", referenceIdType=" + this.referenceIdType + ", transactionType=" + this.transactionType + ", transactionReason=" + this.transactionReason + ", senderId=" + this.senderId + ", senderType=" + this.senderType + ", receiverId=" + this.receiverId + ", receiverType=" + this.receiverType + ", wayBillNumber=" + this.wayBillNumber + ", isDeleted$value=" + this.isDeleted$value + ", dateOfEntry=" + this.dateOfEntry + ")";
        }
    }

    private static final class StockBuilderImpl
    extends StockBuilder<Stock, StockBuilderImpl> {
        private StockBuilderImpl() {
        }

        @Override
        protected StockBuilderImpl self() {
            return this;
        }

        @Override
        public Stock build() {
            return new Stock(this);
        }
    }
}

